/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.api.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlatformInfoVisualPanel
extends BasicVisualPanel {
    private boolean attached;
    private JLabel filler;
    private JLabel plafName;
    private JTextField plafNameValue;

    public PlatformInfoVisualPanel(WizardDescriptor setting) {
        super(setting);
        this.initComponents();
        this.initAccessibility();
        this.setName(NbPlatformCustomizer.INFO_STEP);
    }

    void refreshData() {
        this.plafNameValue.setText((String)this.getSettings().getProperty("selectedPlafLabel"));
        this.checkForm();
    }

    private void checkForm() {
        String name = this.plafNameValue.getText().trim();
        if (name.equals("")) {
            this.setError(PlatformInfoVisualPanel.getMessage("MSG_BlankPlatformName"));
        } else if (!NbPlatform.isLabelValid(name) || NbPlatform.getPlatformByID(name.replace(' ', '_')) != null) {
            this.setError(PlatformInfoVisualPanel.getMessage("MSG_NameIsAlreadyUsed"));
        } else {
            this.markValid();
        }
    }

    void storeData() {
        this.getSettings().putProperty("selectedPlafLabel", (Object)this.plafNameValue.getText().trim());
    }

    public void addNotify() {
        super.addNotify();
        if (!this.attached) {
            this.plafNameValue.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent e) {
                    PlatformInfoVisualPanel.this.checkForm();
                }
            });
            this.attached = true;
        }
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(PlatformInfoVisualPanel.class, (String)key);
    }

    private void initComponents() {
        this.plafName = new JLabel();
        this.plafNameValue = new JTextField();
        this.filler = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.plafName, (String)NbBundle.getMessage(PlatformInfoVisualPanel.class, (String)"LBL_PlatformName_P"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.plafName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.plafNameValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.add(this.filler, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PlatformInfoVisualPanel.getMessage("ACS_PlatformInfoVisualPanel"));
        this.plafNameValue.getAccessibleContext().setAccessibleDescription(PlatformInfoVisualPanel.getMessage("ACS_CTL_plafNameValue"));
    }
}

