/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.kenai;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class KenaiNotificationListener
extends VCSKenaiAccessor.KenaiNotificationListener {
    protected void handleVCSNotification(VCSKenaiAccessor.VCSKenaiNotification notification) {
        if (notification.getService() != VCSKenaiAccessor.Service.VCS_HG) {
            Mercurial.LOG.fine("rejecting VCS notification " + notification + " because not from hg");
            return;
        }
        File projectDir = notification.getProjectDirectory();
        if (!Mercurial.getInstance().isManaged(projectDir)) {
            assert (false) : " project " + projectDir + " not managed";
            Mercurial.LOG.fine("rejecting VCS notification " + notification + " for " + projectDir + " because not versioned by hg");
            return;
        }
        Mercurial.LOG.fine("accepting VCS notification " + notification + " for " + projectDir);
        File[] files = Mercurial.getInstance().getFileStatusCache().listFiles(new File[]{projectDir}, 6612);
        List modifications = notification.getModifications();
        LinkedList<File> notifyFiles = new LinkedList<File>();
        String revision = null;
        block0: for (File file : files) {
            String path = HgUtils.getRelativePath(file);
            if (path == null) {
                assert (false) : file.getAbsolutePath() + " - no relative path";
                continue;
            }
            path = this.trim(path);
            for (VCSKenaiAccessor.VCSKenaiModification modification : modifications) {
                String resource = modification.getResource();
                resource = this.trim(resource);
                LOG.finer(" changed file " + path + ", " + resource);
                if (!path.equals(resource)) continue;
                LOG.fine("  will notify " + file + ", " + notification);
                notifyFiles.add(file);
                if (revision != null) continue block0;
                revision = modification.getId();
                continue block0;
            }
        }
        if (notifyFiles.size() > 0) {
            this.notifyFileChange(notifyFiles.toArray(new File[notifyFiles.size()]), projectDir, notification.getUri().toString(), revision);
        }
    }

    protected void setupPane(JTextPane pane, File[] files, File projectDir, String url, String revision) {
        String text = NbBundle.getMessage(KenaiNotificationListener.class, (String)"MSG_NotificationBubble_Description", (Object)this.getFileNames(files), (Object)HgKenaiAccessor.getInstance().getRevisionUrl(url, revision));
        pane.setText(text);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    URL url = e.getURL();
                    assert (url != null);
                    HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                    assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
                    if (displayer != null) {
                        displayer.showURL(url);
                    } else {
                        Mercurial.LOG.info("No URLDisplayer found.");
                    }
                }
            }
        });
    }
}

