#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: idris
version: 1.3.1
id: idris-1.3.1-F5mNFccfN5oJNsqkIYemr
key: idris-1.3.1-F5mNFccfN5oJNsqkIYemr
license: BSD-3-Clause
maintainer: Edwin Brady <eb@cs.st-andrews.ac.uk>
author: Edwin Brady
stability: Beta
homepage: http://www.idris-lang.org/
synopsis: Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <http://www.idris-lang.org/documentation>.
    Features include:
    .
    * Full, first class, dependent types with dependent pattern matching
    .
    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings
    .
    * Interfaces (similar to type classes), monad comprehensions
    .
    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs
    .
    * Totality checking
    .
    * Coinductive types
    .
    * Indentation significant syntax, extensible syntax
    .
    * Cumulative universes
    .
    * Simple foreign function interface (to C)
    .
    * Hugs style interactive environment
category: Compilers/Interpreters, Dependent Types
abi: b10bc92dbe017c3c6ded08c2e83d6ed9
exposed: True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System
hidden-modules: Util.Pretty Util.Net Paths_idris Version_idris
                Tools_idris BuildFlags_idris
import-dirs: /usr/lib/ghc-8.6.5/site-local/idris-1.3.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/idris-1.3.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/idris
hs-libraries: HSidris-1.3.1-F5mNFccfN5oJNsqkIYemr
extra-libraries:
    gmp
depends:
    aeson-1.4.2.0-4xcoKSM2rCuFeYBdCYWLDU
    annotated-wl-pprint-0.7.0-DGkZQ2VEej1K9q8cmlJu7D
    ansi-terminal-0.8.2-8WQDEUM7Kz3DSmwgHomKFP
    ansi-wl-pprint-0.6.8.2-IorYGC2IHKLB6bH0iJmQIJ array-0.5.3.0
    async-2.2.1-GYH0rb5jjEHH7NChV9fWYh base-4.12.0.0
    base64-bytestring-1.0.0.2-EJ1mkGsqs004EmS9lh2uZC binary-0.8.6.0
    blaze-html-0.9.1.1-A8LR7w4yS96GtRVO7i7OSl
    blaze-markup-0.8.2.2-IwLwNWRUxfsEuYbkQ0Gv5Q bytestring-0.10.8.2
    cheapskate-0.1.1.1-ojzf2R089c104FMXp7znK
    code-page-0.2-3TjNtc9lu3RJN6poyFdQXs containers-0.6.0.1
    deepseq-1.4.4.0 directory-1.3.3.0 filepath-1.4.2.1
    fingertree-0.1.4.2-1pfQ89nAa7tK8TACGnhP3j
    fsnotify-0.3.0.1-A8IeixzyDg6upYpdHJh8I haskeline-0.7.4.3
    ieee754-0.8.0-IfCS1Dp7pQVIOQRslM6kD
    libffi-0.1-B7BBBCt8Sd58IwpXe6mL8r
    megaparsec-6.5.0-8035R15dUwjEJsR1SJA1dR mtl-2.2.2
    network-2.8.0.0-g7zeLS1MQKFu6rNI1xGwt
    optparse-applicative-0.14.3.0-6K67dnjFISmWjyySSwRel pretty-1.1.3.6
    process-1.6.5.0 regex-tdfa-1.2.3.1-KcIcA5zjtfPBFphuPbNC37
    safe-0.3.17-43oyx4B630gDZMbTh3Ttji
    split-0.2.3.3-DmDMlgWSMW26OczFIiZ5Gr
    terminal-size-0.3.2.1-Hh6hFaOyLfiJ6x0AenX2yY text-1.2.3.1
    time-1.8.0.2 transformers-0.5.6.2
    uniplate-1.6.12-D1B9e4S36uhTArFMKIWAf unix-2.7.2.2
    unordered-containers-0.2.10.0-5bnYBnE7Vkj9Kd62fWith8
    utf8-string-1.0.1.1-Geq8jdOv4Q3LkcQoEOWDVv
    vector-0.12.0.2-AoZ9EwUsgIW1yrOc105QXH
    vector-binary-instances-0.2.5.1-D99ZmWt6MS3AuLha13B1Ep
    zip-archive-0.4.1-9I9OGegDGMgItuKIkKI9YK
haddock-interfaces: /usr/share/doc/idris/html/idris.haddock
haddock-html: /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

