#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: texmath
version: 0.11.2.2
id: texmath-0.11.2.2-KBZO6T8jBJX3SSGZfaquC8
key: texmath-0.11.2.2-KBZO6T8jBJX3SSGZfaquC8
license: GPL-2.0-only
maintainer: jgm@berkeley.edu
author: John MacFarlane, Matthew Pickering
stability: Experimental
homepage: http://github.com/jgm/texmath
synopsis: Conversion between formats used to represent mathematics.
description:
    The texmath library provides functions to read and
    write TeX math, presentation MathML, and OMML (Office
    Math Markup Language, used in Microsoft Office).
    Support is also included for converting math formats
    to Gnu eqn and to pandoc'\''s native format (allowing
    conversion, via pandoc, to a variety of different
    markup formats).  The TeX reader supports basic LaTeX
    and AMS extensions, and it can parse and apply LaTeX
    macros.  (See <http://johnmacfarlane.net/texmath here>
    for a live demo of bidirectional conversion between LaTeX
    and MathML.)
    .
    The package also includes several utility modules which
    may be useful for anyone looking to manipulate either
    TeX math or MathML.  For example, a copy of the MathML
    operator dictionary is included.
    .
    Use the @executable@ flag to install a standalone
    executable, @texmath@, that by default reads a LaTeX
    formula from @stdin@ and writes MathML to @stdout@.
    With flags all the functionality exposed by
    '\''Text.TeXMath'\'' can be accessed through this executable.
    (Use the @--help@ flag for a description of all
    functionality)
    .
    The @texmath@ executable can also be used as a CGI
    script, when renamed as @texmath-cgi@.
    It will expect query parameters for @from@, @to@,
    @input@, and optionally @inline@, and return a JSON
    object with either @error@ and a message or
    @success@ and the converted result.
category: Text
abi: f42eb49631a1c1256965204f61782e35
exposed: True
exposed-modules:
    Text.TeXMath Text.TeXMath.Readers.MathML
    Text.TeXMath.Readers.MathML.EntityMap
    Text.TeXMath.Readers.MathML.MMLDict Text.TeXMath.Readers.OMML
    Text.TeXMath.Readers.TeX Text.TeXMath.Readers.TeX.Macros
    Text.TeXMath.TeX Text.TeXMath.Types Text.TeXMath.Unicode.Fonts
    Text.TeXMath.Unicode.ToTeX Text.TeXMath.Unicode.ToUnicode
    Text.TeXMath.Writers.Eqn Text.TeXMath.Writers.MathML
    Text.TeXMath.Writers.OMML Text.TeXMath.Writers.Pandoc
    Text.TeXMath.Writers.TeX
hidden-modules: Text.TeXMath.Compat Text.TeXMath.Shared
                Paths_texmath
import-dirs: /usr/lib/ghc-8.6.5/site-local/texmath-0.11.2.2
library-dirs: /usr/lib/ghc-8.6.5/site-local/texmath-0.11.2.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/texmath-0.11.2.2
hs-libraries: HStexmath-0.11.2.2-KBZO6T8jBJX3SSGZfaquC8
depends:
    base-4.12.0.0 containers-0.6.0.1 mtl-2.2.2
    pandoc-types-1.17.5.4-AvuRXMYawnf5EZ5J8JHgYt parsec-3.1.13.0
    syb-0.7-KRW1LCxdMiCJrmhxCvzo37 xml-1.3.14-ESp8cJy4XJ8BJKfvGeNymT
haddock-interfaces: /usr/share/doc/haskell-texmath/html/texmath.haddock
haddock-html: /usr/share/doc/haskell-texmath/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

