/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "matrix.h"
#include "gmp.h"
#include "zass.h"

/**************************************************************************
@
@ -------------------------------------------------------------------------
@
***************************************************************************/
matrix_TYP *convert_to_cozycle(matrix_TYP *x,matrix_TYP *cozycle,
                               matrix_TYP *D)
{

   int i,
       j,
       first,
       last,
       factor;

   matrix_TYP *erg;

   erg = init_mat(cozycle->rows,1,"");

   /* set first and last */
   for (first = 0;first<D->cols && D->array.SZ[first][first] == 1;first++);
   for (last = 0;last<D->cols && D->array.SZ[last][last] != 0;last++);

   for (i=first;i<last;i++){
      factor = x->array.SZ[i-first][0] *
               D->array.SZ[last-1][last-1] / D->array.SZ[i][i];
      for (j=0;j<erg->rows;j++){
         erg->array.SZ[j][0] += (cozycle->array.SZ[j][i-first] * factor);
      }
   }

   erg->kgv = D->array.SZ[last-1][last-1];
   erg->flags.Integral = FALSE;

   Check_mat(erg);

   return erg;
}

