/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.TableResizeHelper;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryViewerSorter;
import org.eclipse.cft.server.ui.internal.editor.ServicesHandler;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ServiceToApplicationsBindingPart
extends UIPart {
    private CheckboxTableViewer viewer;
    ServicesHandler servicesHandler;
    private HashMap<String, ApplicationToService> applicationToServiceMapping = new HashMap();

    public ServiceToApplicationsBindingPart(ServicesHandler servicesHandler) {
        this.servicesHandler = servicesHandler;
    }

    public List<ApplicationToService> getApplicationToService() {
        ArrayList<ApplicationToService> returnList = new ArrayList<ApplicationToService>();
        for (Map.Entry<String, ApplicationToService> pairs : this.applicationToServiceMapping.entrySet()) {
            returnList.add(pairs.getValue());
        }
        return returnList;
    }

    @Override
    public Control createPart(Composite parent) {
        Composite generalArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(generalArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)generalArea);
        this.createTableArea(generalArea);
        return generalArea;
    }

    protected void createTableArea(Composite parent) {
        Composite tableArea = new Composite(parent, 0);
        Label l = new Label(tableArea, 0);
        l.setBackground(parent.getBackground());
        l.setText(Messages.MANAGE_SERVICES_TO_APPLICATIONS_SELECTION_DESCRIPTION);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(tableArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
        Table table = new Table(tableArea, 2080);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray(new Object[0]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new BindServiceToApplicationLabelProvider((TableViewer)this.viewer));
        this.viewer.setSorter((ViewerSorter)new CloudFoundryViewerSorter());
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget item = event.item;
                if (event.detail == 32 && item != null && item instanceof TableItem) {
                    TableItem tableItem = (TableItem)item;
                    String appName = tableItem.getText();
                    ApplicationToService curr = (ApplicationToService)ServiceToApplicationsBindingPart.this.applicationToServiceMapping.get(appName);
                    if (curr != null) {
                        curr.setBoundToServiceAfter(tableItem.getChecked());
                    }
                }
            }
        });
        new TableColumn(table, 0, 0);
        TableResizeHelper resizer = new TableResizeHelper((TableViewer)this.viewer);
        resizer.enableResizing();
    }

    public void setInput(List<CloudApplication> cloudApplications) {
        if (this.viewer != null) {
            this.viewer.setInput(cloudApplications);
            Table table = this.viewer.getTable();
            if (table != null) {
                int len = table.getItemCount();
                String serviceName = this.servicesHandler.toString();
                int i = 0;
                while (i < len) {
                    Object objCloudApplication;
                    TableItem tableItem = table.getItem(i);
                    if (tableItem != null && (objCloudApplication = tableItem.getData()) instanceof CloudApplication) {
                        CloudApplication cloudApp = (CloudApplication)objCloudApplication;
                        List serviceList = cloudApp.getServices();
                        tableItem.setChecked(serviceList.contains(serviceName));
                        ApplicationToService applicationToService = new ApplicationToService(cloudApp, serviceList.contains(serviceName));
                        this.applicationToServiceMapping.put(cloudApp.getName(), applicationToService);
                    }
                    ++i;
                }
            }
        }
    }

    public class ApplicationToService {
        private boolean boundToServiceBefore = false;
        private boolean boundToServiceAfter = false;
        private CloudApplication cloudApplication = null;

        public ApplicationToService(CloudApplication cloudApplication, boolean boundToServiceBefore) {
            this.cloudApplication = cloudApplication;
            this.boundToServiceBefore = boundToServiceBefore;
            this.boundToServiceAfter = boundToServiceBefore;
        }

        public void setBoundToServiceAfter(boolean boundToServiceAfter) {
            this.boundToServiceAfter = boundToServiceAfter;
        }

        public boolean getBoundToServiceBefore() {
            return this.boundToServiceBefore;
        }

        public boolean getBoundToServiceAfter() {
            return this.boundToServiceAfter;
        }

        public CloudApplication getCloudApplication() {
            return this.cloudApplication;
        }
    }

    protected class BindServiceToApplicationLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final TableViewer viewer;

        public BindServiceToApplicationLabelProvider(TableViewer viewer) {
            this.viewer = viewer;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = null;
            TableColumn column = this.viewer.getTable().getColumn(columnIndex);
            if (column != null) {
                CloudApplication app = (CloudApplication)element;
                result = app.getName();
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

