/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.editor;

import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.linuxtools.internal.docker.editor.DockerEditor;
import org.eclipse.linuxtools.internal.docker.editor.DockerHover;
import org.eclipse.linuxtools.internal.docker.editor.DockerPresentationReconciler;
import org.eclipse.linuxtools.internal.docker.editor.assist.CompletionProcessor;
import org.eclipse.linuxtools.internal.docker.editor.syntax.SyntaxReconcilingStrategy;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class DockerConfiguration
extends TextSourceViewerConfiguration {
    private DockerEditor editor;
    private DockerHover hover;

    public DockerConfiguration(DockerEditor editor) {
        this.editor = editor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return new DockerPresentationReconciler();
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        Reconciler reconciler = new Reconciler();
        SyntaxReconcilingStrategy strategy = new SyntaxReconcilingStrategy(this.editor);
        reconciler.setReconcilingStrategy((IReconcilingStrategy)strategy, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant ca = new ContentAssistant();
        CompletionProcessor cap = new CompletionProcessor();
        ca.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
        ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return ca;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.hover == null) {
            this.hover = new DockerHover();
        }
        return this.hover;
    }
}

