/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.texteditor.AnnotationPreference;

public final class AnnotationType {
    private String fType;
    private String[] fSuperTypes;
    private AnnotationPreference fPreference;

    public AnnotationType(String type, String[] superTypes) {
        this.fType = type;
        this.fSuperTypes = TextUtilities.copy((String[])superTypes);
    }

    public String getType() {
        return this.fType;
    }

    public String[] getSuperTypes() {
        return this.fSuperTypes;
    }

    public AnnotationPreference getPreference() {
        return this.fPreference;
    }

    public void setAnnotationPreference(AnnotationPreference preference) {
        this.fPreference = preference;
    }

    public boolean isSubtype(String superType) {
        if (this.fSuperTypes == null || superType == null) {
            return false;
        }
        if (superType.equals(this.fType)) {
            return true;
        }
        int i = this.fSuperTypes.length - 1;
        while (i > -1) {
            if (superType.equals(this.fSuperTypes[i])) {
                return true;
            }
            --i;
        }
        return false;
    }
}

