/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceProvider;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.OSDescriptor;
import org.jkiss.dbeaver.utils.WinRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class MySQLDataSourceProvider
extends JDBCDataSourceProvider
implements DBPNativeClientLocationManager {
    private static final Log log = Log.getLog(MySQLDataSourceProvider.class);
    private static final String REGISTRY_ROOT_MYSQL_32 = "SOFTWARE\\MySQL AB";
    private static final String REGISTRY_ROOT_MYSQL_64 = "SOFTWARE\\Wow6432Node\\MYSQL AB";
    private static final String REGISTRY_ROOT_MARIADB = "SOFTWARE\\Monty Program AB";
    private static final String SERER_LOCATION_KEY = "Location";
    private static final String INSTALLDIR_KEY = "INSTALLDIR";
    private static Map<String, MySQLServerHome> localServers = null;
    private static Map<String, String> connectionsProps = new HashMap<String, String>();

    static {
        connectionsProps.put("characterEncoding", "UTF-8");
        connectionsProps.put("tinyInt1isBit", "false");
    }

    public static Map<String, String> getConnectionsProps() {
        return connectionsProps;
    }

    protected String getConnectionPropertyDefaultValue(String name, String value) {
        String ovrValue = connectionsProps.get(name);
        return ovrValue != null ? ovrValue : super.getConnectionPropertyDefaultValue(name, value);
    }

    public long getFeatures() {
        return 2L;
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:mysql://").append(connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            url.append(":").append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new MySQLDataSource(monitor, container);
    }

    public List<DBPNativeClientLocation> findLocalClientLocations() {
        MySQLDataSourceProvider.findLocalClients();
        return new ArrayList<MySQLServerHome>(localServers.values());
    }

    public DBPNativeClientLocation getDefaultLocalClientLocation() {
        MySQLDataSourceProvider.findLocalClients();
        return localServers.isEmpty() ? null : (DBPNativeClientLocation)localServers.values().iterator().next();
    }

    public String getProductName(DBPNativeClientLocation location) throws DBException {
        return "MySQL/MariaDB";
    }

    public String getProductVersion(DBPNativeClientLocation location) throws DBException {
        return MySQLDataSourceProvider.getFullServerVersion(location.getPath());
    }

    public static MySQLServerHome getServerHome(String homeId) {
        MySQLDataSourceProvider.findLocalClients();
        MySQLServerHome home = localServers.get(homeId);
        return home == null ? new MySQLServerHome(homeId, homeId) : home;
    }

    public static synchronized void findLocalClients() {
        OSDescriptor localSystem;
        if (localServers != null) {
            return;
        }
        localServers = new LinkedHashMap<String, MySQLServerHome>();
        String path = System.getenv("PATH");
        if (path != null) {
            String[] stringArray = path.split(System.getProperty("path.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File binFolder;
                String token = stringArray[n2];
                File mysqlFile = new File(token = CommonUtils.removeTrailingSlash((String)token), MySQLUtils.getMySQLConsoleBinaryName());
                if (mysqlFile.exists() && (binFolder = mysqlFile.getAbsoluteFile().getParentFile()).getName().equalsIgnoreCase("bin")) {
                    String homeId = CommonUtils.removeTrailingSlash((String)binFolder.getParentFile().getAbsolutePath());
                    localServers.put(homeId, new MySQLServerHome(homeId, null));
                }
                ++n2;
            }
        }
        if ((localSystem = DBeaverCore.getInstance().getLocalSystem()).isWindows()) {
            try {
                List homeKeys;
                String registryRoot = localSystem.is64() ? REGISTRY_ROOT_MYSQL_64 : REGISTRY_ROOT_MYSQL_32;
                List homeKeys2 = WinRegistry.readStringSubKeys((int)-2147483646, (String)registryRoot);
                if (homeKeys2 != null) {
                    for (String homeKey : homeKeys2) {
                        Map valuesMap = WinRegistry.readStringValues((int)-2147483646, (String)(String.valueOf(registryRoot) + "\\" + homeKey));
                        if (valuesMap == null) continue;
                        for (String key : valuesMap.keySet()) {
                            String serverPath;
                            if (!SERER_LOCATION_KEY.equalsIgnoreCase(key) || !new File(serverPath = CommonUtils.removeTrailingSlash((String)((String)valuesMap.get(key))), "bin").exists()) continue;
                            localServers.put(serverPath, new MySQLServerHome(serverPath, homeKey));
                        }
                    }
                }
                if ((homeKeys = WinRegistry.readStringSubKeys((int)-2147483646, (String)REGISTRY_ROOT_MARIADB)) != null) {
                    for (String homeKey : homeKeys) {
                        Map valuesMap = WinRegistry.readStringValues((int)-2147483646, (String)("SOFTWARE\\Monty Program AB\\" + homeKey));
                        if (valuesMap == null) continue;
                        for (String key : valuesMap.keySet()) {
                            String serverPath;
                            if (!INSTALLDIR_KEY.equalsIgnoreCase(key) || !new File(serverPath = CommonUtils.removeTrailingSlash((String)((String)valuesMap.get(key))), "bin").exists()) continue;
                            localServers.put(serverPath, new MySQLServerHome(serverPath, homeKey));
                        }
                    }
                }
            }
            catch (Throwable e) {
                log.warn((Object)"Error reading Windows registry", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getFullServerVersion(File path) {
        File binPath = path;
        File binSubfolder = new File(binPath, "bin");
        if (binSubfolder.exists()) {
            binPath = binSubfolder;
        }
        String cmd = new File(binPath, MySQLUtils.getMySQLConsoleBinaryName()).getAbsolutePath();
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cmd, "-V"});
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    String line;
                    int pos;
                    do {
                        if ((line = input.readLine()) != null) continue;
                        return null;
                    } while ((pos = line.indexOf("Distrib ")) == -1);
                    int pos2 = line.indexOf(",", pos += 8);
                    String string = line.substring(pos, pos2);
                    return string;
                }
                finally {
                    IOUtils.close((Closeable)input);
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Error reading MySQL server version from " + cmd), (Throwable)ex);
        }
        return null;
    }
}

