/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Sequence;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;
import org.jkiss.utils.CommonUtils;

public class DB2SequenceManager
extends SQLObjectEditor<DB2Sequence, DB2Schema> {
    private static final String SQL_CREATE = "CREATE SEQUENCE ";
    private static final String SQL_ALTER = "ALTER SEQUENCE ";
    private static final String SQL_DROP = "DROP SEQUENCE %s";
    private static final String SQL_COMMENT = "COMMENT ON SEQUENCE %s IS '%s'";
    private static final String SPACE = "\n   ";

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((DB2Sequence)command.getObject()).getName())) {
            throw new DBException("Sequence name cannot be empty");
        }
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, DB2Sequence> getObjectsCache(DB2Sequence object) {
        return object.getSchema().getSequenceCache();
    }

    protected DB2Sequence createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final DB2Schema schema, Object copyFrom) {
        return (DB2Sequence)new UITask<DB2Sequence>(){

            protected DB2Sequence runTask() {
                EntityEditPage page = new EntityEditPage((DBPDataSource)schema.getDataSource(), DBSEntityType.SEQUENCE);
                if (!page.edit()) {
                    return null;
                }
                return new DB2Sequence(schema, page.getEntityName());
            }
        }.execute();
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        String sql = this.buildStatement((DB2Sequence)command.getObject(), false);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Sequence", sql));
        String comment = this.buildComment((DB2Sequence)command.getObject());
        if (comment != null) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Sequence", comment));
        }
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        String sql = this.buildStatement((DB2Sequence)command.getObject(), true);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter Sequence", sql));
        String comment = this.buildComment((DB2Sequence)command.getObject());
        if (comment != null) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Comment on Sequence", comment));
        }
    }

    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        String sql = String.format(SQL_DROP, ((DB2Sequence)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL));
        SQLDatabasePersistAction action = new SQLDatabasePersistAction("Drop Sequence", sql);
        actions.add((DBEPersistAction)action);
    }

    private String buildStatement(DB2Sequence sequence, Boolean forUpdate) {
        StringBuilder sb = new StringBuilder(256);
        if (forUpdate.booleanValue()) {
            sb.append(SQL_ALTER);
        } else {
            sb.append(SQL_CREATE);
        }
        sb.append(sequence.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(SPACE);
        if (!forUpdate.booleanValue()) {
            sb.append("AS ");
            sb.append(sequence.getPrecision().getSqlKeyword()).append(SPACE);
        }
        if (sequence.getStart() != null) {
            if (forUpdate.booleanValue()) {
                sb.append("RESTART WITH ").append(sequence.getStart()).append(SPACE);
            } else {
                sb.append("START WITH ").append(sequence.getStart()).append(SPACE);
            }
        }
        if (sequence.getIncrementBy() != null) {
            sb.append("INCREMENT BY ").append(sequence.getIncrementBy()).append(SPACE);
        }
        if (sequence.getMinValue() != null) {
            sb.append("MINVALUE ").append(sequence.getMinValue()).append(SPACE);
        }
        if (sequence.getMaxValue() != null) {
            sb.append("MAXVALUE ").append(sequence.getMaxValue()).append(SPACE);
        }
        if (sequence.getCycle().booleanValue()) {
            sb.append("CYCLE ").append(SPACE);
        } else {
            sb.append("NO CYCLE ").append(SPACE);
        }
        if (sequence.getCache() != null && sequence.getCache() > 0) {
            sb.append("CACHE ").append(sequence.getCache()).append(SPACE);
        } else {
            sb.append("NO CACHE ").append(SPACE);
        }
        if (sequence.getOrder().booleanValue()) {
            sb.append("ORDER ").append(SPACE);
        } else {
            sb.append("NO ORDER ").append(SPACE);
        }
        return sb.toString();
    }

    private String buildComment(DB2Sequence sequence) {
        if (sequence.getDescription() != null && sequence.getDescription().length() > 0) {
            return String.format(SQL_COMMENT, sequence.getFullyQualifiedName(DBPEvaluationContext.DDL), sequence.getDescription());
        }
        return null;
    }
}

