/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProjectManager;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;

public class DBNProject
extends DBNResource {
    private static final Log log = Log.getLog(DBNProject.class);

    public DBNProject(DBNNode parentNode, IProject project, DBPResourceHandler handler) {
        super(parentNode, (IResource)project, handler);
        this.getModel().getPlatform().getProjectManager().addProject(project);
    }

    @Override
    protected void dispose(boolean reflect) {
        IProject project = this.getProject();
        super.dispose(reflect);
        this.getModel().getPlatform().getProjectManager().removeProject(project);
    }

    public IProject getProject() {
        return (IProject)this.getResource();
    }

    public DBNProjectDatabases getDatabases() {
        try {
            DBNNode[] dBNNodeArray = this.getChildren(new VoidProgressMonitor());
            int n = dBNNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode db = dBNNodeArray[n2];
                if (db instanceof DBNProjectDatabases) {
                    return (DBNProjectDatabases)db;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            throw new IllegalStateException("Can't read project contents", e);
        }
        throw new IllegalStateException("No databases resource in project");
    }

    @Override
    public String getNodeDescription() {
        try {
            IProject project = this.getProject();
            return project == null ? null : project.getDescription().getComment();
        }
        catch (CoreException e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Override
    public DBPImage getNodeIcon() {
        return DBIcon.PROJECT;
    }

    @Override
    public boolean allowsOpen() {
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBNProject.class) {
            return adapter.cast(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean supportsRename() {
        return this.getModel().getPlatform().getProjectManager().getActiveProject() != this.getProject();
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        try {
            IProjectDescription description = this.getProject().getDescription();
            description.setName(newName);
            this.getProject().move(description, true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Can't rename project", e);
        }
    }

    @Override
    public DBNNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.folder.placeholders")) {
            ArrayList<DBNNode> children = new ArrayList<DBNNode>();
            Collections.addAll(children, super.getChildren(monitor));
            children.removeIf(node -> node instanceof DBNResource && !((DBNResource)node).getResource().exists());
            return children.toArray(new DBNNode[0]);
        }
        return super.getChildren(monitor);
    }

    @Override
    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        IProject project = this.getProject();
        if (!project.isOpen()) {
            try {
                project.open(monitor.getNestedMonitor());
                project.refreshLocal(1, monitor.getNestedMonitor());
            }
            catch (CoreException e) {
                throw new DBException("Can't open project '" + project.getName() + "'", e);
            }
        }
        DBPDataSourceRegistry dataSourceRegistry = this.getModel().getPlatform().getProjectManager().getDataSourceRegistry(project);
        Object[] children = super.readChildNodes(monitor);
        if (dataSourceRegistry != null) {
            children = (DBNNode[])ArrayUtils.insertArea(DBNNode.class, (Object[])children, (int)0, (Object[])new Object[]{new DBNProjectDatabases(this, dataSourceRegistry)});
        }
        return children;
    }

    @Override
    protected IResource[] addImplicitMembers(IResource[] members) {
        DBPProjectManager projectManager = this.getModel().getPlatform().getProjectManager();
        DBPResourceHandlerDescriptor[] dBPResourceHandlerDescriptorArray = projectManager.getAllResourceHandlers();
        int n = dBPResourceHandlerDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPResourceHandlerDescriptor rh = dBPResourceHandlerDescriptorArray[n2];
            IFolder rhDefaultRoot = projectManager.getResourceDefaultRoot(this.getProject(), rh, false);
            if (rhDefaultRoot != null && !rhDefaultRoot.exists()) {
                members = (IResource[])ArrayUtils.add(IResource.class, (Object[])members, (Object)rhDefaultRoot);
            }
            ++n2;
        }
        return super.addImplicitMembers(members);
    }

    public DBNResource findResource(IResource resource) {
        ArrayList<IResource> path = new ArrayList<IResource>();
        IResource parent = resource;
        while (!(parent instanceof IProject)) {
            path.add(0, parent);
            parent = parent.getParent();
        }
        DBNResource resNode = this;
        for (IResource res : path) {
            try {
                ((DBNResource)resNode).getChildren(new VoidProgressMonitor());
            }
            catch (DBException e) {
                log.error(e);
            }
            resNode = resNode.getChild(res);
            if (resNode != null) continue;
            return null;
        }
        return resNode;
    }

    @Override
    protected void handleChildResourceChange(IResourceDelta delta) {
        String name = delta.getResource().getName();
        if (name.startsWith(".dbeaver-data-sources") && name.endsWith(".xml")) {
            this.getDatabases().getDataSourceRegistry().refreshConfig();
        } else {
            super.handleChildResourceChange(delta);
        }
    }

    public void openProject() {
        DBNProjectDatabases databases = this.getDatabases();
        if (databases != null) {
            databases.getDataSourceRegistry().refreshConfig();
        }
    }
}

