/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCDatabaseMetaDataImpl;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCSavepointImpl;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCStatementImpl;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class JDBCConnectionImpl
extends AbstractSession
implements JDBCSession,
DBRBlockingObject {
    private static final Log log = Log.getLog(JDBCConnectionImpl.class);
    @NotNull
    final JDBCExecutionContext context;

    public JDBCConnectionImpl(@NotNull JDBCExecutionContext context, @NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        super(monitor, purpose, taskTitle);
        this.context = context;
    }

    @Override
    public Connection getOriginal() throws SQLException {
        return this.context.getConnection(this.getProgressMonitor());
    }

    @Override
    @NotNull
    public JDBCExecutionContext getExecutionContext() {
        return this.context;
    }

    @Override
    @NotNull
    public JDBCDataSource getDataSource() {
        return (JDBCDataSource)this.context.getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        try {
            JDBCExecutionContext jDBCExecutionContext = this.context;
            synchronized (jDBCExecutionContext) {
                return !this.isClosed();
            }
        }
        catch (SQLException e) {
            log.error("could not check connection state", e);
            return false;
        }
    }

    @Override
    @NotNull
    public JDBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String sqlQuery, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        try {
            JDBCPreparedStatement dbStat;
            if (type == DBCStatementType.EXEC && JDBCUtils.queryHasOutputParameters(this.getDataSource().getSQLDialect(), sqlQuery)) {
                try {
                    return this.prepareCall(sqlQuery, scrollable ? 1004 : 1003, updatable ? 1008 : 1007);
                }
                catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
                    return this.prepareStatement(DBCStatementType.QUERY, sqlQuery, scrollable, updatable, returnGeneratedKeys);
                }
                catch (IncompatibleClassChangeError | UnsupportedOperationException | SQLFeatureNotSupportedException throwable) {
                    return this.prepareCall(sqlQuery);
                }
                catch (SQLException e) {
                    if (DBUtils.discoverErrorType(this.getDataSource(), e) == DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED) {
                        return this.prepareCall(sqlQuery);
                    }
                    throw e;
                }
            }
            if (type == DBCStatementType.SCRIPT) {
                JDBCStatement statement;
                try {
                    statement = !scrollable && !updatable ? this.createStatement(1003, 1007) : this.createStatement(scrollable ? 1004 : 1003, updatable ? 1008 : 1007);
                }
                catch (Throwable e) {
                    try {
                        statement = this.createStatement();
                    }
                    catch (Throwable throwable) {
                        try {
                            statement = this.prepareStatement(sqlQuery, scrollable ? 1004 : 1003, updatable ? 1008 : 1007);
                        }
                        catch (Throwable throwable2) {
                            log.debug(e);
                            statement = this.prepareStatement(sqlQuery);
                        }
                    }
                }
                if (statement instanceof JDBCStatementImpl) {
                    statement.setQueryString(sqlQuery);
                }
                if (((JDBCDataSource)this.context.getDataSource()).getSQLDialect().isDisableScriptEscapeProcessing()) {
                    this.disableStatementEscapeProcessing(statement);
                }
                return statement;
            }
            if (returnGeneratedKeys) {
                try {
                    return this.prepareStatement(sqlQuery, 1);
                }
                catch (IncompatibleClassChangeError | UnsupportedOperationException | SQLFeatureNotSupportedException throwable) {
                    return this.prepareStatement(sqlQuery);
                }
                catch (SQLException e) {
                    if (DBUtils.discoverErrorType(this.getDataSource(), e) == DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED) {
                        return this.prepareStatement(sqlQuery);
                    }
                    throw e;
                }
            }
            try {
                dbStat = this.prepareStatement(sqlQuery, scrollable ? 1004 : 1003, updatable ? 1008 : 1007);
            }
            catch (IncompatibleClassChangeError | UnsupportedOperationException | SQLFeatureNotSupportedException throwable) {
                dbStat = this.prepareStatement(sqlQuery);
            }
            catch (SQLException e) {
                if (DBUtils.discoverErrorType(this.getDataSource(), e) == DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED) {
                    dbStat = this.prepareStatement(sqlQuery);
                }
                throw e;
            }
            return dbStat;
        }
        catch (SQLException e) {
            throw new JDBCException(e, (DBPDataSource)this.getDataSource());
        }
    }

    private void disableStatementEscapeProcessing(JDBCStatement statement) {
        if (statement != null) {
            try {
                statement.setEscapeProcessing(false);
            }
            catch (Throwable e) {
                log.debug(e);
            }
        }
    }

    @Override
    @NotNull
    public DBDValueHandler getDefaultValueHandler() {
        return ((JDBCDataSource)this.context.getDataSource()).getDefaultValueHandler();
    }

    private JDBCStatement makeStatement(Statement statement) throws SQLException {
        if (statement instanceof CallableStatement) {
            return this.createCallableStatementImpl((CallableStatement)statement, null);
        }
        if (statement instanceof PreparedStatement) {
            return this.createPreparedStatementImpl((PreparedStatement)statement, null);
        }
        return this.createStatementImpl(statement);
    }

    @Override
    @NotNull
    public JDBCStatement createStatement() throws SQLException {
        return this.makeStatement(this.getOriginal().createStatement());
    }

    @Override
    @NotNull
    public JDBCPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.createPreparedStatementImpl(this.getOriginal().prepareStatement(sql), sql);
    }

    @Override
    @NotNull
    public JDBCCallableStatement prepareCall(String sql) throws SQLException {
        return this.createCallableStatementImpl(this.getOriginal().prepareCall(sql), sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.getOriginal().nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.getOriginal().setAutoCommit(autoCommit);
        if (this.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleTransactionAutocommit(this.context, autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.getOriginal().getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.getOriginal().commit();
        if (this.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleTransactionCommit(this.context);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.getOriginal().rollback();
        if (this.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleTransactionRollback(this.context, null);
        }
    }

    @Override
    public void close() {
        DBCExecutionPurpose purpose = this.getPurpose();
        if (purpose.isUser()) {
            try {
                Connection connection = this.getOriginal();
                if (connection != null) {
                    JDBCUtils.reportWarnings(this, connection.getWarnings());
                    connection.clearWarnings();
                }
            }
            catch (Throwable e) {
                log.debug("Can't check for connection warnings", e);
            }
        }
        super.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getOriginal().isClosed();
    }

    @Override
    @NotNull
    public JDBCDatabaseMetaData getMetaData() throws SQLException {
        return new JDBCDatabaseMetaDataImpl(this, this.getOriginal().getMetaData());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.getOriginal().setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.getOriginal().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.getOriginal().setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getOriginal().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.getOriginal().setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.getOriginal().getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getOriginal().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getOriginal().clearWarnings();
    }

    @Override
    public JDBCStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatementImpl(this.getOriginal().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    @NotNull
    public JDBCPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createPreparedStatementImpl(this.getOriginal().prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    @NotNull
    public JDBCCallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createCallableStatementImpl(this.getOriginal().prepareCall(sql, resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.getOriginal().getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.getOriginal().setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.getOriginal().setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getOriginal().getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        Savepoint savepoint = this.getOriginal().setSavepoint();
        JDBCSavepointImpl jdbcSavepoint = new JDBCSavepointImpl(this.context, savepoint);
        if (this.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleTransactionSavepoint(jdbcSavepoint);
        }
        return jdbcSavepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        Savepoint savepoint = this.getOriginal().setSavepoint(name);
        JDBCSavepointImpl jdbcSavepoint = new JDBCSavepointImpl(this.context, savepoint);
        if (this.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleTransactionSavepoint(jdbcSavepoint);
        }
        return jdbcSavepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint instanceof JDBCSavepointImpl) {
            savepoint = ((JDBCSavepointImpl)savepoint).getOriginal();
        }
        this.getOriginal().rollback(savepoint);
        if (this.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleTransactionRollback(this.context, savepoint instanceof DBCSavepoint ? (DBCSavepoint)((Object)savepoint) : null);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (savepoint instanceof JDBCSavepointImpl) {
            savepoint = ((JDBCSavepointImpl)savepoint).getOriginal();
        }
        this.getOriginal().releaseSavepoint(savepoint);
    }

    @Override
    @NotNull
    public JDBCStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.makeStatement(this.getOriginal().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    @NotNull
    public JDBCPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createPreparedStatementImpl(this.getOriginal().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    @NotNull
    public JDBCCallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createCallableStatementImpl(this.getOriginal().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    @NotNull
    public JDBCPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.createPreparedStatementImpl(this.getOriginal().prepareStatement(sql, autoGeneratedKeys), sql);
    }

    @Override
    @NotNull
    public JDBCPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.createPreparedStatementImpl(this.getOriginal().prepareStatement(sql, columnIndexes), sql);
    }

    @Override
    @NotNull
    public JDBCPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.createPreparedStatementImpl(this.getOriginal().prepareStatement(sql, columnNames), sql);
    }

    @Override
    @Nullable
    public String getSchema() throws SQLException {
        return this.getOriginal().getSchema();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.getOriginal().setSchema(schema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getOriginal().abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.getOriginal().setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.getOriginal().getNetworkTimeout();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.getOriginal().createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.getOriginal().createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.getOriginal().createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.getOriginal().createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.getOriginal().isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.getOriginal().setClientInfo(name, value);
        }
        catch (SQLException e) {
            if (e instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e;
            }
            throw new SQLClientInfoException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.getOriginal().setClientInfo(properties);
        }
        catch (SQLException e) {
            if (e instanceof SQLClientInfoException) {
                throw (SQLClientInfoException)e;
            }
            log.debug(e);
            throw new SQLClientInfoException();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.getOriginal().getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.getOriginal().getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.getOriginal().createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.getOriginal().createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getOriginal().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getOriginal().isWrapperFor(iface);
    }

    @Override
    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        try {
            this.getOriginal().close();
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.getDataSource());
        }
    }

    protected JDBCStatement createStatementImpl(Statement original) throws SQLException, IllegalArgumentException {
        if (original == null) {
            throw new IllegalArgumentException("Null statement");
        }
        return ((JDBCDataSource)this.context.getDataSource()).getJdbcFactory().createStatement(this, original, !this.isLoggingEnabled());
    }

    protected JDBCPreparedStatement createPreparedStatementImpl(PreparedStatement original, @Nullable String sql) throws SQLException, IllegalArgumentException {
        if (original == null) {
            throw new IllegalArgumentException("Null statement");
        }
        return ((JDBCDataSource)this.context.getDataSource()).getJdbcFactory().createPreparedStatement(this, original, sql, !this.isLoggingEnabled());
    }

    protected JDBCCallableStatement createCallableStatementImpl(CallableStatement original, @Nullable String sql) throws SQLException, IllegalArgumentException {
        if (original == null) {
            throw new IllegalArgumentException("Null statement");
        }
        return ((JDBCDataSource)this.context.getDataSource()).getJdbcFactory().createCallableStatement(this, original, sql, !this.isLoggingEnabled());
    }
}

