/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCArrayImpl;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollectionString;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCResultSetImpl;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCDataType;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;

public class JDBCCollection
implements DBDCollection,
DBDValueCloneable {
    private static final Log log = Log.getLog(JDBCCollection.class);
    private Object[] contents;
    private final DBSDataType type;
    private final DBDValueHandler valueHandler;
    private boolean modified;

    public JDBCCollection(DBSDataType type, DBDValueHandler valueHandler, @Nullable Object[] contents) {
        this.type = type;
        this.valueHandler = valueHandler;
        this.contents = contents;
    }

    @Override
    @NotNull
    public DBSDataType getComponentType() {
        return this.type;
    }

    @Override
    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return this.valueHandler;
    }

    @Override
    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new JDBCCollection(this.type, this.valueHandler, this.contents);
    }

    @Override
    public Object getRawValue() {
        return this.contents;
    }

    @Override
    public boolean isNull() {
        return this.contents == null;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "[NULL]";
        }
        return this.makeArrayString(DBDDisplayFormat.UI);
    }

    @NotNull
    public String makeArrayString(DBDDisplayFormat format) {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.contents.length == 0) {
            return "";
        }
        if (this.contents.length == 1) {
            return this.valueHandler.getValueDisplayString(this.type, this.contents[0], format);
        }
        StringBuilder str = new StringBuilder(this.contents.length * 32);
        str.append("[");
        int i = 0;
        while (i < this.contents.length) {
            Object item = this.contents[i];
            if (i > 0) {
                str.append(',');
            }
            String itemString = this.valueHandler.getValueDisplayString(this.type, item, format);
            SQLUtils.appendValue(str, this.type, itemString);
            ++i;
        }
        str.append("]");
        return str.toString();
    }

    @Override
    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.length;
    }

    @Override
    public Object getItem(int index) {
        return this.contents[index];
    }

    @Override
    public void setItem(int index, Object value) {
        this.contents[index] = value;
        this.modified = true;
    }

    @Override
    public void setContents(Object[] contents) {
        this.contents = contents;
        this.modified = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public java.sql.Array getArrayValue() throws DBCException {
        Object attr2;
        Object[] attrs = new Object[this.contents.length];
        int i = 0;
        while (i < this.contents.length) {
            attr2 = this.contents[i];
            if (attr2 instanceof DBDValue) {
                attr2 = ((DBDValue)attr2).getRawValue();
            }
            attrs[i] = attr2;
            ++i;
        }
        DBSDataType dataType = this.getComponentType();
        try {
            attr2 = null;
            Object var4_7 = null;
            try {
                java.sql.Array array;
                Object session = DBUtils.openUtilSession(new VoidProgressMonitor(), dataType, "Create JDBC array");
                try {
                    if (session instanceof Connection) {
                        array = ((Connection)session).createArrayOf(dataType.getTypeName(), attrs);
                        return array;
                    }
                    return new JDBCArrayImpl(dataType.getTypeName(), dataType.getTypeID(), attrs);
                }
                catch (Throwable attr2) {
                    throw attr2;
                }
                finally {
                    if (session == null) return array;
                    session.close();
                }
            }
            catch (Throwable throwable) {
                if (attr2 == null) {
                    attr2 = throwable;
                    throw attr2;
                }
                if (attr2 == throwable) throw attr2;
                ((Throwable)attr2).addSuppressed(throwable);
                throw attr2;
            }
        }
        catch (Throwable e) {
            throw new DBCException("Error creating struct", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static JDBCCollection makeCollectionFromArray(@NotNull JDBCSession session, @NotNull DBSTypedObject column, java.sql.Array array) throws DBCException {
        DBSDataType arrayType;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        DBSDataType elementType = null;
        if (column instanceof DBSTypedObjectEx && (arrayType = ((DBSTypedObjectEx)((Object)column)).getDataType()) != null) {
            try {
                elementType = arrayType.getComponentType(monitor);
            }
            catch (DBException e) {
                log.debug("Error getting array component type", e);
            }
        }
        if (elementType == null) {
            try {
                if (array != null) {
                    String baseTypeName = array.getBaseTypeName();
                    elementType = session.getDataSource().resolveDataType(monitor, baseTypeName);
                }
            }
            catch (Exception e) {
                throw new DBCException("Error resolving data type", e);
            }
        }
        try {
            if (elementType == null) {
                if (array == null) {
                    return null;
                }
                try {
                    return JDBCCollection.makeCollectionFromResultSet(session, array, null);
                }
                catch (SQLException e) {
                    throw new DBCException(e, (DBPDataSource)session.getDataSource());
                }
            }
            try {
                return JDBCCollection.makeCollectionFromArray(session, array, elementType);
            }
            catch (SQLException e) {
                if (array == null) {
                    throw new DBCException(e, (DBPDataSource)session.getDataSource());
                }
                try {
                    return JDBCCollection.makeCollectionFromResultSet(session, array, elementType);
                }
                catch (SQLException e1) {
                    throw new DBCException(e1, (DBPDataSource)session.getDataSource());
                }
            }
        }
        catch (DBException e) {
            throw new DBCException("Can't extract array data from JDBC array", e);
        }
    }

    @NotNull
    public static JDBCCollection makeCollectionFromJavaArray(@NotNull JDBCSession session, @NotNull DBSTypedObject column, Object array) throws DBCException {
        DBSDataType elementType;
        DBPDataKind dataKind;
        JDBCDataSource dataTypeProvider = session.getDataSource();
        if (array instanceof int[]) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(4);
        } else if (array instanceof short[]) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(5);
        } else if (array instanceof byte[]) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(-2);
        } else if (array instanceof long[]) {
            dataKind = DBPDataKind.NUMERIC;
            elementType = dataTypeProvider.getLocalDataType(-5);
        } else if (array instanceof boolean[]) {
            dataKind = DBPDataKind.BOOLEAN;
            elementType = dataTypeProvider.getLocalDataType(16);
        } else if (array instanceof String[]) {
            dataKind = DBPDataKind.STRING;
            elementType = dataTypeProvider.getLocalDataType(12);
        } else if (array instanceof Date[]) {
            dataKind = DBPDataKind.DATETIME;
            elementType = dataTypeProvider.getLocalDataType(93);
        } else {
            dataKind = DBPDataKind.OBJECT;
            elementType = dataTypeProvider.getLocalDataType(2002);
        }
        if (elementType == null) {
            try {
                String typeName = dataTypeProvider.getDefaultDataTypeName(dataKind);
                if (typeName != null) {
                    elementType = dataTypeProvider.getLocalDataType(typeName);
                }
            }
            catch (Exception e) {
                throw new DBCException("Error resolving default data type", e);
            }
        }
        try {
            if (elementType == null) {
                throw new DBCException("Can't resolve array element data type");
            }
            DBDValueHandler elementValueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)elementType);
            if (array == null) {
                return new JDBCCollection(elementType, elementValueHandler, null);
            }
            return JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, array);
        }
        catch (DBException e) {
            throw new DBCException("Can't extract array data from Java array", e);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    private static JDBCCollection makeCollectionFromResultSet(@NotNull JDBCSession session, @NotNull java.sql.Array array, @Nullable DBSDataType elementType) throws SQLException, DBException {
        dbResult = array.getResultSet();
        if (dbResult == null) {
            throw new DBCException("JDBC array type was not resolved and result set was not provided by driver. Return NULL.");
        }
        if (elementType /* !! */  == null) {
            itemMeta = new JDBCColumnMetaData(session.getDataSource(), dbResult.getMetaData(), 1);
            elementType /* !! */  = DBUtils.resolveDataType(session.getProgressMonitor(), session.getDataSource(), itemMeta.getTypeName());
            if (elementType /* !! */  == null) {
                elementType /* !! */  = new JDBCDataType<JDBCDataSource>(session.getDataSource(), itemMeta);
            }
            valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)itemMeta);
        } else {
            valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)elementType /* !! */ );
        }
        try {
            var5_4 = null;
            var6_7 = null;
            try {
                resultSet = JDBCResultSetImpl.makeResultSet(session, null, dbResult, ModelMessages.model_jdbc_array_result_set, true);
                try {
                    data = new ArrayList<Object>();
                    while (dbResult.next()) {
                        data.add(valueHandler.fetchValueObject(session, resultSet, elementType /* !! */ , 1));
                    }
                    var10_11 = new JDBCCollection(elementType /* !! */ , valueHandler, data.toArray());
                    ** try [egrp 3[TRYBLOCK] [2 : 197->222)] { 
                }
lbl31:
                // 1 sources

                catch (Throwable var5_5) {
                    throw var5_5;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        dbResult.close();
                    }
                    catch (SQLException e) {
                        JDBCCollection.log.debug("Can't close array result set", e);
                    }
                    return var10_11;
                }
            }
            catch (Throwable var6_8) {
                if (var5_4 == null) {
                    var5_4 = var6_8;
                } else if (var5_4 != var6_8) {
                    var5_4.addSuppressed(var6_8);
                }
                throw var5_4;
            }
        }
        catch (Throwable var9_14) {
            try {
                dbResult.close();
            }
            catch (SQLException e) {
                JDBCCollection.log.debug("Can't close array result set", e);
            }
            throw var9_14;
        }
    }

    @NotNull
    private static JDBCCollection makeCollectionFromArray(@NotNull JDBCSession session, @Nullable java.sql.Array array, @NotNull DBSDataType elementType) throws SQLException, DBCException {
        DBDValueHandler elementValueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)elementType);
        if (array == null) {
            return new JDBCCollection(elementType, elementValueHandler, null);
        }
        Object arrObject = array.getArray();
        return JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, arrObject);
    }

    @NotNull
    private static JDBCCollection makeCollectionFromJavaArray(@NotNull JDBCSession session, @NotNull DBSDataType elementType, @NotNull DBDValueHandler elementValueHandler, @Nullable Object arrObject) throws DBCException {
        int arrLength = arrObject == null ? 0 : Array.getLength(arrObject);
        Object[] contents = new Object[arrLength];
        int i = 0;
        while (i < arrLength) {
            Object item = Array.get(arrObject, i);
            Object itemValue = item != null && item.getClass().isArray() && elementType.getDataKind() != DBPDataKind.ARRAY ? JDBCCollection.makeCollectionFromJavaArray(session, elementType, elementValueHandler, item) : elementValueHandler.getValueFromObject(session, elementType, item, false);
            contents[i] = itemValue;
            ++i;
        }
        return new JDBCCollection(elementType, elementValueHandler, contents);
    }

    @NotNull
    public static DBDCollection makeCollectionFromString(@NotNull JDBCSession session, String value) throws DBCException {
        String stringType = DBUtils.getDefaultDataTypeName(session.getDataSource(), DBPDataKind.STRING);
        if (stringType == null) {
            throw new DBCException("String data type not supported by database");
        }
        DBSDataType dataType = DBUtils.getLocalDataType(session.getDataSource(), stringType);
        if (dataType == null) {
            throw new DBCException("String data type '" + stringType + "' not supported by database");
        }
        DBDValueHandler valueHandler = DBUtils.findValueHandler(session, (DBSTypedObject)dataType);
        if (!CommonUtils.isEmpty((String)value) && value.startsWith("[") && value.endsWith("]")) {
            String arrayString = value.substring(1, value.length() - 1);
            ArrayList<String> items = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(arrayString, ",", false);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("\"") && token.endsWith("\"")) {
                    token = token.substring(1, token.length() - 1);
                }
                items.add(token);
            }
            return new JDBCCollectionString(dataType, valueHandler, value, items.toArray());
        }
        return new JDBCCollectionString(dataType, valueHandler, value);
    }
}

