/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleManager;
import org.jkiss.dbeaver.ui.editors.sql.syntax.rules.SQLDelimiterRule;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLSetDelimiterToken;

public class SQLDelimiterSetRule
implements IRule {
    private final String setDelimiterWord;
    private final SQLSetDelimiterToken setDelimiterToken;
    private final SQLDelimiterRule delimiterRule;

    public SQLDelimiterSetRule(String setDelimiterWord, SQLSetDelimiterToken setDelimiterToken, SQLDelimiterRule delimiterRule) {
        this.setDelimiterWord = setDelimiterWord;
        this.setDelimiterToken = setDelimiterToken;
        this.delimiterRule = delimiterRule;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        scanner.unread();
        int prevChar = scanner.read();
        if (prevChar != -1 && prevChar != 13 && prevChar != 10) {
            return Token.UNDEFINED;
        }
        int i = 0;
        while (i < this.setDelimiterWord.length()) {
            char c = this.setDelimiterWord.charAt(i);
            int nextChar = scanner.read();
            if (Character.toUpperCase(nextChar) != c) {
                int k = 0;
                while (k <= i) {
                    scanner.unread();
                    ++k;
                }
                return Token.UNDEFINED;
            }
            ++i;
        }
        StringBuilder delimBuffer = new StringBuilder();
        int delimLength = 0;
        int next = scanner.read();
        if (next == -1 || next == 10 || next == 13) {
            scanner.unread();
        } else {
            if (!Character.isWhitespace(next)) {
                int k = 0;
                while (k < this.setDelimiterWord.length() + 1) {
                    scanner.unread();
                    ++k;
                }
                return Token.UNDEFINED;
            }
            while ((next = scanner.read()) != -1 && next != 10 && next != 13) {
                if (delimLength == 0 && delimBuffer.length() > 0 && Character.isWhitespace(next)) {
                    delimLength = delimBuffer.length();
                }
                delimBuffer.append((char)next);
            }
            scanner.unread();
        }
        if (scanner instanceof SQLRuleManager && ((SQLRuleManager)scanner).isEvalMode()) {
            String newDelimiter = delimLength <= 0 ? delimBuffer.toString().trim() : delimBuffer.substring(0, delimLength).trim();
            this.delimiterRule.changeDelimiter(newDelimiter);
        }
        return this.setDelimiterToken;
    }
}

