/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer;

import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;

public class DTUtils {
    public static void addSummary(StringBuilder summary, String option, Object value) {
        summary.append("\t").append(option).append(": ").append(value).append("\n");
    }

    public static void addSummary(StringBuilder summary, String option, boolean value) {
        summary.append("\t").append(option).append(": ").append(value ? "Yes" : "No").append("\n");
    }

    public static void addSummary(StringBuilder summary, DataTransferProcessorDescriptor processor, Map<?, ?> props) {
        summary.append(processor.getName()).append(" settings:\n");
        for (DBPPropertyDescriptor prop : processor.getProperties()) {
            Object propValue = props.get(prop.getId());
            if (propValue == null) {
                propValue = prop.getDefaultValue();
            }
            if (propValue == null) continue;
            DTUtils.addSummary(summary, prop.getDisplayName(), propValue);
        }
    }

    public static String getTableName(DBPDataSource dataSource, DBPNamedObject source, boolean shortName) {
        DBSDataContainer dataContainer;
        SQLQueryContainer queryContainer;
        if (source instanceof DBSEntity) {
            return shortName ? DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)source)) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        String tableName = null;
        if (source instanceof SQLQueryContainer) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, (SQLQueryContainer)source, shortName);
        } else if (source instanceof IAdaptable && (queryContainer = (SQLQueryContainer)((IAdaptable)source).getAdapter(SQLQueryContainer.class)) != null) {
            tableName = DTUtils.getTableNameFromQuery(dataSource, queryContainer, shortName);
        }
        if (tableName == null && source instanceof IAdaptable && (dataContainer = (DBSDataContainer)((IAdaptable)source).getAdapter(DBSDataContainer.class)) instanceof DBSEntity) {
            String string = tableName = shortName ? DBUtils.getQuotedIdentifier((DBSObject)dataContainer) : DBUtils.getObjectFullName((DBPNamedObject)dataContainer, (DBPEvaluationContext)DBPEvaluationContext.UI);
        }
        if (tableName == null) {
            return shortName ? DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)source.getName()) : DBUtils.getObjectFullName((DBPNamedObject)source, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return tableName;
    }

    public static String getTableNameFromQuery(DBPDataSource dataSource, SQLQueryContainer queryContainer, boolean shortName) {
        DBCEntityMetaData singleSource;
        SQLScriptElement query = queryContainer.getQuery();
        if (query instanceof SQLQuery && (singleSource = ((SQLQuery)query).getSingleSource()) != null) {
            if (shortName) {
                return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource.getDataSource(), (String)singleSource.getEntityName());
            }
            return DBUtils.getFullyQualifiedName((DBPDataSource)dataSource.getDataSource(), (String[])new String[]{singleSource.getCatalogName(), singleSource.getSchemaName(), singleSource.getEntityName()});
        }
        return null;
    }
}

