/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl.bin;

import java.io.IOException;
import java.util.Iterator;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.bin.Symbols;

abstract class AbstractSymbolTable
implements SymbolTable {
    private final String name;
    private final int version;

    public AbstractSymbolTable(String name2, int version) {
        this.name = name2;
        this.version = version;
    }

    public final String getName() {
        return this.name;
    }

    public final int getVersion() {
        return this.version;
    }

    public final String getIonVersionId() {
        return "$ion_1_0";
    }

    public final int findSymbol(String name2) {
        SymbolToken token = this.find(name2);
        if (token == null) {
            return -1;
        }
        return token.getSid();
    }

    public final void writeTo(IonWriter writer2) throws IOException {
        SymbolTable[] imports;
        if (this.isSharedTable()) {
            writer2.setTypeAnnotationSymbols(Symbols.systemSymbol(9));
        } else if (this.isLocalTable()) {
            writer2.setTypeAnnotationSymbols(Symbols.systemSymbol(3));
        } else {
            throw new IllegalStateException("Invalid symbol table, neither shared nor local");
        }
        writer2.stepIn(IonType.STRUCT);
        if (this.isSharedTable()) {
            writer2.setFieldNameSymbol(Symbols.systemSymbol(4));
            writer2.writeString(this.name);
            writer2.setFieldNameSymbol(Symbols.systemSymbol(5));
            writer2.writeInt(this.version);
        }
        if ((imports = this.getImportedTables()) != null && imports.length > 0) {
            writer2.setFieldNameSymbol(Symbols.systemSymbol(6));
            writer2.stepIn(IonType.LIST);
            for (SymbolTable st : imports) {
                writer2.stepIn(IonType.STRUCT);
                writer2.setFieldNameSymbol(Symbols.systemSymbol(4));
                writer2.writeString(st.getName());
                writer2.setFieldNameSymbol(Symbols.systemSymbol(5));
                writer2.writeInt(st.getVersion());
                writer2.setFieldNameSymbol(Symbols.systemSymbol(8));
                writer2.writeInt(st.getMaxId());
                writer2.stepOut();
            }
            writer2.stepOut();
        }
        writer2.setFieldNameSymbol(Symbols.systemSymbol(7));
        writer2.stepIn(IonType.LIST);
        Iterator<String> iter = this.iterateDeclaredSymbolNames();
        while (iter.hasNext()) {
            writer2.writeString(iter.next());
        }
        writer2.stepOut();
        writer2.stepOut();
    }

    public void makeReadOnly() {
    }
}

