"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_store_1 = __importDefault(require("electron-store"));
const electron_util_1 = require("electron-util");
const defaults = {
    followSystemAppearance: true,
    darkMode: false,
    // TODO: Change the default to 'sidebar' when the vibrancy issue in Electron is fixed.
    // See https://github.com/electron/electron/issues/10420
    vibrancy: 'none',
    zoomFactor: 1,
    lastWindowState: {
        width: 800,
        height: 600,
        x: undefined,
        y: undefined
    },
    alwaysOnTop: false,
    bounceDockOnMessage: false,
    showUnreadBadge: true,
    showMessageButtons: true,
    launchMinimized: false,
    flashWindowOnMessage: true,
    block: {
        chatSeen: false,
        typingIndicator: false,
        deliveryReceipt: false
    },
    emojiStyle: 'facebook-3-0',
    confirmImagePaste: true,
    useWorkChat: false,
    sidebarHidden: false,
    autoHideMenuBar: false,
    notificationsMuted: false,
    hardwareAcceleration: true,
    quitOnWindowClose: false,
    keepMeSignedIn: true
};
function updateVibrancySetting(store) {
    const vibrancy = store.get('vibrancy');
    if (!electron_util_1.is.macos) {
        store.set('vibrancy', 'none');
    }
    else if (vibrancy === true) {
        store.set('vibrancy', 'full');
    }
    else if (vibrancy === false) {
        store.set('vibrancy', 'sidebar');
    }
}
function migrate(store) {
    updateVibrancySetting(store);
}
const store = new electron_store_1.default({ defaults });
migrate(store);
exports.default = store;
//# sourceMappingURL=config.js.map