/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import io.grpc.ConnectivityState;
import javax.annotation.concurrent.Immutable;

public final class Channelz {

    @Immutable
    public static final class TransportStats {
        public final long streamsStarted;
        public final long lastStreamCreatedTimeNanos;
        public final long streamsSucceeded;
        public final long streamsFailed;
        public final long messagesSent;
        public final long messagesReceived;
        public final long keepAlivesSent;
        public final long lastMessageSentTimeNanos;
        public final long lastMessageReceivedTimeNanos;
        public final long localFlowControlWindow;
        public final long remoteFlowControlWindow;

        public TransportStats(long streamsStarted, long lastStreamCreatedTimeNanos, long streamsSucceeded, long streamsFailed, long messagesSent, long messagesReceived, long keepAlivesSent, long lastMessageSentTimeNanos, long lastMessageReceivedTimeNanos, long localFlowControlWindow, long remoteFlowControlWindow) {
            this.streamsStarted = streamsStarted;
            this.lastStreamCreatedTimeNanos = lastStreamCreatedTimeNanos;
            this.streamsSucceeded = streamsSucceeded;
            this.streamsFailed = streamsFailed;
            this.messagesSent = messagesSent;
            this.messagesReceived = messagesReceived;
            this.keepAlivesSent = keepAlivesSent;
            this.lastMessageSentTimeNanos = lastMessageSentTimeNanos;
            this.lastMessageReceivedTimeNanos = lastMessageReceivedTimeNanos;
            this.localFlowControlWindow = localFlowControlWindow;
            this.remoteFlowControlWindow = remoteFlowControlWindow;
        }
    }

    @Immutable
    public static final class ChannelStats {
        public final String target;
        public final ConnectivityState state;
        public final long callsStarted;
        public final long callsSucceeded;
        public final long callsFailed;
        public final long lastCallStartedMillis;

        public ChannelStats(String target, ConnectivityState state, long callsStarted, long callsSucceeded, long callsFailed, long lastCallStartedMillis) {
            this.target = target;
            this.state = state;
            this.callsStarted = callsStarted;
            this.callsSucceeded = callsSucceeded;
            this.callsFailed = callsFailed;
            this.lastCallStartedMillis = lastCallStartedMillis;
        }

        public static final class Builder {
            private String target;
            private ConnectivityState state;
            private long callsStarted;
            private long callsSucceeded;
            private long callsFailed;
            private long lastCallStartedMillis;

            public Builder setTarget(String target) {
                this.target = target;
                return this;
            }

            public Builder setState(ConnectivityState state) {
                this.state = state;
                return this;
            }

            public Builder setCallsStarted(long callsStarted) {
                this.callsStarted = callsStarted;
                return this;
            }

            public Builder setCallsSucceeded(long callsSucceeded) {
                this.callsSucceeded = callsSucceeded;
                return this;
            }

            public Builder setCallsFailed(long callsFailed) {
                this.callsFailed = callsFailed;
                return this;
            }

            public Builder setLastCallStartedMillis(long lastCallStartedMillis) {
                this.lastCallStartedMillis = lastCallStartedMillis;
                return this;
            }

            public ChannelStats build() {
                return new ChannelStats(this.target, this.state, this.callsStarted, this.callsSucceeded, this.callsFailed, this.lastCallStartedMillis);
            }
        }
    }
}

