/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class OnClickDetector
extends LayoutDetector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"OnClick", (String)"`onClick` method does not exist", (String)"The `onClick` attribute value should be the name of a method in this View's context to invoke when the view is clicked. This name must correspond to a public method that takes exactly one parameter of type `View`.\n\nMust be a string value, using '\\;' to escape characters such as '\\n' or '\\uxxxx' for a unicode character.", (Category)Category.CORRECTNESS, (int)10, (Severity)Severity.ERROR, (Implementation)new Implementation(OnClickDetector.class, Scope.CLASS_AND_ALL_RESOURCE_FILES));
    private Map<String, Location.Handle> mNames;
    private Map<String, List<String>> mSimilar;
    private boolean mHaveBytecode;

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void afterCheckProject(Context context) {
        if (this.mNames != null && !this.mNames.isEmpty() && this.mHaveBytecode) {
            ArrayList<String> names = new ArrayList<String>(this.mNames.keySet());
            Collections.sort(names);
            LintDriver driver = context.getDriver();
            for (String name : names) {
                List<String> similar;
                Location.Handle handle = this.mNames.get(name);
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && driver.isSuppressed(null, ISSUE, (Node)clientData)) continue;
                Location location = handle.resolve();
                String message = String.format("Corresponding method handler '`public void %1$s(android.view.View)`' not found", name);
                List<String> list = similar = this.mSimilar != null ? this.mSimilar.get(name) : null;
                if (similar != null) {
                    Collections.sort(similar);
                    message = message + String.format(" (did you mean `%1$s` ?)", Joiner.on((String)", ").join(similar));
                }
                context.report(ISSUE, location, message);
            }
        }
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("onClick");
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        String value = attribute.getValue();
        if (value.isEmpty() || value.trim().isEmpty()) {
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "`onClick` attribute value cannot be empty");
        } else if (!value.equals(value.trim())) {
            context.report(ISSUE, (Node)attribute, context.getLocation((Node)attribute), "There should be no whitespace around attribute values");
        } else if (!value.startsWith("@")) {
            if (!context.getProject().getReportIssues()) {
                return;
            }
            if (this.mNames == null) {
                this.mNames = new HashMap<String, Location.Handle>();
            }
            Location.Handle handle = context.createLocationHandle((Node)attribute);
            handle.setClientData((Object)attribute);
            if (value.contains("\\u")) {
                Pattern pattern = Pattern.compile("\\\\u(\\d\\d\\d\\d)");
                Matcher matcher = pattern.matcher(value);
                StringBuilder sb = new StringBuilder(value.length());
                int remainder = 0;
                while (matcher.find()) {
                    sb.append(value.substring(0, matcher.start()));
                    String unicode = matcher.group(1);
                    int hex = Integer.parseInt(unicode, 16);
                    sb.append((char)hex);
                    remainder = matcher.end();
                }
                sb.append(value.substring(remainder));
                value = sb.toString();
            }
            this.mNames.put(value, handle);
        }
    }

    public void checkClass(ClassContext context, ClassNode classNode) {
        if (this.mNames == null) {
            return;
        }
        this.mHaveBytecode = true;
        List methodList = classNode.methods;
        block0: for (Object m : methodList) {
            String message;
            Location location;
            MethodNode method = (MethodNode)m;
            boolean rightArguments = method.desc.equals("(Landroid/view/View;)V");
            if (!this.mNames.containsKey(method.name)) {
                if (!rightArguments) continue;
                for (String n : this.mNames.keySet()) {
                    if (LintUtils.editDistance((String)n, (String)method.name) > 2) continue;
                    this.recordSimilar(n, classNode, method);
                    continue block0;
                }
                continue;
            }
            if (!rightArguments) continue;
            this.mNames.remove(method.name);
            if ((method.access & 1) == 0) {
                location = context.getLocation(method, classNode);
                message = String.format("On click handler `%1$s(View)` must be public", method.name);
                context.report(ISSUE, location, message);
            } else if ((method.access & 8) != 0) {
                location = context.getLocation(method, classNode);
                message = String.format("On click handler `%1$s(View)` should not be static", method.name);
                context.report(ISSUE, location, message);
            }
            if (!this.mNames.isEmpty()) continue;
            this.mNames = null;
            return;
        }
    }

    private void recordSimilar(String name, ClassNode classNode, MethodNode method) {
        List<String> list;
        if (this.mSimilar == null) {
            this.mSimilar = new HashMap<String, List<String>>();
        }
        if ((list = this.mSimilar.get(name)) == null) {
            list = new ArrayList<String>();
            this.mSimilar.put(name, list);
        }
        String signature = ClassContext.createSignature((String)classNode.name, (String)method.name, (String)method.desc);
        list.add(signature);
    }
}

