/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ClickableViewAccessibilityDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"ClickableViewAccessibility", (String)"Accessibility in Custom Views", (String)"If a `View` that overrides `onTouchEvent` or uses an `OnTouchListener` does not also implement `performClick` and call it when clicks are detected, the `View` may not handle accessibility actions properly. Logic handling the click actions should ideally be placed in `View#performClick` as some accessibility services invoke `performClick` when a click action should occur.", (Category)Category.A11Y, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(ClickableViewAccessibilityDetector.class, Scope.CLASS_FILE_SCOPE));
    private static final String ON_TOUCH_EVENT = "onTouchEvent";
    private static final String ON_TOUCH_EVENT_SIG = "(Landroid/view/MotionEvent;)Z";
    private static final String PERFORM_CLICK = "performClick";
    private static final String PERFORM_CLICK_SIG = "()Z";
    private static final String SET_ON_TOUCH_LISTENER = "setOnTouchListener";
    private static final String SET_ON_TOUCH_LISTENER_SIG = "(Landroid/view/View$OnTouchListener;)V";
    private static final String ON_TOUCH = "onTouch";
    private static final String ON_TOUCH_SIG = "(Landroid/view/View;Landroid/view/MotionEvent;)Z";
    private static final String ON_TOUCH_LISTENER = "android/view/View$OnTouchListener";

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(ClassContext context, ClassNode classNode) {
        ClickableViewAccessibilityDetector.scanForAndCheckSetOnTouchListenerCalls(context, classNode);
        if ((classNode.access & 0x400) != 0) {
            return;
        }
        if (context.getDriver().isSubclassOf(classNode, "android/view/View")) {
            ClickableViewAccessibilityDetector.checkView(context, classNode);
        }
        if (ClickableViewAccessibilityDetector.implementsOnTouchListener(classNode)) {
            ClickableViewAccessibilityDetector.checkOnTouchListener(context, classNode);
        }
    }

    public static void scanForAndCheckSetOnTouchListenerCalls(ClassContext context, ClassNode classNode) {
        List methods = classNode.methods;
        for (MethodNode methodNode : methods) {
            for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
                if (abstractInsnNode.getType() != 5) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!methodInsnNode.name.equals(SET_ON_TOUCH_LISTENER) || !methodInsnNode.desc.equals(SET_ON_TOUCH_LISTENER_SIG)) continue;
                ClickableViewAccessibilityDetector.checkSetOnTouchListenerCall(context, methodNode, methodInsnNode);
            }
        }
    }

    public static void checkSetOnTouchListenerCall(ClassContext context, MethodNode method, MethodInsnNode call) {
        String owner = call.owner;
        ClassNode ownerClass = context.getDriver().findClass(context, owner, 0);
        if (ownerClass == null || !context.getDriver().isSubclassOf(ownerClass, "android/view/View")) {
            return;
        }
        MethodNode performClick = ClickableViewAccessibilityDetector.findMethod(ownerClass.methods, PERFORM_CLICK, PERFORM_CLICK_SIG);
        if (performClick == null) {
            String message = String.format("Custom view `%1$s` has `setOnTouchListener` called on it but does not override `performClick`", ownerClass.name);
            context.report(ISSUE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), message);
        }
    }

    private static void checkOnTouchListener(ClassContext context, ClassNode classNode) {
        AbstractInsnNode performClickInsnNode;
        MethodNode onTouchNode = ClickableViewAccessibilityDetector.findMethod(classNode.methods, ON_TOUCH, ON_TOUCH_SIG);
        if (onTouchNode != null && (performClickInsnNode = ClickableViewAccessibilityDetector.findMethodCallInstruction(onTouchNode.instructions, "android/view/View", PERFORM_CLICK, PERFORM_CLICK_SIG)) == null) {
            String message = String.format("`%1$s#onTouch` should call `View#performClick` when a click is detected", classNode.name);
            context.report(ISSUE, onTouchNode, null, context.getLocation(onTouchNode, classNode), message);
        }
    }

    private static void checkView(ClassContext context, ClassNode classNode) {
        AbstractInsnNode superPerformClickInPerformClickInsnNode;
        String message;
        MethodNode onTouchEvent = ClickableViewAccessibilityDetector.findMethod(classNode.methods, ON_TOUCH_EVENT, ON_TOUCH_EVENT_SIG);
        MethodNode performClick = ClickableViewAccessibilityDetector.findMethod(classNode.methods, PERFORM_CLICK, PERFORM_CLICK_SIG);
        if (onTouchEvent != null) {
            if (performClick == null) {
                String message2 = String.format("Custom view `%1$s` overrides `onTouchEvent` but not `performClick`", classNode.name);
                context.report(ISSUE, onTouchEvent, null, context.getLocation(onTouchEvent, classNode), message2);
            } else {
                AbstractInsnNode performClickInOnTouchEventInsnNode = ClickableViewAccessibilityDetector.findMethodCallInstruction(onTouchEvent.instructions, classNode.name, PERFORM_CLICK, PERFORM_CLICK_SIG);
                if (performClickInOnTouchEventInsnNode == null) {
                    message = String.format("`%1$s#onTouchEvent` should call `%1$s#performClick` when a click is detected", classNode.name);
                    context.report(ISSUE, onTouchEvent, null, context.getLocation(onTouchEvent, classNode), message);
                }
            }
        }
        if (performClick != null && (superPerformClickInPerformClickInsnNode = ClickableViewAccessibilityDetector.findMethodCallInstruction(performClick.instructions, classNode.superName, PERFORM_CLICK, PERFORM_CLICK_SIG)) == null) {
            message = String.format("`%1$s#performClick` should call `super#performClick`", classNode.name);
            context.report(ISSUE, performClick, null, context.getLocation(performClick, classNode), message);
        }
    }

    private static MethodNode findMethod(List<MethodNode> methods, String name, String desc) {
        for (MethodNode method : methods) {
            if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
            return method;
        }
        return null;
    }

    private static AbstractInsnNode findMethodCallInstruction(InsnList instructions, String owner, String name, String desc) {
        for (AbstractInsnNode insnNode : instructions) {
            if (insnNode.getType() != 5) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
            if (!methodInsnNode.owner.equals(owner) || !methodInsnNode.name.equals(name) || !methodInsnNode.desc.equals(desc)) continue;
            return methodInsnNode;
        }
        return null;
    }

    private static boolean implementsOnTouchListener(ClassNode classNode) {
        return classNode.interfaces != null && classNode.interfaces.contains(ON_TOUCH_LISTENER);
    }
}

