Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

function isSupported() {
  return ['win32', 'darwin'].includes(process.platform);
}

function isDefaultProtocolClient() {
  return require('electron').remote.app.isDefaultProtocolClient('atom', process.execPath, ['--uri-handler', '--']);
}

function setAsDefaultProtocolClient() {
  // This Electron API is only available on Windows and macOS. There might be some
  // hacks to make it work on Linux; see https://github.com/electron/electron/issues/6440
  return isSupported() && require('electron').remote.app.setAsDefaultProtocolClient('atom', process.execPath, ['--uri-handler', '--']);
}

var UriHandlerPanel = (function () {
  function UriHandlerPanel() {
    var _this = this;

    _classCallCheck(this, UriHandlerPanel);

    this.handleChange = this.handleChange.bind(this);
    this.handleBecomeProtocolClient = this.handleBecomeProtocolClient.bind(this);
    this.isDefaultProtocolClient = isDefaultProtocolClient();
    this.uriHistory = [];
    _etch2['default'].initialize(this);

    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }), atom.uriHandlerRegistry.onHistoryChange(function () {
      _this.uriHistory = atom.uriHandlerRegistry.getRecentlyHandledURIs();
      _etch2['default'].update(_this);
    }));
  }

  _createClass(UriHandlerPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'render',
    value: function render() {
      var schema = atom.config.getSchema('core.uriHandlerRegistration');

      return _etch2['default'].dom(
        'div',
        { className: 'panels-item', tabIndex: '0' },
        _etch2['default'].dom(
          'form',
          { className: 'general-panel section' },
          _etch2['default'].dom(
            'div',
            { className: 'settings-panel' },
            _etch2['default'].dom(
              'div',
              { className: 'section-container' },
              _etch2['default'].dom(
                'div',
                { className: 'block section-heading icon icon-device-desktop' },
                'URI Handling'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'text icon icon-question' },
                'These settings determine how Atom handles atom:// URIs.'
              ),
              _etch2['default'].dom(
                'div',
                { className: 'section-body' },
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'label',
                      { className: 'control-label' },
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-title' },
                        'URI Handler Registration'
                      ),
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-description' },
                        this.renderRegistrationDescription()
                      )
                    ),
                    _etch2['default'].dom(
                      'button',
                      {
                        className: 'btn btn-primary',
                        disabled: !isSupported() || this.isDefaultProtocolClient,
                        style: { fontSize: '1.25em', display: 'block' },
                        onClick: this.handleBecomeProtocolClient
                      },
                      'Register as default atom:// protocol handler'
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'label',
                      { className: 'control-label' },
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-title' },
                        'Default Registration'
                      ),
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-description' },
                        schema.description
                      )
                    ),
                    _etch2['default'].dom(
                      'select',
                      {
                        id: 'core.uriHandlerRegistration',
                        className: 'form-control',
                        onChange: this.handleChange,
                        value: atom.config.get('core.uriHandlerRegistration')
                      },
                      schema['enum'].map(function (_ref) {
                        var description = _ref.description;
                        var value = _ref.value;
                        return _etch2['default'].dom(
                          'option',
                          { value: value },
                          description
                        );
                      })
                    )
                  )
                ),
                _etch2['default'].dom(
                  'div',
                  { className: 'control-group' },
                  _etch2['default'].dom(
                    'div',
                    { className: 'controls' },
                    _etch2['default'].dom(
                      'label',
                      { className: 'controls-label' },
                      _etch2['default'].dom(
                        'div',
                        { className: 'setting-title' },
                        'Recent URIs'
                      )
                    ),
                    _etch2['default'].dom(
                      'table',
                      { className: 'uri-history' },
                      _etch2['default'].dom(
                        'tr',
                        null,
                        _etch2['default'].dom(
                          'th',
                          null,
                          'URI'
                        ),
                        _etch2['default'].dom(
                          'th',
                          null,
                          'Handled By'
                        )
                      ),
                      this.uriHistory.map(this.renderHistoryRow.bind(this))
                    )
                  )
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'renderHistoryRow',
    value: function renderHistoryRow(item, idx) {
      return _etch2['default'].dom(
        'tr',
        {
          key: item.id,
          className: ''
        },
        _etch2['default'].dom(
          'td',
          null,
          item.uri
        ),
        _etch2['default'].dom(
          'td',
          null,
          item.handled ? this.renderItem(item) : _etch2['default'].dom(
            'em',
            null,
            'not handled'
          )
        )
      );
    }
  }, {
    key: 'renderItem',
    value: function renderItem(item) {
      if (item.host === 'core') {
        return _etch2['default'].dom(
          'em',
          null,
          'core'
        );
      } else {
        return _etch2['default'].dom(
          'a',
          { href: 'atom://config/packages/' + item.host, onClick: this.handlePackageLinkClicked },
          item.host
        );
      }
    }
  }, {
    key: 'handlePackageLinkClicked',
    value: function handlePackageLinkClicked(evt) {
      evt.preventDefault();
      atom.workspace.open(evt.target.getAttribute('href'));
    }
  }, {
    key: 'renderRegistrationDescription',
    value: function renderRegistrationDescription() {
      if (this.isDefaultProtocolClient) {
        return 'Atom is already the default handler for atom:// URIs.';
      } else if (isSupported()) {
        return 'Register Atom as the default handler for atom:// URIs.';
      } else {
        return 'Registration as the default handler for atom:// URIs is only supported on Windows and macOS.';
      }
    }
  }, {
    key: 'handleChange',
    value: function handleChange(evt) {
      atom.config.set('core.uriHandlerRegistration', evt.target.value);
    }
  }, {
    key: 'handleBecomeProtocolClient',
    value: function handleBecomeProtocolClient(evt) {
      evt.preventDefault();
      if (setAsDefaultProtocolClient()) {
        this.isDefaultProtocolClient = isDefaultProtocolClient();
        _etch2['default'].update(this);
      } else {
        atom.notifications.addError('Could not become default protocol client');
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return UriHandlerPanel;
})();

exports['default'] = UriHandlerPanel;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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