Object.defineProperty(exports, '__esModule', {
  value: true
});
var _bind = Function.prototype.bind;

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/** @babel */

var _atom = require('atom');

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _collapsibleSectionPanel = require('./collapsible-section-panel');

var _collapsibleSectionPanel2 = _interopRequireDefault(_collapsibleSectionPanel);

var _richDescription = require('./rich-description');

var SCOPED_SETTINGS = ['autoIndent', 'autoIndentOnPaste', 'invisibles', 'nonWordCharacters', 'preferredLineLength', 'scrollPastEnd', 'showIndentGuide', 'showInvisibles', 'softWrap', 'softWrapAtPreferredLineLength', 'softWrapHangingIndent', 'tabLength', 'tabType'];

var SettingsPanel = (function (_CollapsibleSectionPanel) {
  _inherits(SettingsPanel, _CollapsibleSectionPanel);

  function SettingsPanel() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, SettingsPanel);

    _get(Object.getPrototypeOf(SettingsPanel.prototype), 'constructor', this).call(this);
    var namespace = options.namespace;
    this.element = document.createElement('section');
    this.element.classList.add('section', 'settings-panel');
    this.options = options;
    this.disposables = new _atom.CompositeDisposable();
    var settings = undefined;
    if (this.options.scopeName) {
      namespace = 'editor';
      settings = {};
      for (var _name of SCOPED_SETTINGS) {
        settings[_name] = atom.config.get(_name, { scope: [this.options.scopeName] });
      }
    } else {
      settings = atom.config.get(namespace);
    }

    this.element.appendChild(this.elementForSettings(namespace, settings));

    this.disposables.add(this.bindInputFields());
    this.disposables.add(this.bindSelectFields());
    this.disposables.add(this.bindEditors());
    this.disposables.add(this.bindTooltips());
    this.disposables.add(this.handleEvents());
  }

  /*
   * Space Pen Helpers
   */

  _createClass(SettingsPanel, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'elementForSettings',
    value: function elementForSettings(namespace, settings) {
      if (_underscorePlus2['default'].isEmpty(settings)) {
        return document.createDocumentFragment();
      }

      var title = this.options.title;

      var includeTitle = this.options.includeTitle != null ? this.options.includeTitle : true;
      if (includeTitle) {
        if (title == null) {
          title = _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(namespace)) + ' Settings';
        }
      } else {
        if (title == null) {
          title = 'Settings';
        }
      }

      var icon = this.options.icon != null ? this.options.icon : 'gear';
      var note = this.options.note;

      var sortedSettings = this.sortSettings(namespace, settings);

      var container = document.createElement('div');
      container.classList.add('section-container');

      var heading = document.createElement('div');
      heading.classList.add('block', 'section-heading', 'icon', 'icon-' + icon);
      heading.textContent = title;
      container.appendChild(heading);

      if (note) {
        container.insertAdjacentHTML('beforeend', note);
      }

      var body = document.createElement('div');
      body.classList.add('section-body');
      for (var _name2 of sortedSettings) {
        body.appendChild(elementForSetting(namespace, _name2, settings[_name2]));
      }
      container.appendChild(body);

      return container;
    }
  }, {
    key: 'sortSettings',
    value: function sortSettings(namespace, settings) {
      return _sortSettings(namespace, settings);
    }
  }, {
    key: 'bindInputFields',
    value: function bindInputFields() {
      var _this = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id]')).map(function (input) {
        var name = input.id;
        var type = input.type;

        _this.observe(name, function (value) {
          if (type === 'checkbox') {
            input.checked = value;
          } else {
            if (type === 'color') {
              if (value && value.toHexString && value.toHexString()) {
                value = value.toHexString();
              }
            }

            if (value) {
              input.value = value;
            }
          }
        });

        var changeHandler = function changeHandler() {
          var value = input.value;
          if (type === 'checkbox') {
            value = input.checked;
          } else {
            value = _this.parseValue(type, value);
          }

          if (type === 'color') {
            // This is debounced since the color wheel fires lots of events
            // as you are dragging it around
            clearTimeout(_this.colorDebounceTimeout);
            _this.colorDebounceTimeout = setTimeout(function () {
              _this.set(name, value);
            }, 100);
          } else {
            _this.set(name, value);
          }
        };

        input.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return input.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'observe',
    value: function observe(name, callback) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      this.disposables.add(atom.config.observe(name, params, callback));
    }
  }, {
    key: 'isDefault',
    value: function isDefault(name) {
      var params = { sources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }
      var defaultValue = this.getDefault(name);
      var value = atom.config.get(name, params);
      return value == null || defaultValue === value;
    }
  }, {
    key: 'getDefault',
    value: function getDefault(name) {
      var params = { excludeSources: [atom.config.getUserConfigPath()] };
      if (this.options.scopeName != null) {
        params.scope = [this.options.scopeName];
      }

      var defaultValue = atom.config.get(name, params);
      if (this.options.scopeName != null) {
        // If the unscoped default is the same as the scoped default, check the actual config.cson
        // to make sure that there isn't a non-default value that is overriding the scoped value
        // For example: the default editor.tabLength is 2, but if someone sets it to 4
        // the above check still returns 2 and not 4 for a scoped editor.tabLength,
        // because it bypasses config.cson.
        if (atom.config.get(name, { excludeSources: [atom.config.getUserConfigPath()] }) === defaultValue) {
          defaultValue = atom.config.get(name);
        }
      }
      return defaultValue;
    }
  }, {
    key: 'set',
    value: function set(name, value) {
      if (this.options.scopeName) {
        if (value === undefined) {
          atom.config.unset(name, { scopeSelector: this.options.scopeName });
          return true;
        } else {
          return atom.config.set(name, value, { scopeSelector: this.options.scopeName });
        }
      } else {
        return atom.config.set(name, value);
      }
    }
  }, {
    key: 'setText',
    value: function setText(editor, name, type, value) {
      var stringValue = undefined;
      if (this.isDefault(name)) {
        stringValue = '';
      } else {
        stringValue = this.valueToString(value) || '';
      }

      if (stringValue === editor.getText() || _underscorePlus2['default'].isEqual(value, this.parseValue(type, editor.getText()))) {
        return;
      }

      editor.setText(stringValue);
      editor.moveToEndOfLine();
    }
  }, {
    key: 'bindSelectFields',
    value: function bindSelectFields() {
      var _this2 = this;

      var disposables = Array.from(this.element.querySelectorAll('select[id]')).map(function (select) {
        var name = select.id;
        _this2.observe(name, function (value) {
          select.value = value;
        });
        var changeHandler = function changeHandler() {
          _this2.set(name, select.value);
        };
        select.addEventListener('change', changeHandler);
        return new _atom.Disposable(function () {
          return select.removeEventListener('change', changeHandler);
        });
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindEditors',
    value: function bindEditors() {
      var _this3 = this;

      var disposables = Array.from(this.element.querySelectorAll('atom-text-editor')).map(function (editorElement) {
        var editor = editorElement.getModel();
        var name = editorElement.id;
        var type = editorElement.getAttribute('type');
        var defaultValue = _this3.valueToString(_this3.getDefault(name));

        if (defaultValue != null) {
          editor.setPlaceholderText('Default: ' + defaultValue);
        }

        var subscriptions = new _atom.CompositeDisposable();

        var focusHandler = function focusHandler() {
          if (_this3.isDefault(name)) {
            editor.setText(_this3.valueToString(_this3.getDefault(name)) || '');
          }
        };
        editorElement.addEventListener('focus', focusHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('focus', focusHandler);
        }));

        var blurHandler = function blurHandler() {
          if (_this3.isDefault(name)) {
            editor.setText('');
          }
        };
        editorElement.addEventListener('blur', blurHandler);
        subscriptions.add(new _atom.Disposable(function () {
          return editorElement.removeEventListener('blur', blurHandler);
        }));

        _this3.observe(name, function (value) {
          _this3.setText(editor, name, type, value);
        });

        subscriptions.add(editor.onDidStopChanging(function () {
          var _atom$config$getSchema = atom.config.getSchema(name);

          var minimum = _atom$config$getSchema.minimum;
          var maximum = _atom$config$getSchema.maximum;

          var value = _this3.parseValue(type, editor.getText());
          if (minimum != null && value < minimum) {
            _this3.set(name, minimum);
            _this3.setText(editor, name, type, minimum);
          } else if (maximum != null && value > maximum) {
            _this3.set(name, maximum);
            _this3.setText(editor, name, type, maximum);
          } else if (!_this3.set(name, value)) {
            _this3.setText(editor, name, type, atom.config.get(name));
          }
        }));

        return subscriptions;
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'bindTooltips',
    value: function bindTooltips() {
      var _this4 = this;

      var disposables = Array.from(this.element.querySelectorAll('input[id], select[id], atom-text-editor[id]')).map(function (element) {
        var schema = atom.config.getSchema(element.id);
        var defaultValue = _this4.valueToString(_this4.getDefault(element.id));
        if (defaultValue != null) {
          if (schema['enum'] && _underscorePlus2['default'].findWhere(schema['enum'], { value: defaultValue })) {
            defaultValue = _underscorePlus2['default'].findWhere(schema['enum'], { value: defaultValue }).description;
          }
          return atom.tooltips.add(element, {
            title: 'Default: ' + defaultValue,
            delay: { show: 100 },
            placement: 'auto left'
          });
        } else {
          return new _atom.Disposable(function () {}); // no-op
        }
      });

      return new (_bind.apply(_atom.CompositeDisposable, [null].concat(_toConsumableArray(disposables))))();
    }
  }, {
    key: 'valueToString',
    value: function valueToString(value) {
      if (Array.isArray(value)) {
        if (value.length === 0) {
          return null;
        }
        return value.map(function (val) {
          return val.toString().replace(/,/g, '\\,');
        }).join(', ');
      } else if (value != null) {
        return value.toString();
      } else {
        return null;
      }
    }
  }, {
    key: 'parseValue',
    value: function parseValue(type, value) {
      if (value === '') {
        return undefined;
      } else if (type === 'number') {
        var floatValue = parseFloat(value);
        if (isNaN(floatValue)) {
          return value;
        } else {
          return floatValue;
        }
      } else if (type === 'array') {
        var arrayValue = (value || '').split(',');
        arrayValue = arrayValue.reduce(function (values, val) {
          var last = values.length - 1;
          if (last >= 0 && values[last].endsWith('\\')) {
            values[last] = values[last].replace(/\\$/, ',') + val;
          } else {
            values.push(val);
          }
          return values;
        }, []);
        return arrayValue.filter(function (val) {
          return val;
        }).map(function (val) {
          return val.trim();
        });
      } else {
        return value;
      }
    }
  }]);

  return SettingsPanel;
})(_collapsibleSectionPanel2['default']);

exports['default'] = SettingsPanel;
var isEditableArray = function isEditableArray(array) {
  for (var item of array) {
    if (!_underscorePlus2['default'].isString(item)) {
      return false;
    }
  }
  return true;
};

function _sortSettings(namespace, settings) {
  return _underscorePlus2['default'].chain(settings).keys().sortBy(function (name) {
    return name;
  }).sortBy(function (name) {
    var schema = atom.config.getSchema(namespace + '.' + name);
    return schema ? schema.order : null;
  }).value();
}

function elementForSetting(namespace, name, value) {
  if (namespace === 'core') {
    if (name === 'themes') {
      return document.createDocumentFragment();
    } // Handled in the Themes panel
    if (name === 'disabledPackages') {
      return document.createDocumentFragment();
    } // Handled in the Packages panel
    if (name === 'customFileTypes') {
      return document.createDocumentFragment();
    }
    if (name === 'uriHandlerRegistration') {
      return document.createDocumentFragment();
    } // Handled in the URI Handler panel
  }

  if (namespace === 'editor') {
    // There's no global default for these, they are defined by language packages
    if (['commentStart', 'commentEnd', 'increaseIndentPattern', 'decreaseIndentPattern', 'foldEndPattern'].includes(name)) {
      return document.createDocumentFragment();
    }
  }

  var controlGroup = document.createElement('div');
  controlGroup.classList.add('control-group');

  var controls = document.createElement('div');
  controls.classList.add('controls');
  controlGroup.appendChild(controls);

  var schema = atom.config.getSchema(namespace + '.' + name);
  if (schema && schema['enum']) {
    controls.appendChild(elementForOptions(namespace, name, value));
  } else if (schema && schema.type === 'color') {
    controls.appendChild(elementForColor(namespace, name, value));
  } else if (_underscorePlus2['default'].isBoolean(value) || schema && schema.type === 'boolean') {
    controls.appendChild(elementForCheckbox(namespace, name, value));
  } else if (_underscorePlus2['default'].isArray(value) || schema && schema.type === 'array') {
    if (isEditableArray(value)) {
      controls.appendChild(elementForArray(namespace, name, value));
    }
  } else if (_underscorePlus2['default'].isObject(value) || schema && schema.type === 'object') {
    controls.appendChild(elementForObject(namespace, name, value));
  } else {
    controls.appendChild(elementForEditor(namespace, name, value));
  }

  return controlGroup;
}

function getSettingTitle(keyPath, name) {
  if (name == null) {
    name = '';
  }
  var schema = atom.config.getSchema(keyPath);
  var title = schema != null ? schema.title : null;
  return title || _underscorePlus2['default'].uncamelcase(name).split('.').map(_underscorePlus2['default'].capitalize).join(' ');
}

function elementForOptions(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var schema = atom.config.getSchema(keyPath);
  var options = schema && schema['enum'] ? schema['enum'] : [];

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);

  fragment.appendChild(label);

  var select = document.createElement('select');
  select.id = keyPath;
  select.classList.add('form-control');
  for (var option of options) {
    var optionElement = document.createElement('option');
    if (option.hasOwnProperty('value')) {
      optionElement.value = option.value;
      optionElement.textContent = option.description;
    } else {
      optionElement.value = option;
      optionElement.textContent = option;
    }
    select.appendChild(optionElement);
  }

  fragment.appendChild(select);

  return fragment;
}

function elementForCheckbox(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('checkbox');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'checkbox';
  input.classList.add('input-checkbox');
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForColor(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var div = document.createElement('div');
  div.classList.add('color');

  var label = document.createElement('label');
  label['for'] = keyPath;

  var input = document.createElement('input');
  input.id = keyPath;
  input.type = 'color';
  label.appendChild(input);

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);
  div.appendChild(label);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  div.appendChild(descriptionDiv);

  return div;
}

function elementForEditor(namespace, name, value) {
  var keyPath = namespace + '.' + name;
  var type = _underscorePlus2['default'].isNumber(value) ? 'number' : 'string';

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', type);
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForArray(namespace, name, value) {
  var keyPath = namespace + '.' + name;

  var fragment = document.createDocumentFragment();

  var label = document.createElement('label');
  label.classList.add('control-label');

  var titleDiv = document.createElement('div');
  titleDiv.classList.add('setting-title');
  titleDiv.textContent = getSettingTitle(keyPath, name);
  label.appendChild(titleDiv);

  var descriptionDiv = document.createElement('div');
  descriptionDiv.classList.add('setting-description');
  descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
  label.appendChild(descriptionDiv);
  fragment.appendChild(label);

  var controls = document.createElement('div');
  controls.classList.add('controls');

  var editorContainer = document.createElement('div');
  editorContainer.classList.add('editor-container');

  var editor = new _atom.TextEditor({ mini: true });
  editor.element.id = keyPath;
  editor.element.setAttribute('type', 'array');
  editorContainer.appendChild(editor.element);
  controls.appendChild(editorContainer);
  fragment.appendChild(controls);

  return fragment;
}

function elementForObject(namespace, name, value) {
  if (_underscorePlus2['default'].keys(value).length === 0) {
    return document.createDocumentFragment();
  } else {
    var keyPath = namespace + '.' + name;
    var schema = atom.config.getSchema(keyPath);
    var isCollapsed = schema.collapsed === true;

    var section = document.createElement('section');
    section.classList.add('sub-section');
    if (isCollapsed) {
      section.classList.add('collapsed');
    }

    var h3 = document.createElement('h3');
    h3.classList.add('sub-section-heading', 'has-items');
    h3.textContent = getSettingTitle(keyPath, name);
    section.appendChild(h3);

    var descriptionDiv = document.createElement('div');
    descriptionDiv.classList.add('setting-description');
    descriptionDiv.innerHTML = (0, _richDescription.getSettingDescription)(keyPath);
    section.appendChild(descriptionDiv);

    var div = document.createElement('div');
    div.classList.add('sub-section-body');
    for (var key of _sortSettings(keyPath, value)) {
      div.appendChild(elementForSetting(namespace, name + '.' + key, value[key]));
    }
    section.appendChild(div);

    return section;
  }
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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