"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _classnames = _interopRequireDefault(require("classnames"));

var _nodeEmoji = require("node-emoji");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _commitView = _interopRequireDefault(require("./commit-view"));

var _timeago = _interopRequireDefault(require("./timeago"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitView extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "undoLastCommit", event => {
      event.stopPropagation();
      this.props.undoLastCommit();
    });

    this.refRoot = new _refHolder.default();
  }

  componentDidMount() {
    if (this.props.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  componentDidUpdate(prevProps) {
    if (this.props.isSelected && !prevProps.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  render() {
    const authorMoment = (0, _moment.default)(this.props.commit.getAuthorDate() * 1000);
    const fullMessage = this.props.commit.getFullMessage();
    return _react.default.createElement("li", {
      ref: this.refRoot.setter,
      className: (0, _classnames.default)('github-RecentCommit', {
        'most-recent': this.props.isMostRecent,
        'is-selected': this.props.isSelected
      }),
      onClick: this.props.openCommit
    }, this.renderAuthors(), _react.default.createElement("span", {
      className: "github-RecentCommit-message",
      title: (0, _nodeEmoji.emojify)(fullMessage)
    }, (0, _nodeEmoji.emojify)(this.props.commit.getMessageSubject())), this.props.isMostRecent && _react.default.createElement("button", {
      className: "btn github-RecentCommit-undoButton",
      onClick: this.undoLastCommit
    }, "Undo"), _react.default.createElement(_timeago.default, {
      className: "github-RecentCommit-time",
      type: "time",
      displayStyle: "short",
      time: authorMoment,
      title: authorMoment.format('MMM Do, YYYY')
    }));
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);
    let avatarUrl;

    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react.default.createElement("img", {
      className: "github-RecentCommit-avatar",
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];
    return _react.default.createElement("span", {
      className: "github-RecentCommit-authors"
    }, authorEmails.map(this.renderAuthor));
  }

}

_defineProperty(RecentCommitView, "propTypes", {
  commit: _propTypes.default.object.isRequired,
  undoLastCommit: _propTypes.default.func.isRequired,
  isMostRecent: _propTypes.default.bool.isRequired,
  openCommit: _propTypes.default.func.isRequired,
  isSelected: _propTypes.default.bool.isRequired
});

class RecentCommitsView extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openSelectedCommit", () => this.props.openCommit({
      sha: this.props.selectedCommitSha,
      preserveFocus: false
    }));

    this.refRoot = new _refHolder.default();
  }

  setFocus(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return this.refRoot.map(element => {
        element.focus();
        return true;
      }).getOr(false);
    }

    return false;
  }

  getFocus(element) {
    return this.refRoot.map(e => e.contains(element)).getOr(false) ? this.constructor.focus.RECENT_COMMIT : null;
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-RecentCommits",
      tabIndex: "-1",
      ref: this.refRoot.setter
    }, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: this.refRoot
    }, _react.default.createElement(_commands.Command, {
      command: "core:move-down",
      callback: this.props.selectNextCommit
    }), _react.default.createElement(_commands.Command, {
      command: "core:move-up",
      callback: this.props.selectPreviousCommit
    }), _react.default.createElement(_commands.Command, {
      command: "github:dive",
      callback: this.openSelectedCommit
    })), this.renderCommits());
  }

  renderCommits() {
    if (this.props.commits.length === 0) {
      if (this.props.isLoading) {
        return _react.default.createElement("div", {
          className: "github-RecentCommits-message"
        }, "Recent commits");
      } else {
        return _react.default.createElement("div", {
          className: "github-RecentCommits-message"
        }, "Make your first commit");
      }
    } else {
      return _react.default.createElement("ul", {
        className: "github-RecentCommits-list"
      }, this.props.commits.map((commit, i) => {
        return _react.default.createElement(RecentCommitView, {
          key: commit.getSha(),
          isMostRecent: i === 0,
          commit: commit,
          undoLastCommit: this.props.undoLastCommit,
          openCommit: () => this.props.openCommit({
            sha: commit.getSha(),
            preserveFocus: true
          }),
          isSelected: this.props.selectedCommitSha === commit.getSha()
        });
      }));
    }
  }

  advanceFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(this.constructor.focus.RECENT_COMMIT);
    }

    return Promise.resolve(null);
  }

  retreatFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(_commitView.default.lastFocus);
    }

    return Promise.resolve(null);
  }

}

exports.default = RecentCommitsView;

_defineProperty(RecentCommitsView, "propTypes", {
  // Model state
  commits: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  selectedCommitSha: _propTypes.default.string.isRequired,
  // Atom environment
  commandRegistry: _propTypes.default.object.isRequired,
  // Action methods
  undoLastCommit: _propTypes.default.func.isRequired,
  openCommit: _propTypes.default.func.isRequired,
  selectNextCommit: _propTypes.default.func.isRequired,
  selectPreviousCommit: _propTypes.default.func.isRequired
});

_defineProperty(RecentCommitsView, "focus", {
  RECENT_COMMIT: Symbol('recent_commit')
});

_defineProperty(RecentCommitsView, "firstFocus", RecentCommitsView.focus.RECENT_COMMIT);

_defineProperty(RecentCommitsView, "lastFocus", RecentCommitsView.focus.RECENT_COMMIT);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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