"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _atom = require("atom");

var _stagingView = _interopRequireDefault(require("./staging-view"));

var _commitController = _interopRequireDefault(require("../controllers/commit-controller"));

var _recentCommitsController = _interopRequireDefault(require("../controllers/recent-commits-controller"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabView extends _react.default.Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'initializeRepo', 'blur', 'advanceFocus', 'retreatFocus', 'quietlySelectItem');
    this.subscriptions = new _atom.CompositeDisposable();
    this.refCommitController = new _refHolder.default();
    this.refRecentCommitsController = new _refHolder.default();
  }

  componentDidMount() {
    this.props.refRoot.map(root => {
      return this.subscriptions.add(this.props.commandRegistry.add(root, {
        'tool-panel:unfocus': this.blur,
        'core:focus-next': this.advanceFocus,
        'core:focus-previous': this.retreatFocus
      }));
    });
  }

  render() {
    if (this.props.repository.isTooLarge()) {
      return _react.default.createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react.default.createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git too-many-changes"
      }, _react.default.createElement("div", {
        className: "github-Git-LargeIcon icon icon-diff"
      }), _react.default.createElement("h1", null, "Too many changes"), _react.default.createElement("div", {
        className: "initialize-repo-description"
      }, "The repository at ", _react.default.createElement("strong", null, this.props.workingDirectoryPath), " has too many changed files to display in Atom. Ensure that you have set up an appropriate ", _react.default.createElement("code", null, ".gitignore"), " file.")));
    } else if (this.props.repository.hasDirectory() && !(0, _helpers.isValidWorkdir)(this.props.repository.getWorkingDirectoryPath())) {
      return _react.default.createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react.default.createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git unsupported-directory"
      }, _react.default.createElement("div", {
        className: "github-Git-LargeIcon icon icon-alert"
      }), _react.default.createElement("h1", null, "Unsupported directory"), _react.default.createElement("div", {
        className: "initialize-repo-description"
      }, "Atom does not support managing Git repositories in your home or root directories.")));
    } else if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? _react.default.createElement("span", null, "Initialize ", _react.default.createElement("strong", null, this.props.workingDirectoryPath), " with a Git repository") : _react.default.createElement("span", null, "Initialize a new project directory with a Git repository");
      return _react.default.createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react.default.createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git no-repository"
      }, _react.default.createElement("div", {
        className: "github-Git-LargeIcon icon icon-repo"
      }), _react.default.createElement("h1", null, "Create Repository"), _react.default.createElement("div", {
        className: "initialize-repo-description"
      }, message), _react.default.createElement("button", {
        onClick: this.initializeRepo,
        disabled: inProgress,
        className: "btn btn-primary"
      }, inProgress ? 'Creating repository...' : 'Create repository')));
    } else {
      const isLoading = this.props.isLoading || this.props.repository.showGitTabLoading();
      return _react.default.createElement("div", {
        className: (0, _classnames.default)('github-Git', {
          'is-loading': isLoading
        }),
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react.default.createElement(_stagingView.default, {
        ref: this.props.refStagingView.setter,
        commandRegistry: this.props.commandRegistry,
        notificationManager: this.props.notificationManager,
        workspace: this.props.workspace,
        stagedChanges: this.props.stagedChanges,
        unstagedChanges: this.props.unstagedChanges,
        mergeConflicts: this.props.mergeConflicts,
        workingDirectoryPath: this.props.workingDirectoryPath,
        resolutionProgress: this.props.resolutionProgress,
        openFiles: this.props.openFiles,
        discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
        attemptFileStageOperation: this.props.attemptFileStageOperation,
        attemptStageAllOperation: this.props.attemptStageAllOperation,
        undoLastDiscard: this.props.undoLastDiscard,
        abortMerge: this.props.abortMerge,
        resolveAsOurs: this.props.resolveAsOurs,
        resolveAsTheirs: this.props.resolveAsTheirs,
        lastCommit: this.props.lastCommit,
        isLoading: this.props.isLoading,
        hasUndoHistory: this.props.hasUndoHistory,
        isMerging: this.props.isMerging
      }), _react.default.createElement(_commitController.default, {
        ref: this.refCommitController.setter,
        tooltips: this.props.tooltips,
        config: this.props.config,
        stagedChangesExist: this.props.stagedChanges.length > 0,
        mergeConflictsExist: this.props.mergeConflicts.length > 0,
        prepareToCommit: this.props.prepareToCommit,
        commit: this.props.commit,
        abortMerge: this.props.abortMerge,
        currentBranch: this.props.currentBranch,
        workspace: this.props.workspace,
        commandRegistry: this.props.commandRegistry,
        notificationManager: this.props.notificationManager,
        grammars: this.props.grammars,
        mergeMessage: this.props.mergeMessage,
        isMerging: this.props.isMerging,
        isLoading: this.props.isLoading,
        lastCommit: this.props.lastCommit,
        repository: this.props.repository,
        userStore: this.props.userStore,
        selectedCoAuthors: this.props.selectedCoAuthors,
        updateSelectedCoAuthors: this.props.updateSelectedCoAuthors
      }), _react.default.createElement(_recentCommitsController.default, {
        ref: this.refRecentCommitsController.setter,
        commandRegistry: this.props.commandRegistry,
        commits: this.props.recentCommits,
        isLoading: this.props.isLoading,
        undoLastCommit: this.props.undoLastCommit,
        workspace: this.props.workspace,
        repository: this.props.repository
      }));
    }
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  initializeRepo(event) {
    event.preventDefault();
    let initPath = null;
    const activeEditor = this.props.workspace.getActiveTextEditor();

    if (activeEditor) {
      const [projectPath] = this.props.project.relativizePath(activeEditor.getPath());

      if (projectPath) {
        initPath = projectPath;
      }
    }

    this.props.initializeRepo(initPath);
  }

  getFocus(element) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const focus = ref.map(sub => sub.getFocus(element)).getOr(null);

      if (focus !== null) {
        return focus;
      }
    }

    return null;
  }

  setFocus(focus) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      if (ref.map(sub => sub.setFocus(focus)).getOr(false)) {
        return true;
      }
    }

    return false;
  }

  blur() {
    this.props.workspace.getCenter().activate();
  }

  async advanceFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let nextSeen = false;

    for (const subHolder of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const next = await subHolder.map(sub => sub.advanceFocusFrom(currentFocus)).getOr(null);

      if (next !== null && !nextSeen) {
        nextSeen = true;
        evt.stopPropagation();

        if (next !== currentFocus) {
          this.setFocus(next);
        }
      }
    }
  }

  async retreatFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let previousSeen = false;

    for (const subHolder of [this.refRecentCommitsController, this.refCommitController, this.props.refStagingView]) {
      const previous = await subHolder.map(sub => sub.retreatFocusFrom(currentFocus)).getOr(null);

      if (previous !== null && !previousSeen) {
        previousSeen = true;
        evt.stopPropagation();

        if (previous !== currentFocus) {
          this.setFocus(previous);
        }
      }
    }
  }

  async focusAndSelectStagingItem(filePath, stagingStatus) {
    await this.quietlySelectItem(filePath, stagingStatus);
    this.setFocus(GitTabView.focus.STAGING);
  }

  focusAndSelectRecentCommit() {
    this.setFocus(_recentCommitsController.default.focus.RECENT_COMMIT);
  }

  focusAndSelectCommitPreviewButton() {
    this.setFocus(GitTabView.focus.COMMIT_PREVIEW_BUTTON);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.props.refStagingView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(false);
  }

  hasFocus() {
    return this.props.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

}

exports.default = GitTabView;

_defineProperty(GitTabView, "focus", _objectSpread({}, _stagingView.default.focus, _commitController.default.focus, _recentCommitsController.default.focus));

_defineProperty(GitTabView, "propTypes", {
  refRoot: _propTypes2.RefHolderPropType,
  refStagingView: _propTypes2.RefHolderPropType,
  repository: _propTypes.default.object.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  lastCommit: _propTypes.default.object.isRequired,
  currentBranch: _propTypes.default.object,
  recentCommits: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  isMerging: _propTypes.default.bool,
  isRebasing: _propTypes.default.bool,
  hasUndoHistory: _propTypes.default.bool,
  unstagedChanges: _propTypes.default.arrayOf(_propTypes.default.object),
  stagedChanges: _propTypes.default.arrayOf(_propTypes.default.object),
  mergeConflicts: _propTypes.default.arrayOf(_propTypes.default.object),
  workingDirectoryPath: _propTypes.default.string,
  mergeMessage: _propTypes.default.string,
  userStore: _propTypes2.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes.default.arrayOf(_propTypes2.AuthorPropType),
  updateSelectedCoAuthors: _propTypes.default.func.isRequired,
  workspace: _propTypes.default.object.isRequired,
  commandRegistry: _propTypes.default.object.isRequired,
  grammars: _propTypes.default.object.isRequired,
  resolutionProgress: _propTypes.default.object.isRequired,
  notificationManager: _propTypes.default.object.isRequired,
  config: _propTypes.default.object.isRequired,
  project: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  initializeRepo: _propTypes.default.func.isRequired,
  abortMerge: _propTypes.default.func.isRequired,
  commit: _propTypes.default.func.isRequired,
  undoLastCommit: _propTypes.default.func.isRequired,
  prepareToCommit: _propTypes.default.func.isRequired,
  resolveAsOurs: _propTypes.default.func.isRequired,
  resolveAsTheirs: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  attemptStageAllOperation: _propTypes.default.func.isRequired,
  attemptFileStageOperation: _propTypes.default.func.isRequired,
  discardWorkDirChangesForPaths: _propTypes.default.func.isRequired,
  openFiles: _propTypes.default.func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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