"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BranchView extends _react.default.Component {
  render() {
    const classNames = (0, _classnames.default)('github-branch', 'inline-block', {
      'github-branch-detached': this.props.currentBranch.isDetached()
    });
    return _react.default.createElement("div", {
      className: classNames,
      ref: this.props.refRoot
    }, _react.default.createElement("span", {
      className: "icon icon-git-branch"
    }), _react.default.createElement("span", {
      className: "branch-label"
    }, this.props.currentBranch.getName()));
  }

}

exports.default = BranchView;

_defineProperty(BranchView, "propTypes", {
  currentBranch: _propTypes2.BranchPropType.isRequired,
  refRoot: _propTypes.default.func
});

_defineProperty(BranchView, "defaultProps", {
  refRoot: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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