"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accordion extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'toggle');
    this.state = {
      expanded: true
    };
  }

  render() {
    return _react.default.createElement("details", {
      className: "github-Accordion",
      open: this.state.expanded
    }, _react.default.createElement("summary", {
      className: "github-Accordion-header",
      onClick: this.toggle
    }, this.renderHeader()), _react.default.createElement("main", {
      className: "github-Accordion-content"
    }, this.renderContent()));
  }

  renderHeader() {
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("span", {
      className: "github-Accordion--leftTitle"
    }, this.props.leftTitle), this.props.rightTitle && _react.default.createElement("span", {
      className: "github-Accordion--rightTitle"
    }, this.props.rightTitle));
  }

  renderContent() {
    if (this.props.isLoading) {
      const Loading = this.props.loadingComponent;
      return _react.default.createElement(Loading, null);
    }

    if (this.props.results.length === 0) {
      const Empty = this.props.emptyComponent;
      return _react.default.createElement(Empty, null);
    }

    if (!this.state.expanded) {
      return null;
    }

    const More = this.props.moreComponent;
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement("ul", {
      className: "github-Accordion-list"
    }, this.props.results.map((item, index) => {
      const key = item.key !== undefined ? item.key : index;
      return _react.default.createElement("li", {
        className: "github-Accordion-listItem",
        key: key,
        onClick: () => this.props.onClickItem(item)
      }, this.props.children(item));
    })), this.props.results.length < this.props.total && _react.default.createElement(More, null));
  }

  toggle(e) {
    e.preventDefault();
    return new Promise(resolve => {
      this.setState(prevState => ({
        expanded: !prevState.expanded
      }), resolve);
    });
  }

}

exports.default = Accordion;

_defineProperty(Accordion, "propTypes", {
  leftTitle: _propTypes.default.string.isRequired,
  rightTitle: _propTypes.default.string,
  results: _propTypes.default.arrayOf(_propTypes.default.any).isRequired,
  total: _propTypes.default.number.isRequired,
  isLoading: _propTypes.default.bool.isRequired,
  loadingComponent: _propTypes.default.func,
  emptyComponent: _propTypes.default.func,
  moreComponent: _propTypes.default.func,
  onClickItem: _propTypes.default.func,
  children: _propTypes.default.func.isRequired
});

_defineProperty(Accordion, "defaultProps", {
  loadingComponent: () => null,
  emptyComponent: () => null,
  moreComponent: () => null,
  onClickItem: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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