"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _branchView = _interopRequireDefault(require("../views/branch-view"));

var _branchMenuView = _interopRequireDefault(require("../views/branch-menu-view"));

var _pushPullView = _interopRequireDefault(require("../views/push-pull-view"));

var _changedFilesCountView = _interopRequireDefault(require("../views/changed-files-count-view"));

var _githubTileView = _interopRequireDefault(require("../views/github-tile-view"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusBarTileController extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri.default)({
        currentBranch: repository.getCurrentBranch(),
        branches: repository.getBranches(),
        statusesForChangedFiles: repository.getStatusesForChangedFiles(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        aheadCount: async query => repository.getAheadCount((await query.currentBranch).getName()),
        behindCount: async query => repository.getBehindCount((await query.currentBranch).getName()),
        originExists: async () => (await repository.getRemotes()).withName('origin').isPresent()
      });
    });

    _defineProperty(this, "handleOpenGitTimingsView", e => {
      e && e.preventDefault();
      this.props.workspace.open('atom-github://debug/timings');
    });

    _defineProperty(this, "checkout", (branchName, options) => {
      return this.props.repository.checkout(branchName, options);
    });

    this.refBranchViewRoot = new _refHolder.default();
  }

  getChangedFilesCount(data) {
    const {
      stagedFiles,
      unstagedFiles,
      mergeConflictFiles
    } = data.statusesForChangedFiles;
    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }

    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }

    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    return _react.default.createElement(_observeModel.default, {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => data ? this.renderWithData(data) : null);
  }

  renderWithData(data) {
    let changedFilesCount, mergeConflictsPresent;

    if (data.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount(data);
      mergeConflictsPresent = Object.keys(data.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    const repoProps = {
      repository: this.props.repository,
      currentBranch: data.currentBranch,
      branches: data.branches,
      currentRemote: data.currentRemote,
      aheadCount: data.aheadCount,
      behindCount: data.behindCount,
      originExists: data.originExists,
      changedFilesCount,
      mergeConflictsPresent
    };
    return _react.default.createElement(_react.Fragment, null, this.renderTiles(repoProps), _react.default.createElement(_githubTileView.default, {
      didClick: this.props.toggleGithubTab
    }), _react.default.createElement(_changedFilesCountView.default, {
      didClick: this.props.toggleGitTab,
      changedFilesCount: repoProps.changedFilesCount,
      mergeConflictsPresent: repoProps.mergeConflictsPresent
    }));
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    const operationStates = this.props.repository.getOperationStates();
    const pushInProgress = operationStates.isPushInProgress();
    const pullInProgress = operationStates.isPullInProgress();
    const fetchInProgress = operationStates.isFetchInProgress();
    return _react.default.createElement(_react.Fragment, null, _react.default.createElement(_commands.default, {
      registry: this.props.commandRegistry,
      target: "atom-workspace"
    }, _react.default.createElement(_commands.Command, {
      command: "github:fetch",
      callback: this.fetch(repoProps)
    }), _react.default.createElement(_commands.Command, {
      command: "github:pull",
      callback: this.pull(repoProps)
    }), _react.default.createElement(_commands.Command, {
      command: "github:push",
      callback: () => this.push(repoProps)({
        force: false,
        setUpstream: !repoProps.currentRemote.isPresent()
      })
    }), _react.default.createElement(_commands.Command, {
      command: "github:force-push",
      callback: () => this.push(repoProps)({
        force: true,
        setUpstream: !repoProps.currentRemote.isPresent()
      })
    })), _react.default.createElement(_branchView.default, {
      refRoot: this.refBranchViewRoot.setter,
      workspace: this.props.workspace,
      checkout: this.checkout,
      currentBranch: repoProps.currentBranch
    }), _react.default.createElement(_tooltip.default, {
      manager: this.props.tooltips,
      target: this.refBranchViewRoot,
      trigger: "click",
      className: "github-StatusBarTileController-tooltipMenu"
    }, _react.default.createElement(_branchMenuView.default, {
      workspace: this.props.workspace,
      notificationManager: this.props.notificationManager,
      commandRegistry: this.props.commandRegistry,
      checkout: this.checkout,
      branches: repoProps.branches,
      currentBranch: repoProps.currentBranch
    })), _react.default.createElement(_pushPullView.default, {
      isSyncing: fetchInProgress || pullInProgress || pushInProgress,
      isFetching: fetchInProgress,
      isPulling: pullInProgress,
      isPushing: pushInProgress,
      push: this.push(repoProps),
      pull: this.pull(repoProps),
      fetch: this.fetch(repoProps),
      tooltipManager: this.props.tooltips,
      currentBranch: repoProps.currentBranch,
      currentRemote: repoProps.currentRemote,
      behindCount: repoProps.behindCount,
      aheadCount: repoProps.aheadCount,
      originExists: repoProps.originExists
    }));
  }

  push(data) {
    return ({
      force,
      setUpstream
    } = {}) => {
      return this.props.repository.push(data.currentBranch.getName(), {
        force,
        setUpstream,
        refSpec: data.currentBranch.getRefSpec('PUSH')
      });
    };
  }

  pull(data) {
    return () => {
      return this.props.repository.pull(data.currentBranch.getName(), {
        refSpec: data.currentBranch.getRefSpec('PULL')
      });
    };
  }

  fetch(data) {
    return () => {
      const upstream = data.currentBranch.getUpstream();
      return this.props.repository.fetch(upstream.getRemoteRef(), {
        remoteName: upstream.getRemoteName()
      });
    };
  }

}

exports.default = StatusBarTileController;

_defineProperty(StatusBarTileController, "propTypes", {
  workspace: _propTypes.default.object.isRequired,
  notificationManager: _propTypes.default.object.isRequired,
  commandRegistry: _propTypes.default.object.isRequired,
  tooltips: _propTypes.default.object.isRequired,
  confirm: _propTypes.default.func.isRequired,
  repository: _propTypes.default.object.isRequired,
  toggleGitTab: _propTypes.default.func,
  toggleGithubTab: _propTypes.default.func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInN0YXR1cy1iYXItdGlsZS1jb250cm9sbGVyLmpzIl0sIm5hbWVzIjpbIlN0YXR1c0JhclRpbGVDb250cm9sbGVyIiwiUmVhY3QiLCJDb21wb25lbnQiLCJjb25zdHJ1Y3RvciIsInByb3BzIiwicmVwb3NpdG9yeSIsImN1cnJlbnRCcmFuY2giLCJnZXRDdXJyZW50QnJhbmNoIiwiYnJhbmNoZXMiLCJnZXRCcmFuY2hlcyIsInN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzIiwiZ2V0U3RhdHVzZXNGb3JDaGFuZ2VkRmlsZXMiLCJjdXJyZW50UmVtb3RlIiwicXVlcnkiLCJnZXRSZW1vdGVGb3JCcmFuY2giLCJnZXROYW1lIiwiYWhlYWRDb3VudCIsImdldEFoZWFkQ291bnQiLCJiZWhpbmRDb3VudCIsImdldEJlaGluZENvdW50Iiwib3JpZ2luRXhpc3RzIiwiZ2V0UmVtb3RlcyIsIndpdGhOYW1lIiwiaXNQcmVzZW50IiwiZSIsInByZXZlbnREZWZhdWx0Iiwid29ya3NwYWNlIiwib3BlbiIsImJyYW5jaE5hbWUiLCJvcHRpb25zIiwiY2hlY2tvdXQiLCJyZWZCcmFuY2hWaWV3Um9vdCIsIlJlZkhvbGRlciIsImdldENoYW5nZWRGaWxlc0NvdW50IiwiZGF0YSIsInN0YWdlZEZpbGVzIiwidW5zdGFnZWRGaWxlcyIsIm1lcmdlQ29uZmxpY3RGaWxlcyIsImNoYW5nZWRGaWxlcyIsIlNldCIsImZpbGVQYXRoIiwiYWRkIiwic2l6ZSIsInJlbmRlciIsImZldGNoRGF0YSIsInJlbmRlcldpdGhEYXRhIiwiY2hhbmdlZEZpbGVzQ291bnQiLCJtZXJnZUNvbmZsaWN0c1ByZXNlbnQiLCJPYmplY3QiLCJrZXlzIiwibGVuZ3RoIiwicmVwb1Byb3BzIiwicmVuZGVyVGlsZXMiLCJ0b2dnbGVHaXRodWJUYWIiLCJ0b2dnbGVHaXRUYWIiLCJzaG93U3RhdHVzQmFyVGlsZXMiLCJvcGVyYXRpb25TdGF0ZXMiLCJnZXRPcGVyYXRpb25TdGF0ZXMiLCJwdXNoSW5Qcm9ncmVzcyIsImlzUHVzaEluUHJvZ3Jlc3MiLCJwdWxsSW5Qcm9ncmVzcyIsImlzUHVsbEluUHJvZ3Jlc3MiLCJmZXRjaEluUHJvZ3Jlc3MiLCJpc0ZldGNoSW5Qcm9ncmVzcyIsImNvbW1hbmRSZWdpc3RyeSIsImZldGNoIiwicHVsbCIsInB1c2giLCJmb3JjZSIsInNldFVwc3RyZWFtIiwic2V0dGVyIiwidG9vbHRpcHMiLCJub3RpZmljYXRpb25NYW5hZ2VyIiwicmVmU3BlYyIsImdldFJlZlNwZWMiLCJ1cHN0cmVhbSIsImdldFVwc3RyZWFtIiwiZ2V0UmVtb3RlUmVmIiwicmVtb3RlTmFtZSIsImdldFJlbW90ZU5hbWUiLCJQcm9wVHlwZXMiLCJvYmplY3QiLCJpc1JlcXVpcmVkIiwiY29uZmlybSIsImZ1bmMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7Ozs7Ozs7QUFFZSxNQUFNQSx1QkFBTixTQUFzQ0MsZUFBTUMsU0FBNUMsQ0FBc0Q7QUFZbkVDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRO0FBQ2pCLFVBQU1BLEtBQU47O0FBRGlCLHVDQXVCUEMsVUFBVSxJQUFJO0FBQ3hCLGFBQU8sdUJBQVM7QUFDZEMsUUFBQUEsYUFBYSxFQUFFRCxVQUFVLENBQUNFLGdCQUFYLEVBREQ7QUFFZEMsUUFBQUEsUUFBUSxFQUFFSCxVQUFVLENBQUNJLFdBQVgsRUFGSTtBQUdkQyxRQUFBQSx1QkFBdUIsRUFBRUwsVUFBVSxDQUFDTSwwQkFBWCxFQUhYO0FBSWRDLFFBQUFBLGFBQWEsRUFBRSxNQUFNQyxLQUFOLElBQWVSLFVBQVUsQ0FBQ1Msa0JBQVgsQ0FBOEIsQ0FBQyxNQUFNRCxLQUFLLENBQUNQLGFBQWIsRUFBNEJTLE9BQTVCLEVBQTlCLENBSmhCO0FBS2RDLFFBQUFBLFVBQVUsRUFBRSxNQUFNSCxLQUFOLElBQWVSLFVBQVUsQ0FBQ1ksYUFBWCxDQUF5QixDQUFDLE1BQU1KLEtBQUssQ0FBQ1AsYUFBYixFQUE0QlMsT0FBNUIsRUFBekIsQ0FMYjtBQU1kRyxRQUFBQSxXQUFXLEVBQUUsTUFBTUwsS0FBTixJQUFlUixVQUFVLENBQUNjLGNBQVgsQ0FBMEIsQ0FBQyxNQUFNTixLQUFLLENBQUNQLGFBQWIsRUFBNEJTLE9BQTVCLEVBQTFCLENBTmQ7QUFPZEssUUFBQUEsWUFBWSxFQUFFLFlBQVksQ0FBQyxNQUFNZixVQUFVLENBQUNnQixVQUFYLEVBQVAsRUFBZ0NDLFFBQWhDLENBQXlDLFFBQXpDLEVBQW1EQyxTQUFuRDtBQVBaLE9BQVQsQ0FBUDtBQVNELEtBakNrQjs7QUFBQSxzREEwSVFDLENBQUMsSUFBSTtBQUM5QkEsTUFBQUEsQ0FBQyxJQUFJQSxDQUFDLENBQUNDLGNBQUYsRUFBTDtBQUNBLFdBQUtyQixLQUFMLENBQVdzQixTQUFYLENBQXFCQyxJQUFyQixDQUEwQiw2QkFBMUI7QUFDRCxLQTdJa0I7O0FBQUEsc0NBK0lSLENBQUNDLFVBQUQsRUFBYUMsT0FBYixLQUF5QjtBQUNsQyxhQUFPLEtBQUt6QixLQUFMLENBQVdDLFVBQVgsQ0FBc0J5QixRQUF0QixDQUErQkYsVUFBL0IsRUFBMkNDLE9BQTNDLENBQVA7QUFDRCxLQWpKa0I7O0FBR2pCLFNBQUtFLGlCQUFMLEdBQXlCLElBQUlDLGtCQUFKLEVBQXpCO0FBQ0Q7O0FBRURDLEVBQUFBLG9CQUFvQixDQUFDQyxJQUFELEVBQU87QUFDekIsVUFBTTtBQUFDQyxNQUFBQSxXQUFEO0FBQWNDLE1BQUFBLGFBQWQ7QUFBNkJDLE1BQUFBO0FBQTdCLFFBQW1ESCxJQUFJLENBQUN4Qix1QkFBOUQ7QUFDQSxVQUFNNEIsWUFBWSxHQUFHLElBQUlDLEdBQUosRUFBckI7O0FBRUEsU0FBSyxNQUFNQyxRQUFYLElBQXVCSixhQUF2QixFQUFzQztBQUNwQ0UsTUFBQUEsWUFBWSxDQUFDRyxHQUFiLENBQWlCRCxRQUFqQjtBQUNEOztBQUNELFNBQUssTUFBTUEsUUFBWCxJQUF1QkwsV0FBdkIsRUFBb0M7QUFDbENHLE1BQUFBLFlBQVksQ0FBQ0csR0FBYixDQUFpQkQsUUFBakI7QUFDRDs7QUFDRCxTQUFLLE1BQU1BLFFBQVgsSUFBdUJILGtCQUF2QixFQUEyQztBQUN6Q0MsTUFBQUEsWUFBWSxDQUFDRyxHQUFiLENBQWlCRCxRQUFqQjtBQUNEOztBQUVELFdBQU9GLFlBQVksQ0FBQ0ksSUFBcEI7QUFDRDs7QUFjREMsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsV0FDRSw2QkFBQyxxQkFBRDtBQUFjLE1BQUEsS0FBSyxFQUFFLEtBQUt2QyxLQUFMLENBQVdDLFVBQWhDO0FBQTRDLE1BQUEsU0FBUyxFQUFFLEtBQUt1QztBQUE1RCxPQUNHVixJQUFJLElBQUtBLElBQUksR0FBRyxLQUFLVyxjQUFMLENBQW9CWCxJQUFwQixDQUFILEdBQStCLElBRC9DLENBREY7QUFLRDs7QUFFRFcsRUFBQUEsY0FBYyxDQUFDWCxJQUFELEVBQU87QUFDbkIsUUFBSVksaUJBQUosRUFBdUJDLHFCQUF2Qjs7QUFDQSxRQUFJYixJQUFJLENBQUN4Qix1QkFBVCxFQUFrQztBQUNoQ29DLE1BQUFBLGlCQUFpQixHQUFHLEtBQUtiLG9CQUFMLENBQTBCQyxJQUExQixDQUFwQjtBQUNBYSxNQUFBQSxxQkFBcUIsR0FBR0MsTUFBTSxDQUFDQyxJQUFQLENBQVlmLElBQUksQ0FBQ3hCLHVCQUFMLENBQTZCMkIsa0JBQXpDLEVBQTZEYSxNQUE3RCxHQUFzRSxDQUE5RjtBQUNEOztBQUVELFVBQU1DLFNBQVMsR0FBRztBQUNoQjlDLE1BQUFBLFVBQVUsRUFBRSxLQUFLRCxLQUFMLENBQVdDLFVBRFA7QUFFaEJDLE1BQUFBLGFBQWEsRUFBRTRCLElBQUksQ0FBQzVCLGFBRko7QUFHaEJFLE1BQUFBLFFBQVEsRUFBRTBCLElBQUksQ0FBQzFCLFFBSEM7QUFJaEJJLE1BQUFBLGFBQWEsRUFBRXNCLElBQUksQ0FBQ3RCLGFBSko7QUFLaEJJLE1BQUFBLFVBQVUsRUFBRWtCLElBQUksQ0FBQ2xCLFVBTEQ7QUFNaEJFLE1BQUFBLFdBQVcsRUFBRWdCLElBQUksQ0FBQ2hCLFdBTkY7QUFPaEJFLE1BQUFBLFlBQVksRUFBRWMsSUFBSSxDQUFDZCxZQVBIO0FBUWhCMEIsTUFBQUEsaUJBUmdCO0FBU2hCQyxNQUFBQTtBQVRnQixLQUFsQjtBQVlBLFdBQ0UsNkJBQUMsZUFBRCxRQUNHLEtBQUtLLFdBQUwsQ0FBaUJELFNBQWpCLENBREgsRUFFRSw2QkFBQyx1QkFBRDtBQUFnQixNQUFBLFFBQVEsRUFBRSxLQUFLL0MsS0FBTCxDQUFXaUQ7QUFBckMsTUFGRixFQUdFLDZCQUFDLDhCQUFEO0FBQ0UsTUFBQSxRQUFRLEVBQUUsS0FBS2pELEtBQUwsQ0FBV2tELFlBRHZCO0FBRUUsTUFBQSxpQkFBaUIsRUFBRUgsU0FBUyxDQUFDTCxpQkFGL0I7QUFHRSxNQUFBLHFCQUFxQixFQUFFSyxTQUFTLENBQUNKO0FBSG5DLE1BSEYsQ0FERjtBQVdEOztBQUVESyxFQUFBQSxXQUFXLENBQUNELFNBQUQsRUFBWTtBQUNyQixRQUFJLENBQUMsS0FBSy9DLEtBQUwsQ0FBV0MsVUFBWCxDQUFzQmtELGtCQUF0QixFQUFMLEVBQWlEO0FBQy9DLGFBQU8sSUFBUDtBQUNEOztBQUVELFVBQU1DLGVBQWUsR0FBRyxLQUFLcEQsS0FBTCxDQUFXQyxVQUFYLENBQXNCb0Qsa0JBQXRCLEVBQXhCO0FBQ0EsVUFBTUMsY0FBYyxHQUFHRixlQUFlLENBQUNHLGdCQUFoQixFQUF2QjtBQUNBLFVBQU1DLGNBQWMsR0FBR0osZUFBZSxDQUFDSyxnQkFBaEIsRUFBdkI7QUFDQSxVQUFNQyxlQUFlLEdBQUdOLGVBQWUsQ0FBQ08saUJBQWhCLEVBQXhCO0FBRUEsV0FDRSw2QkFBQyxlQUFELFFBQ0UsNkJBQUMsaUJBQUQ7QUFBVSxNQUFBLFFBQVEsRUFBRSxLQUFLM0QsS0FBTCxDQUFXNEQsZUFBL0I7QUFBZ0QsTUFBQSxNQUFNLEVBQUM7QUFBdkQsT0FDRSw2QkFBQyxpQkFBRDtBQUFTLE1BQUEsT0FBTyxFQUFDLGNBQWpCO0FBQWdDLE1BQUEsUUFBUSxFQUFFLEtBQUtDLEtBQUwsQ0FBV2QsU0FBWDtBQUExQyxNQURGLEVBRUUsNkJBQUMsaUJBQUQ7QUFBUyxNQUFBLE9BQU8sRUFBQyxhQUFqQjtBQUErQixNQUFBLFFBQVEsRUFBRSxLQUFLZSxJQUFMLENBQVVmLFNBQVY7QUFBekMsTUFGRixFQUdFLDZCQUFDLGlCQUFEO0FBQ0UsTUFBQSxPQUFPLEVBQUMsYUFEVjtBQUVFLE1BQUEsUUFBUSxFQUFFLE1BQU0sS0FBS2dCLElBQUwsQ0FBVWhCLFNBQVYsRUFBcUI7QUFBQ2lCLFFBQUFBLEtBQUssRUFBRSxLQUFSO0FBQWVDLFFBQUFBLFdBQVcsRUFBRSxDQUFDbEIsU0FBUyxDQUFDdkMsYUFBVixDQUF3QlcsU0FBeEI7QUFBN0IsT0FBckI7QUFGbEIsTUFIRixFQU9FLDZCQUFDLGlCQUFEO0FBQ0UsTUFBQSxPQUFPLEVBQUMsbUJBRFY7QUFFRSxNQUFBLFFBQVEsRUFBRSxNQUFNLEtBQUs0QyxJQUFMLENBQVVoQixTQUFWLEVBQXFCO0FBQUNpQixRQUFBQSxLQUFLLEVBQUUsSUFBUjtBQUFjQyxRQUFBQSxXQUFXLEVBQUUsQ0FBQ2xCLFNBQVMsQ0FBQ3ZDLGFBQVYsQ0FBd0JXLFNBQXhCO0FBQTVCLE9BQXJCO0FBRmxCLE1BUEYsQ0FERixFQWFFLDZCQUFDLG1CQUFEO0FBQ0UsTUFBQSxPQUFPLEVBQUUsS0FBS1EsaUJBQUwsQ0FBdUJ1QyxNQURsQztBQUVFLE1BQUEsU0FBUyxFQUFFLEtBQUtsRSxLQUFMLENBQVdzQixTQUZ4QjtBQUdFLE1BQUEsUUFBUSxFQUFFLEtBQUtJLFFBSGpCO0FBSUUsTUFBQSxhQUFhLEVBQUVxQixTQUFTLENBQUM3QztBQUozQixNQWJGLEVBbUJFLDZCQUFDLGdCQUFEO0FBQ0UsTUFBQSxPQUFPLEVBQUUsS0FBS0YsS0FBTCxDQUFXbUUsUUFEdEI7QUFFRSxNQUFBLE1BQU0sRUFBRSxLQUFLeEMsaUJBRmY7QUFHRSxNQUFBLE9BQU8sRUFBQyxPQUhWO0FBSUUsTUFBQSxTQUFTLEVBQUM7QUFKWixPQUtFLDZCQUFDLHVCQUFEO0FBQ0UsTUFBQSxTQUFTLEVBQUUsS0FBSzNCLEtBQUwsQ0FBV3NCLFNBRHhCO0FBRUUsTUFBQSxtQkFBbUIsRUFBRSxLQUFLdEIsS0FBTCxDQUFXb0UsbUJBRmxDO0FBR0UsTUFBQSxlQUFlLEVBQUUsS0FBS3BFLEtBQUwsQ0FBVzRELGVBSDlCO0FBSUUsTUFBQSxRQUFRLEVBQUUsS0FBS2xDLFFBSmpCO0FBS0UsTUFBQSxRQUFRLEVBQUVxQixTQUFTLENBQUMzQyxRQUx0QjtBQU1FLE1BQUEsYUFBYSxFQUFFMkMsU0FBUyxDQUFDN0M7QUFOM0IsTUFMRixDQW5CRixFQWlDRSw2QkFBQyxxQkFBRDtBQUNFLE1BQUEsU0FBUyxFQUFFd0QsZUFBZSxJQUFJRixjQUFuQixJQUFxQ0YsY0FEbEQ7QUFFRSxNQUFBLFVBQVUsRUFBRUksZUFGZDtBQUdFLE1BQUEsU0FBUyxFQUFFRixjQUhiO0FBSUUsTUFBQSxTQUFTLEVBQUVGLGNBSmI7QUFLRSxNQUFBLElBQUksRUFBRSxLQUFLUyxJQUFMLENBQVVoQixTQUFWLENBTFI7QUFNRSxNQUFBLElBQUksRUFBRSxLQUFLZSxJQUFMLENBQVVmLFNBQVYsQ0FOUjtBQU9FLE1BQUEsS0FBSyxFQUFFLEtBQUtjLEtBQUwsQ0FBV2QsU0FBWCxDQVBUO0FBUUUsTUFBQSxjQUFjLEVBQUUsS0FBSy9DLEtBQUwsQ0FBV21FLFFBUjdCO0FBU0UsTUFBQSxhQUFhLEVBQUVwQixTQUFTLENBQUM3QyxhQVQzQjtBQVVFLE1BQUEsYUFBYSxFQUFFNkMsU0FBUyxDQUFDdkMsYUFWM0I7QUFXRSxNQUFBLFdBQVcsRUFBRXVDLFNBQVMsQ0FBQ2pDLFdBWHpCO0FBWUUsTUFBQSxVQUFVLEVBQUVpQyxTQUFTLENBQUNuQyxVQVp4QjtBQWFFLE1BQUEsWUFBWSxFQUFFbUMsU0FBUyxDQUFDL0I7QUFiMUIsTUFqQ0YsQ0FERjtBQW1ERDs7QUFXRCtDLEVBQUFBLElBQUksQ0FBQ2pDLElBQUQsRUFBTztBQUNULFdBQU8sQ0FBQztBQUFDa0MsTUFBQUEsS0FBRDtBQUFRQyxNQUFBQTtBQUFSLFFBQXVCLEVBQXhCLEtBQStCO0FBQ3BDLGFBQU8sS0FBS2pFLEtBQUwsQ0FBV0MsVUFBWCxDQUFzQjhELElBQXRCLENBQTJCakMsSUFBSSxDQUFDNUIsYUFBTCxDQUFtQlMsT0FBbkIsRUFBM0IsRUFBeUQ7QUFDOURxRCxRQUFBQSxLQUQ4RDtBQUU5REMsUUFBQUEsV0FGOEQ7QUFHOURJLFFBQUFBLE9BQU8sRUFBRXZDLElBQUksQ0FBQzVCLGFBQUwsQ0FBbUJvRSxVQUFuQixDQUE4QixNQUE5QjtBQUhxRCxPQUF6RCxDQUFQO0FBS0QsS0FORDtBQU9EOztBQUVEUixFQUFBQSxJQUFJLENBQUNoQyxJQUFELEVBQU87QUFDVCxXQUFPLE1BQU07QUFDWCxhQUFPLEtBQUs5QixLQUFMLENBQVdDLFVBQVgsQ0FBc0I2RCxJQUF0QixDQUEyQmhDLElBQUksQ0FBQzVCLGFBQUwsQ0FBbUJTLE9BQW5CLEVBQTNCLEVBQXlEO0FBQzlEMEQsUUFBQUEsT0FBTyxFQUFFdkMsSUFBSSxDQUFDNUIsYUFBTCxDQUFtQm9FLFVBQW5CLENBQThCLE1BQTlCO0FBRHFELE9BQXpELENBQVA7QUFHRCxLQUpEO0FBS0Q7O0FBRURULEVBQUFBLEtBQUssQ0FBQy9CLElBQUQsRUFBTztBQUNWLFdBQU8sTUFBTTtBQUNYLFlBQU15QyxRQUFRLEdBQUd6QyxJQUFJLENBQUM1QixhQUFMLENBQW1Cc0UsV0FBbkIsRUFBakI7QUFDQSxhQUFPLEtBQUt4RSxLQUFMLENBQVdDLFVBQVgsQ0FBc0I0RCxLQUF0QixDQUE0QlUsUUFBUSxDQUFDRSxZQUFULEVBQTVCLEVBQXFEO0FBQzFEQyxRQUFBQSxVQUFVLEVBQUVILFFBQVEsQ0FBQ0ksYUFBVDtBQUQ4QyxPQUFyRCxDQUFQO0FBR0QsS0FMRDtBQU1EOztBQXhMa0U7Ozs7Z0JBQWhEL0UsdUIsZUFDQTtBQUNqQjBCLEVBQUFBLFNBQVMsRUFBRXNELG1CQUFVQyxNQUFWLENBQWlCQyxVQURYO0FBRWpCVixFQUFBQSxtQkFBbUIsRUFBRVEsbUJBQVVDLE1BQVYsQ0FBaUJDLFVBRnJCO0FBR2pCbEIsRUFBQUEsZUFBZSxFQUFFZ0IsbUJBQVVDLE1BQVYsQ0FBaUJDLFVBSGpCO0FBSWpCWCxFQUFBQSxRQUFRLEVBQUVTLG1CQUFVQyxNQUFWLENBQWlCQyxVQUpWO0FBS2pCQyxFQUFBQSxPQUFPLEVBQUVILG1CQUFVSSxJQUFWLENBQWVGLFVBTFA7QUFNakI3RSxFQUFBQSxVQUFVLEVBQUUyRSxtQkFBVUMsTUFBVixDQUFpQkMsVUFOWjtBQU9qQjVCLEVBQUFBLFlBQVksRUFBRTBCLG1CQUFVSSxJQVBQO0FBUWpCL0IsRUFBQUEsZUFBZSxFQUFFMkIsbUJBQVVJO0FBUlYsQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM2LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0LCB7RnJhZ21lbnR9IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5cbmltcG9ydCBCcmFuY2hWaWV3IGZyb20gJy4uL3ZpZXdzL2JyYW5jaC12aWV3JztcbmltcG9ydCBCcmFuY2hNZW51VmlldyBmcm9tICcuLi92aWV3cy9icmFuY2gtbWVudS12aWV3JztcbmltcG9ydCBQdXNoUHVsbFZpZXcgZnJvbSAnLi4vdmlld3MvcHVzaC1wdWxsLXZpZXcnO1xuaW1wb3J0IENoYW5nZWRGaWxlc0NvdW50VmlldyBmcm9tICcuLi92aWV3cy9jaGFuZ2VkLWZpbGVzLWNvdW50LXZpZXcnO1xuaW1wb3J0IEdpdGh1YlRpbGVWaWV3IGZyb20gJy4uL3ZpZXdzL2dpdGh1Yi10aWxlLXZpZXcnO1xuaW1wb3J0IFRvb2x0aXAgZnJvbSAnLi4vYXRvbS90b29sdGlwJztcbmltcG9ydCBDb21tYW5kcywge0NvbW1hbmR9IGZyb20gJy4uL2F0b20vY29tbWFuZHMnO1xuaW1wb3J0IE9ic2VydmVNb2RlbCBmcm9tICcuLi92aWV3cy9vYnNlcnZlLW1vZGVsJztcbmltcG9ydCBSZWZIb2xkZXIgZnJvbSAnLi4vbW9kZWxzL3JlZi1ob2xkZXInO1xuaW1wb3J0IHl1YmlraXJpIGZyb20gJ3l1YmlraXJpJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU3RhdHVzQmFyVGlsZUNvbnRyb2xsZXIgZXh0ZW5kcyBSZWFjdC5Db21wb25lbnQge1xuICBzdGF0aWMgcHJvcFR5cGVzID0ge1xuICAgIHdvcmtzcGFjZTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIG5vdGlmaWNhdGlvbk1hbmFnZXI6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICBjb21tYW5kUmVnaXN0cnk6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcbiAgICB0b29sdGlwczogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIGNvbmZpcm06IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG4gICAgcmVwb3NpdG9yeTogUHJvcFR5cGVzLm9iamVjdC5pc1JlcXVpcmVkLFxuICAgIHRvZ2dsZUdpdFRhYjogUHJvcFR5cGVzLmZ1bmMsXG4gICAgdG9nZ2xlR2l0aHViVGFiOiBQcm9wVHlwZXMuZnVuYyxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yKHByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuXG4gICAgdGhpcy5yZWZCcmFuY2hWaWV3Um9vdCA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgfVxuXG4gIGdldENoYW5nZWRGaWxlc0NvdW50KGRhdGEpIHtcbiAgICBjb25zdCB7c3RhZ2VkRmlsZXMsIHVuc3RhZ2VkRmlsZXMsIG1lcmdlQ29uZmxpY3RGaWxlc30gPSBkYXRhLnN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzO1xuICAgIGNvbnN0IGNoYW5nZWRGaWxlcyA9IG5ldyBTZXQoKTtcblxuICAgIGZvciAoY29uc3QgZmlsZVBhdGggaW4gdW5zdGFnZWRGaWxlcykge1xuICAgICAgY2hhbmdlZEZpbGVzLmFkZChmaWxlUGF0aCk7XG4gICAgfVxuICAgIGZvciAoY29uc3QgZmlsZVBhdGggaW4gc3RhZ2VkRmlsZXMpIHtcbiAgICAgIGNoYW5nZWRGaWxlcy5hZGQoZmlsZVBhdGgpO1xuICAgIH1cbiAgICBmb3IgKGNvbnN0IGZpbGVQYXRoIGluIG1lcmdlQ29uZmxpY3RGaWxlcykge1xuICAgICAgY2hhbmdlZEZpbGVzLmFkZChmaWxlUGF0aCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIGNoYW5nZWRGaWxlcy5zaXplO1xuICB9XG5cbiAgZmV0Y2hEYXRhID0gcmVwb3NpdG9yeSA9PiB7XG4gICAgcmV0dXJuIHl1YmlraXJpKHtcbiAgICAgIGN1cnJlbnRCcmFuY2g6IHJlcG9zaXRvcnkuZ2V0Q3VycmVudEJyYW5jaCgpLFxuICAgICAgYnJhbmNoZXM6IHJlcG9zaXRvcnkuZ2V0QnJhbmNoZXMoKSxcbiAgICAgIHN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzOiByZXBvc2l0b3J5LmdldFN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzKCksXG4gICAgICBjdXJyZW50UmVtb3RlOiBhc3luYyBxdWVyeSA9PiByZXBvc2l0b3J5LmdldFJlbW90ZUZvckJyYW5jaCgoYXdhaXQgcXVlcnkuY3VycmVudEJyYW5jaCkuZ2V0TmFtZSgpKSxcbiAgICAgIGFoZWFkQ291bnQ6IGFzeW5jIHF1ZXJ5ID0+IHJlcG9zaXRvcnkuZ2V0QWhlYWRDb3VudCgoYXdhaXQgcXVlcnkuY3VycmVudEJyYW5jaCkuZ2V0TmFtZSgpKSxcbiAgICAgIGJlaGluZENvdW50OiBhc3luYyBxdWVyeSA9PiByZXBvc2l0b3J5LmdldEJlaGluZENvdW50KChhd2FpdCBxdWVyeS5jdXJyZW50QnJhbmNoKS5nZXROYW1lKCkpLFxuICAgICAgb3JpZ2luRXhpc3RzOiBhc3luYyAoKSA9PiAoYXdhaXQgcmVwb3NpdG9yeS5nZXRSZW1vdGVzKCkpLndpdGhOYW1lKCdvcmlnaW4nKS5pc1ByZXNlbnQoKSxcbiAgICB9KTtcbiAgfVxuXG4gIHJlbmRlcigpIHtcbiAgICByZXR1cm4gKFxuICAgICAgPE9ic2VydmVNb2RlbCBtb2RlbD17dGhpcy5wcm9wcy5yZXBvc2l0b3J5fSBmZXRjaERhdGE9e3RoaXMuZmV0Y2hEYXRhfT5cbiAgICAgICAge2RhdGEgPT4gKGRhdGEgPyB0aGlzLnJlbmRlcldpdGhEYXRhKGRhdGEpIDogbnVsbCl9XG4gICAgICA8L09ic2VydmVNb2RlbD5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyV2l0aERhdGEoZGF0YSkge1xuICAgIGxldCBjaGFuZ2VkRmlsZXNDb3VudCwgbWVyZ2VDb25mbGljdHNQcmVzZW50O1xuICAgIGlmIChkYXRhLnN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzKSB7XG4gICAgICBjaGFuZ2VkRmlsZXNDb3VudCA9IHRoaXMuZ2V0Q2hhbmdlZEZpbGVzQ291bnQoZGF0YSk7XG4gICAgICBtZXJnZUNvbmZsaWN0c1ByZXNlbnQgPSBPYmplY3Qua2V5cyhkYXRhLnN0YXR1c2VzRm9yQ2hhbmdlZEZpbGVzLm1lcmdlQ29uZmxpY3RGaWxlcykubGVuZ3RoID4gMDtcbiAgICB9XG5cbiAgICBjb25zdCByZXBvUHJvcHMgPSB7XG4gICAgICByZXBvc2l0b3J5OiB0aGlzLnByb3BzLnJlcG9zaXRvcnksXG4gICAgICBjdXJyZW50QnJhbmNoOiBkYXRhLmN1cnJlbnRCcmFuY2gsXG4gICAgICBicmFuY2hlczogZGF0YS5icmFuY2hlcyxcbiAgICAgIGN1cnJlbnRSZW1vdGU6IGRhdGEuY3VycmVudFJlbW90ZSxcbiAgICAgIGFoZWFkQ291bnQ6IGRhdGEuYWhlYWRDb3VudCxcbiAgICAgIGJlaGluZENvdW50OiBkYXRhLmJlaGluZENvdW50LFxuICAgICAgb3JpZ2luRXhpc3RzOiBkYXRhLm9yaWdpbkV4aXN0cyxcbiAgICAgIGNoYW5nZWRGaWxlc0NvdW50LFxuICAgICAgbWVyZ2VDb25mbGljdHNQcmVzZW50LFxuICAgIH07XG5cbiAgICByZXR1cm4gKFxuICAgICAgPEZyYWdtZW50PlxuICAgICAgICB7dGhpcy5yZW5kZXJUaWxlcyhyZXBvUHJvcHMpfVxuICAgICAgICA8R2l0aHViVGlsZVZpZXcgZGlkQ2xpY2s9e3RoaXMucHJvcHMudG9nZ2xlR2l0aHViVGFifSAvPlxuICAgICAgICA8Q2hhbmdlZEZpbGVzQ291bnRWaWV3XG4gICAgICAgICAgZGlkQ2xpY2s9e3RoaXMucHJvcHMudG9nZ2xlR2l0VGFifVxuICAgICAgICAgIGNoYW5nZWRGaWxlc0NvdW50PXtyZXBvUHJvcHMuY2hhbmdlZEZpbGVzQ291bnR9XG4gICAgICAgICAgbWVyZ2VDb25mbGljdHNQcmVzZW50PXtyZXBvUHJvcHMubWVyZ2VDb25mbGljdHNQcmVzZW50fVxuICAgICAgICAvPlxuICAgICAgPC9GcmFnbWVudD5cbiAgICApO1xuICB9XG5cbiAgcmVuZGVyVGlsZXMocmVwb1Byb3BzKSB7XG4gICAgaWYgKCF0aGlzLnByb3BzLnJlcG9zaXRvcnkuc2hvd1N0YXR1c0JhclRpbGVzKCkpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIGNvbnN0IG9wZXJhdGlvblN0YXRlcyA9IHRoaXMucHJvcHMucmVwb3NpdG9yeS5nZXRPcGVyYXRpb25TdGF0ZXMoKTtcbiAgICBjb25zdCBwdXNoSW5Qcm9ncmVzcyA9IG9wZXJhdGlvblN0YXRlcy5pc1B1c2hJblByb2dyZXNzKCk7XG4gICAgY29uc3QgcHVsbEluUHJvZ3Jlc3MgPSBvcGVyYXRpb25TdGF0ZXMuaXNQdWxsSW5Qcm9ncmVzcygpO1xuICAgIGNvbnN0IGZldGNoSW5Qcm9ncmVzcyA9IG9wZXJhdGlvblN0YXRlcy5pc0ZldGNoSW5Qcm9ncmVzcygpO1xuXG4gICAgcmV0dXJuIChcbiAgICAgIDxGcmFnbWVudD5cbiAgICAgICAgPENvbW1hbmRzIHJlZ2lzdHJ5PXt0aGlzLnByb3BzLmNvbW1hbmRSZWdpc3RyeX0gdGFyZ2V0PVwiYXRvbS13b3Jrc3BhY2VcIj5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOmZldGNoXCIgY2FsbGJhY2s9e3RoaXMuZmV0Y2gocmVwb1Byb3BzKX0gLz5cbiAgICAgICAgICA8Q29tbWFuZCBjb21tYW5kPVwiZ2l0aHViOnB1bGxcIiBjYWxsYmFjaz17dGhpcy5wdWxsKHJlcG9Qcm9wcyl9IC8+XG4gICAgICAgICAgPENvbW1hbmRcbiAgICAgICAgICAgIGNvbW1hbmQ9XCJnaXRodWI6cHVzaFwiXG4gICAgICAgICAgICBjYWxsYmFjaz17KCkgPT4gdGhpcy5wdXNoKHJlcG9Qcm9wcykoe2ZvcmNlOiBmYWxzZSwgc2V0VXBzdHJlYW06ICFyZXBvUHJvcHMuY3VycmVudFJlbW90ZS5pc1ByZXNlbnQoKX0pfVxuICAgICAgICAgIC8+XG4gICAgICAgICAgPENvbW1hbmRcbiAgICAgICAgICAgIGNvbW1hbmQ9XCJnaXRodWI6Zm9yY2UtcHVzaFwiXG4gICAgICAgICAgICBjYWxsYmFjaz17KCkgPT4gdGhpcy5wdXNoKHJlcG9Qcm9wcykoe2ZvcmNlOiB0cnVlLCBzZXRVcHN0cmVhbTogIXJlcG9Qcm9wcy5jdXJyZW50UmVtb3RlLmlzUHJlc2VudCgpfSl9XG4gICAgICAgICAgLz5cbiAgICAgICAgPC9Db21tYW5kcz5cbiAgICAgICAgPEJyYW5jaFZpZXdcbiAgICAgICAgICByZWZSb290PXt0aGlzLnJlZkJyYW5jaFZpZXdSb290LnNldHRlcn1cbiAgICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICAgIGNoZWNrb3V0PXt0aGlzLmNoZWNrb3V0fVxuICAgICAgICAgIGN1cnJlbnRCcmFuY2g9e3JlcG9Qcm9wcy5jdXJyZW50QnJhbmNofVxuICAgICAgICAvPlxuICAgICAgICA8VG9vbHRpcFxuICAgICAgICAgIG1hbmFnZXI9e3RoaXMucHJvcHMudG9vbHRpcHN9XG4gICAgICAgICAgdGFyZ2V0PXt0aGlzLnJlZkJyYW5jaFZpZXdSb290fVxuICAgICAgICAgIHRyaWdnZXI9XCJjbGlja1wiXG4gICAgICAgICAgY2xhc3NOYW1lPVwiZ2l0aHViLVN0YXR1c0JhclRpbGVDb250cm9sbGVyLXRvb2x0aXBNZW51XCI+XG4gICAgICAgICAgPEJyYW5jaE1lbnVWaWV3XG4gICAgICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICAgICAgbm90aWZpY2F0aW9uTWFuYWdlcj17dGhpcy5wcm9wcy5ub3RpZmljYXRpb25NYW5hZ2VyfVxuICAgICAgICAgICAgY29tbWFuZFJlZ2lzdHJ5PXt0aGlzLnByb3BzLmNvbW1hbmRSZWdpc3RyeX1cbiAgICAgICAgICAgIGNoZWNrb3V0PXt0aGlzLmNoZWNrb3V0fVxuICAgICAgICAgICAgYnJhbmNoZXM9e3JlcG9Qcm9wcy5icmFuY2hlc31cbiAgICAgICAgICAgIGN1cnJlbnRCcmFuY2g9e3JlcG9Qcm9wcy5jdXJyZW50QnJhbmNofVxuICAgICAgICAgIC8+XG4gICAgICAgIDwvVG9vbHRpcD5cbiAgICAgICAgPFB1c2hQdWxsVmlld1xuICAgICAgICAgIGlzU3luY2luZz17ZmV0Y2hJblByb2dyZXNzIHx8IHB1bGxJblByb2dyZXNzIHx8IHB1c2hJblByb2dyZXNzfVxuICAgICAgICAgIGlzRmV0Y2hpbmc9e2ZldGNoSW5Qcm9ncmVzc31cbiAgICAgICAgICBpc1B1bGxpbmc9e3B1bGxJblByb2dyZXNzfVxuICAgICAgICAgIGlzUHVzaGluZz17cHVzaEluUHJvZ3Jlc3N9XG4gICAgICAgICAgcHVzaD17dGhpcy5wdXNoKHJlcG9Qcm9wcyl9XG4gICAgICAgICAgcHVsbD17dGhpcy5wdWxsKHJlcG9Qcm9wcyl9XG4gICAgICAgICAgZmV0Y2g9e3RoaXMuZmV0Y2gocmVwb1Byb3BzKX1cbiAgICAgICAgICB0b29sdGlwTWFuYWdlcj17dGhpcy5wcm9wcy50b29sdGlwc31cbiAgICAgICAgICBjdXJyZW50QnJhbmNoPXtyZXBvUHJvcHMuY3VycmVudEJyYW5jaH1cbiAgICAgICAgICBjdXJyZW50UmVtb3RlPXtyZXBvUHJvcHMuY3VycmVudFJlbW90ZX1cbiAgICAgICAgICBiZWhpbmRDb3VudD17cmVwb1Byb3BzLmJlaGluZENvdW50fVxuICAgICAgICAgIGFoZWFkQ291bnQ9e3JlcG9Qcm9wcy5haGVhZENvdW50fVxuICAgICAgICAgIG9yaWdpbkV4aXN0cz17cmVwb1Byb3BzLm9yaWdpbkV4aXN0c31cbiAgICAgICAgLz5cbiAgICAgIDwvRnJhZ21lbnQ+XG4gICAgKTtcbiAgfVxuXG4gIGhhbmRsZU9wZW5HaXRUaW1pbmdzVmlldyA9IGUgPT4ge1xuICAgIGUgJiYgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgIHRoaXMucHJvcHMud29ya3NwYWNlLm9wZW4oJ2F0b20tZ2l0aHViOi8vZGVidWcvdGltaW5ncycpO1xuICB9XG5cbiAgY2hlY2tvdXQgPSAoYnJhbmNoTmFtZSwgb3B0aW9ucykgPT4ge1xuICAgIHJldHVybiB0aGlzLnByb3BzLnJlcG9zaXRvcnkuY2hlY2tvdXQoYnJhbmNoTmFtZSwgb3B0aW9ucyk7XG4gIH1cblxuICBwdXNoKGRhdGEpIHtcbiAgICByZXR1cm4gKHtmb3JjZSwgc2V0VXBzdHJlYW19ID0ge30pID0+IHtcbiAgICAgIHJldHVybiB0aGlzLnByb3BzLnJlcG9zaXRvcnkucHVzaChkYXRhLmN1cnJlbnRCcmFuY2guZ2V0TmFtZSgpLCB7XG4gICAgICAgIGZvcmNlLFxuICAgICAgICBzZXRVcHN0cmVhbSxcbiAgICAgICAgcmVmU3BlYzogZGF0YS5jdXJyZW50QnJhbmNoLmdldFJlZlNwZWMoJ1BVU0gnKSxcbiAgICAgIH0pO1xuICAgIH07XG4gIH1cblxuICBwdWxsKGRhdGEpIHtcbiAgICByZXR1cm4gKCkgPT4ge1xuICAgICAgcmV0dXJuIHRoaXMucHJvcHMucmVwb3NpdG9yeS5wdWxsKGRhdGEuY3VycmVudEJyYW5jaC5nZXROYW1lKCksIHtcbiAgICAgICAgcmVmU3BlYzogZGF0YS5jdXJyZW50QnJhbmNoLmdldFJlZlNwZWMoJ1BVTEwnKSxcbiAgICAgIH0pO1xuICAgIH07XG4gIH1cblxuICBmZXRjaChkYXRhKSB7XG4gICAgcmV0dXJuICgpID0+IHtcbiAgICAgIGNvbnN0IHVwc3RyZWFtID0gZGF0YS5jdXJyZW50QnJhbmNoLmdldFVwc3RyZWFtKCk7XG4gICAgICByZXR1cm4gdGhpcy5wcm9wcy5yZXBvc2l0b3J5LmZldGNoKHVwc3RyZWFtLmdldFJlbW90ZVJlZigpLCB7XG4gICAgICAgIHJlbW90ZU5hbWU6IHVwc3RyZWFtLmdldFJlbW90ZU5hbWUoKSxcbiAgICAgIH0pO1xuICAgIH07XG4gIH1cbn1cbiJdfQ==