function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var assert = require('assert');
var fs = require('fs');
var sinon = require('sinon');
var path = require('path');

var dalek = require('../lib/dalek');

describe('dalek', function () {
  describe('enumerate', function () {
    var availablePackages = {};
    var realPaths = {};
    var bundledPackages = [];
    var packageDirPaths = [];
    var sandbox = null;

    beforeEach(function () {
      availablePackages = {
        'an-unduplicated-installed-package': path.join('Users', 'username', '.atom', 'packages', 'an-unduplicated-installed-package'),
        'duplicated-package': path.join('Users', 'username', '.atom', 'packages', 'duplicated-package'),
        'unduplicated-package': path.join('' + atom.getLoadSettings().resourcePath, 'node_modules', 'unduplicated-package')
      };

      atom.devMode = false;
      bundledPackages = ['duplicated-package', 'unduplicated-package'];
      packageDirPaths = [path.join('Users', 'username', '.atom', 'packages')];
      sandbox = sinon.sandbox.create();
      sandbox.stub(dalek, 'realpath').callsFake(function (filePath) {
        return Promise.resolve(realPaths[filePath] || filePath);
      });
      sandbox.stub(atom.packages, 'isBundledPackage').callsFake(function (packageName) {
        return bundledPackages.includes(packageName);
      });
      sandbox.stub(atom.packages, 'getAvailablePackageNames').callsFake(function () {
        return Object.keys(availablePackages);
      });
      sandbox.stub(atom.packages, 'getPackageDirPaths').callsFake(function () {
        return packageDirPaths;
      });
      sandbox.stub(fs, 'existsSync').callsFake(function (candidate) {
        return Object.values(availablePackages).includes(candidate) && !candidate.includes(atom.getLoadSettings().resourcePath);
      });
    });

    afterEach(function () {
      sandbox.restore();
    });

    it('returns a list of duplicate names', _asyncToGenerator(function* () {
      assert.deepEqual((yield dalek.enumerate()), ['duplicated-package']);
    }));

    describe('when in dev mode', function () {
      beforeEach(function () {
        atom.devMode = true;
      });

      it('always returns an empty list', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    });

    describe('when a package is symlinked into the package directory', _asyncToGenerator(function* () {
      beforeEach(function () {
        var realPath = path.join('Users', 'username', 'duplicated-package');
        var packagePath = path.join('Users', 'username', '.atom', 'packages', 'duplicated-package');
        realPaths[packagePath] = realPath;
      });

      it('is not included in the list of duplicate names', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    }));
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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