Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _underscorePlus = require('underscore-plus');

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _fuzzaldrinPlus = require('fuzzaldrin-plus');

var _fuzzaldrinPlus2 = _interopRequireDefault(_fuzzaldrinPlus);

var CommandPaletteView = (function () {
  function CommandPaletteView() {
    var _this = this;

    var initiallyVisibleItemCount = arguments.length <= 0 || arguments[0] === undefined ? 10 : arguments[0];

    _classCallCheck(this, CommandPaletteView);

    this.filter = function (items, query) {
      if (query.length === 0) {
        return items;
      }

      var scoredItems = [];
      for (var item of items) {
        var score = _this.fuzz.score(item.displayName, query);
        if (item.tags) {
          score += item.tags.reduce(function (currentScore, tag) {
            return currentScore + _this.fuzz.score(tag, query);
          }, 0);
        }
        if (item.description) {
          score += _this.fuzz.score(item.description, query);
        }

        if (score > 0) {
          scoredItems.push({ item: item, score: score });
        }
      }
      scoredItems.sort(function (a, b) {
        return b.score - a.score;
      });
      return scoredItems.map(function (i) {
        return i.item;
      });
    };

    this.keyBindingsForActiveElement = [];
    this.selectListView = new _atomSelectList2['default']({
      initiallyVisibleItemCount: initiallyVisibleItemCount, // just for being able to disable visible-on-render in spec
      items: [],
      filter: this.filter,
      emptyMessage: 'No matches found',
      elementForItem: function elementForItem(item, _ref) {
        var index = _ref.index;
        var selected = _ref.selected;
        var visible = _ref.visible;

        if (!visible) {
          return document.createElement("li");
        }

        var li = document.createElement('li');
        li.classList.add('event', 'two-lines');
        li.dataset.eventName = item.name;

        var rightBlock = document.createElement('div');
        rightBlock.classList.add('pull-right');

        _this.keyBindingsForActiveElement.filter(function (_ref2) {
          var command = _ref2.command;
          return command === item.name;
        }).forEach(function (keyBinding) {
          var kbd = document.createElement('kbd');
          kbd.classList.add('key-binding');
          kbd.textContent = (0, _underscorePlus.humanizeKeystroke)(keyBinding.keystrokes);
          rightBlock.appendChild(kbd);
        });
        li.appendChild(rightBlock);

        var leftBlock = document.createElement('div');
        var titleEl = document.createElement('div');
        titleEl.classList.add('primary-line');
        titleEl.title = item.name;
        leftBlock.appendChild(titleEl);

        var query = _this.selectListView.getQuery();
        _this.highlightMatchesInElement(item.displayName, query, titleEl);

        if (selected) {
          var secondaryEl = document.createElement('div');
          secondaryEl.classList.add('secondary-line');
          secondaryEl.style.display = 'flex';

          if (typeof item.description === 'string') {
            secondaryEl.appendChild(_this.createDescription(item.description, query));
          }

          if (Array.isArray(item.tags)) {
            var matchingTags = item.tags.map(function (t) {
              return [t, _this.fuzz.score(t, query)];
            }).filter(function (_ref3) {
              var _ref32 = _slicedToArray(_ref3, 2);

              var t = _ref32[0];
              var s = _ref32[1];
              return s > 0;
            }).sort(function (a, b) {
              return a.s - b.s;
            }).map(function (_ref4) {
              var _ref42 = _slicedToArray(_ref4, 2);

              var t = _ref42[0];
              var s = _ref42[1];
              return t;
            });

            if (matchingTags.length > 0) {
              secondaryEl.appendChild(_this.createTags(matchingTags, query));
            }
          }

          leftBlock.appendChild(secondaryEl);
        }

        li.appendChild(leftBlock);
        return li;
      },
      didConfirmSelection: function didConfirmSelection(keyBinding) {
        _this.hide();
        var event = new CustomEvent(keyBinding.name, { bubbles: true, cancelable: true });
        _this.activeElement.dispatchEvent(event);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      }
    });
    this.selectListView.element.classList.add('command-palette');
  }

  _createClass(CommandPaletteView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.selectListView.destroy();
    })
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.hide();
        return Promise.resolve();
      } else {
        return this.show();
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      var showHiddenCommands = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

      if (!this.panel) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }

      if (!this.preserveLastSearch) {
        this.selectListView.reset();
      } else {
        this.selectListView.refs.queryEditor.selectAll();
      }

      this.activeElement = document.activeElement === document.body ? atom.views.getView(atom.workspace) : document.activeElement;
      this.keyBindingsForActiveElement = atom.keymaps.findKeyBindings({ target: this.activeElement });
      var commandsForActiveElement = atom.commands.findCommands({ target: this.activeElement }).filter(function (command) {
        return showHiddenCommands === !!command.hiddenInCommandPalette;
      });
      commandsForActiveElement.sort(function (a, b) {
        return a.displayName.localeCompare(b.displayName);
      });
      yield this.selectListView.update({ items: commandsForActiveElement });

      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'update',
    value: _asyncToGenerator(function* (props) {
      if (props.hasOwnProperty('preserveLastSearch')) {
        this.preserveLastSearch = props.preserveLastSearch;
      }

      if (props.hasOwnProperty('useAlternateScoring')) {
        this.useAlternateScoring = props.useAlternateScoring;
      }
    })
  }, {
    key: 'highlightMatchesInElement',
    value: function highlightMatchesInElement(text, query, el) {
      var matches = this.fuzz.match(text, query);
      var matchedChars = [];
      var lastIndex = 0;
      for (var matchIndex of matches) {
        var _unmatched = text.substring(lastIndex, matchIndex);
        if (_unmatched) {
          if (matchedChars.length > 0) {
            var matchSpan = document.createElement('span');
            matchSpan.classList.add('character-match');
            matchSpan.textContent = matchedChars.join('');
            el.appendChild(matchSpan);
            matchedChars = [];
          }

          el.appendChild(document.createTextNode(_unmatched));
        }

        matchedChars.push(text[matchIndex]);
        lastIndex = matchIndex + 1;
      }

      if (matchedChars.length > 0) {
        var matchSpan = document.createElement('span');
        matchSpan.classList.add('character-match');
        matchSpan.textContent = matchedChars.join('');
        el.appendChild(matchSpan);
      }

      var unmatched = text.substring(lastIndex);
      if (unmatched) {
        el.appendChild(document.createTextNode(unmatched));
      }
    }
  }, {
    key: 'createDescription',
    value: function createDescription(description, query) {
      var descriptionEl = document.createElement('div');

      // in case of overflow, give full contents on long hover
      descriptionEl.title = description;

      Object.assign(descriptionEl.style, {
        flexGrow: 1,
        flexShrink: 1,
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        overflow: 'hidden'
      });
      this.highlightMatchesInElement(description, query, descriptionEl);
      return descriptionEl;
    }
  }, {
    key: 'createTag',
    value: function createTag(tagText, query) {
      var tagEl = document.createElement('li');
      Object.assign(tagEl.style, {
        borderBottom: 0,
        display: 'inline',
        padding: 0
      });
      this.highlightMatchesInElement(tagText, query, tagEl);
      return tagEl;
    }
  }, {
    key: 'createTags',
    value: function createTags(matchingTags, query) {
      var _this2 = this;

      var tagsEl = document.createElement('ol');
      Object.assign(tagsEl.style, {
        display: 'inline',
        marginLeft: '4px',
        flexShrink: 0,
        padding: 0
      });

      var introEl = document.createElement('strong');
      introEl.textContent = 'matching tags: ';

      tagsEl.appendChild(introEl);
      matchingTags.map(function (t) {
        return _this2.createTag(t, query);
      }).forEach(function (tagEl, i) {
        tagsEl.appendChild(tagEl);
        if (i < matchingTags.length - 1) {
          var commaSpace = document.createElement('span');
          commaSpace.textContent = ', ';
          tagsEl.appendChild(commaSpace);
        }
      });
      return tagsEl;
    }
  }, {
    key: 'fuzz',
    get: function get() {
      return this.useAlternateScoring ? _fuzzaldrinPlus2['default'] : _fuzzaldrin2['default'];
    }
  }]);

  return CommandPaletteView;
})();

exports['default'] = CommandPaletteView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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