/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.util.RateStatistics;

public class QueueStatistics {
    private static final int SCALE = 1000;
    private static final int DEFAULT_PRINT_INTERVAL = 500;
    private final RateStatistics addRateStatistics = new RateStatistics(200, 1000.0f);
    private final RateStatistics removeRateStatistics = new RateStatistics(200, 1000.0f);
    private final Logger logger;
    private int head = 0;
    private int size = 0;
    private int[] sizes = new int[500];
    private long[] timestamps = new long[500];
    private long[] addRates = new long[500];
    private long[] removeRates = new long[500];
    private int[] totalPacketsAddedHistory = new int[500];
    private int totalPacketsAdded = 0;
    private String logHeader;

    public QueueStatistics(String id) {
        this.logger = Logger.getLogger("QueueStatistics-" + id);
        this.logHeader = "QueueStatistics-" + id + ": ";
        this.logger.setLevel(Level.ALL);
    }

    public synchronized void add(long now) {
        this.addRateStatistics.update(1, now);
        ++this.size;
        ++this.totalPacketsAdded;
        this.update(now);
    }

    public synchronized void remove(long now) {
        this.removeRateStatistics.update(1, now);
        --this.size;
        this.update(now);
    }

    private synchronized void update(long now) {
        if (this.head == this.sizes.length) {
            this.print();
            this.head = 0;
        }
        this.sizes[this.head] = this.size;
        this.timestamps[this.head] = now;
        this.addRates[this.head] = this.addRateStatistics.getRate(now);
        this.removeRates[this.head] = this.removeRateStatistics.getRate(now);
        this.totalPacketsAddedHistory[this.head] = this.totalPacketsAdded;
        ++this.head;
    }

    private void print() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.sizes.length; ++i) {
            s.append(this.logHeader).append(this.timestamps[i]).append(' ').append(this.sizes[i]).append(' ').append(this.addRates[i]).append(' ').append(this.removeRates[i]).append(' ').append(this.totalPacketsAddedHistory[i]).append('\n');
        }
        this.logger.fine(s.toString());
    }
}

