/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;

public final class HttpUserAgent {
    private static final Logger logger = Logger.getLogger(HttpUserAgent.class);
    public static final String FireFox = "firefox";
    public static final String InternetExplorer = "internet explorer";
    private static final String MSIE = "msie";
    public static final String Chrome = "chrome";
    public static final String Safari = "safari";

    private static String searchForInternetExplorerVersion(String userAgent) {
        return HttpUserAgent.searchVersionInFile(userAgent, "internet-explorer-user-agents.txt");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String searchVersionInFile(String userAgent, String file) {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(Constant.getZapInstall(), "xml", file), StandardCharsets.UTF_8);){
            String browserVersion;
            block19: {
                String line;
                browserVersion = "";
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) {
                        browserVersion = line.substring(2, line.length() - 1);
                        continue;
                    }
                    if (!line.toLowerCase().equals(userAgent)) {
                        continue;
                    }
                    break block19;
                }
                return "-1";
            }
            String string = browserVersion;
            return string;
        }
        catch (IOException e) {
            logger.debug((Object)("Error on opening/reading the file: " + file), (Throwable)e);
        }
        return "-1";
    }

    private static String searchForFirefoxVersion(String userAgent) {
        return HttpUserAgent.searchVersionInFile(userAgent, "firefox-user-agents.txt");
    }

    private static String searchForChromeVersion(String userAgent) {
        return HttpUserAgent.searchVersionInFile(userAgent, "chrome-user-agents.txt");
    }

    private static String searchForSafariVersion(String userAgent) {
        return HttpUserAgent.searchVersionInFile(userAgent, "safari-user-agents.txt");
    }

    public static String getBrowser(String userAgent) {
        if (userAgent.toLowerCase().contains(FireFox)) {
            return FireFox;
        }
        if (userAgent.toLowerCase().contains(MSIE)) {
            return InternetExplorer;
        }
        if (userAgent.toLowerCase().contains(Chrome) || userAgent.toLowerCase().contains(Chrome) && userAgent.toLowerCase().contains(Safari)) {
            return Chrome;
        }
        if (userAgent.toLowerCase().contains(Safari)) {
            return Safari;
        }
        return "-1";
    }

    public static String getBrowserVersion(String userAgent) {
        if (userAgent.toLowerCase().contains(FireFox)) {
            return HttpUserAgent.searchForFirefoxVersion(userAgent);
        }
        if (userAgent.toLowerCase().contains(MSIE)) {
            return HttpUserAgent.searchForInternetExplorerVersion(userAgent);
        }
        if (userAgent.toLowerCase().contains(Chrome) || userAgent.toLowerCase().contains(Chrome) && userAgent.toLowerCase().contains(Safari)) {
            return HttpUserAgent.searchForChromeVersion(userAgent);
        }
        if (userAgent.toLowerCase().contains(Safari)) {
            return HttpUserAgent.searchForSafariVersion(userAgent);
        }
        return "-1";
    }
}

