/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.input.PdfFileSource;

public class PdfFileSourceAdapter {
    public static final String PASSWORD_SEPARATOR_CHARACTER = ":";
    private static final String PDF_EXTENSION = ".pdf";
    private static final String PDF_EXTENSION_AND_PASSWORD_SEPARATOR = ".pdf:";
    private final PdfFileSource pdfFileSource;

    public PdfFileSourceAdapter(String filePathAndPassword) {
        File file = new File(PdfFileSourceAdapter.extractFilePath(filePathAndPassword));
        String password = PdfFileSourceAdapter.extractPassword(filePathAndPassword);
        if (!file.exists()) {
            throw new ConversionException("File '" + file.getPath() + "' does not exist");
        }
        this.pdfFileSource = StringUtils.isBlank((CharSequence)password) ? PdfFileSource.newInstanceNoPassword((File)file) : PdfFileSource.newInstanceWithPassword((File)file, (String)password);
    }

    public PdfFileSource getPdfFileSource() {
        return this.pdfFileSource;
    }

    static String extractFilePath(String filePathAndPassword) {
        if (!StringUtils.containsIgnoreCase((CharSequence)filePathAndPassword, (CharSequence)PDF_EXTENSION_AND_PASSWORD_SEPARATOR)) {
            return filePathAndPassword;
        }
        return filePathAndPassword.substring(0, StringUtils.indexOfIgnoreCase((CharSequence)filePathAndPassword, (CharSequence)PDF_EXTENSION_AND_PASSWORD_SEPARATOR) + PDF_EXTENSION.length());
    }

    static String extractPassword(String filePathAndPassword) {
        if (!StringUtils.containsIgnoreCase((CharSequence)filePathAndPassword, (CharSequence)PDF_EXTENSION_AND_PASSWORD_SEPARATOR)) {
            return "";
        }
        return filePathAndPassword.substring(StringUtils.indexOfIgnoreCase((CharSequence)filePathAndPassword, (CharSequence)PDF_EXTENSION_AND_PASSWORD_SEPARATOR) + 1 + PDF_EXTENSION.length());
    }

    static List<PdfFileSource> fromStrings(List<String> filenames) {
        ArrayList<PdfFileSource> result = new ArrayList<PdfFileSource>();
        for (String filename : filenames) {
            result.add(new PdfFileSourceAdapter(StringUtils.trim((String)filename)).getPdfFileSource());
        }
        return result;
    }
}

