'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registries = exports.RenderFunctionsRegistry = exports.initializeInterpreter = undefined;

var _interpreter = require('./interpreter');

Object.defineProperty(exports, 'initializeInterpreter', {
  enumerable: true,
  get: function get() {
    return _interpreter.initializeInterpreter;
  }
});

var _render_functions_registry = require('./render_functions_registry');

Object.defineProperty(exports, 'RenderFunctionsRegistry', {
  enumerable: true,
  get: function get() {
    return _render_functions_registry.RenderFunctionsRegistry;
  }
});

var _registries = require('./registries');

Object.defineProperty(exports, 'registries', {
  enumerable: true,
  get: function get() {
    return _registries.registries;
  }
});

var _common = require('../common');

// Expose kbnInterpreter.register(specs) and kbnInterpreter.registries() globally so that plugins
// can register without a transpile step.
global.kbnInterpreter = Object.assign(global.kbnInterpreter || {}, (0, _common.registryFactory)(_registries.registries));