/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.modelset.Atom;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Node;

public class JmolMolecule {
    public Node[] nodes;
    public int moleculeIndex;
    public int modelIndex;
    public int indexInModel;
    public int firstAtomIndex;
    public int ac;
    public int nElements;
    public int[] elementCounts = new int[Elements.elementNumberMax];
    public int[] altElementCounts = new int[Elements.altElementMax];
    public int elementNumberMax;
    public int altElementMax;
    public String mf;
    public BS atomList;

    public static final JmolMolecule[] getMolecules(Node[] nodeArray, BS[] bSArray, Lst<BS> lst, BS bS) {
        BS bS2 = null;
        BS bS3 = new BS();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        JmolMolecule[] jmolMoleculeArray = new JmolMolecule[4];
        if (bS == null) {
            bS = new BS();
        }
        int n4 = 0;
        while (n4 < nodeArray.length) {
            if (!bS.get(n4) && !bS3.get(n4)) {
                if (nodeArray[n4].isDeleted()) {
                    bS.set(n4);
                } else {
                    int n5 = nodeArray[n4].getModelIndex();
                    if (n5 != n) {
                        n = n5;
                        n2 = 0;
                        bS2 = bSArray[n5];
                    }
                    if ((bS3 = JmolMolecule.getBranchBitSet(nodeArray, n4, bS2, lst, -1, true, true)).nextSetBit(0) >= 0) {
                        jmolMoleculeArray = JmolMolecule.addMolecule(jmolMoleculeArray, n3++, nodeArray, n4, bS3, n5, n2++, bS);
                    }
                }
            }
            ++n4;
        }
        return JmolMolecule.allocateArray(jmolMoleculeArray, n3);
    }

    public static BS getBranchBitSet(Node[] nodeArray, int n, BS bS, Lst<BS> lst, int n2, boolean bl, boolean bl2) {
        BS bS2 = BS.newN(nodeArray.length);
        if (n < 0) {
            return bS2;
        }
        if (n2 >= 0) {
            bS.clear(n2);
        }
        return JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, nodeArray[n], bS, bl, bl2, lst, bS2) ? bS2 : new BS();
    }

    public static final JmolMolecule[] addMolecule(JmolMolecule[] jmolMoleculeArray, int n, Node[] nodeArray, int n2, BS bS, int n3, int n4, BS bS2) {
        bS2.or(bS);
        if (n == jmolMoleculeArray.length) {
            jmolMoleculeArray = JmolMolecule.allocateArray(jmolMoleculeArray, n * 2 + 1);
        }
        jmolMoleculeArray[n] = JmolMolecule.initialize(nodeArray, n, n2, bS, n3, n4);
        return jmolMoleculeArray;
    }

    public static String getMolecularFormulaAtoms(Node[] nodeArray, BS bS, float[] fArray, boolean bl) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = nodeArray;
        jmolMolecule.atomList = bS;
        return jmolMolecule.getMolecularFormula(false, fArray, bl);
    }

    public String getMolecularFormula(boolean bl, float[] fArray, boolean bl2) {
        int n;
        int n2;
        if (this.mf != null) {
            return this.mf;
        }
        if (this.atomList == null) {
            this.atomList = new BS();
            this.atomList.setBits(0, this.nodes.length);
        }
        this.elementCounts = new int[Elements.elementNumberMax];
        this.altElementCounts = new int[Elements.altElementMax];
        this.ac = this.atomList.cardinality();
        this.nElements = 0;
        int n3 = 0;
        int n4 = this.atomList.nextSetBit(0);
        while (n4 >= 0) {
            Node node = this.nodes[n4];
            if (node != null) {
                n2 = node.getAtomicAndIsotopeNumber();
                int n5 = n = fArray == null ? 1 : (int)(8.0f * fArray[n3]);
                if (n2 < Elements.elementNumberMax) {
                    int n6;
                    if (this.elementCounts[n2] == 0) {
                        ++this.nElements;
                    }
                    int n7 = n2;
                    this.elementCounts[n7] = this.elementCounts[n7] + n;
                    this.elementNumberMax = Math.max(this.elementNumberMax, n2);
                    if (bl && (n6 = node.getImplicitHydrogenCount()) > 0) {
                        if (this.elementCounts[1] == 0) {
                            ++this.nElements;
                        }
                        this.elementCounts[1] = this.elementCounts[1] + n6 * n;
                    }
                } else {
                    if (this.altElementCounts[n2 = Elements.altElementIndexFromNumber(n2)] == 0) {
                        ++this.nElements;
                    }
                    int n8 = n2;
                    this.altElementCounts[n8] = this.altElementCounts[n8] + n;
                    this.altElementMax = Math.max(this.altElementMax, n2);
                }
            }
            n4 = this.atomList.nextSetBit(n4 + 1);
            ++n3;
        }
        if (fArray != null) {
            n3 = 1;
            while (n3 <= this.elementNumberMax) {
                n4 = this.elementCounts[n3] / 8;
                if (n4 * 8 != this.elementCounts[n3]) {
                    return "?";
                }
                this.elementCounts[n3] = n4;
                ++n3;
            }
        }
        if (bl2) {
            n3 = 2;
            n4 = 1;
            block2: while (n4 != 0) {
                n3 = 100000;
                n2 = 1;
                while (n2 <= this.elementNumberMax) {
                    int n9 = this.elementCounts[n2];
                    if (n9 > 0 && n9 < n3) {
                        n3 = n9;
                    }
                    ++n2;
                }
                if (n3 == 1) break;
                n2 = n3;
                while (n2 > 1) {
                    n4 = 1;
                    n = 1;
                    while (n <= this.elementNumberMax && n4 != 0) {
                        int n10 = this.elementCounts[n];
                        if (n10 / n2 * n2 != n10) {
                            n4 = 0;
                        }
                        ++n;
                    }
                    if (n4 != 0) {
                        n = 1;
                        while (n <= this.elementNumberMax) {
                            int n11 = n++;
                            this.elementCounts[n11] = this.elementCounts[n11] / n2;
                        }
                        continue block2;
                    }
                    --n2;
                }
            }
        }
        String string = "";
        String string2 = "";
        n2 = 1;
        while (n2 <= this.elementNumberMax) {
            int n12 = this.elementCounts[n2];
            if (n12 != 0) {
                string = String.valueOf(string) + string2 + Elements.elementSymbolFromNumber(n2) + " " + n12;
                string2 = " ";
            }
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.altElementMax) {
            int n13 = this.altElementCounts[n2];
            if (n13 != 0) {
                string = String.valueOf(string) + string2 + Elements.elementSymbolFromNumber(Elements.altElementNumberFromIndex(n2)) + " " + n13;
                string2 = " ";
            }
            ++n2;
        }
        return string;
    }

    private static JmolMolecule initialize(Node[] nodeArray, int n, int n2, BS bS, int n3, int n4) {
        JmolMolecule jmolMolecule = new JmolMolecule();
        jmolMolecule.nodes = nodeArray;
        jmolMolecule.firstAtomIndex = n2;
        jmolMolecule.atomList = bS;
        jmolMolecule.ac = bS.cardinality();
        jmolMolecule.moleculeIndex = n;
        jmolMolecule.modelIndex = n3;
        jmolMolecule.indexInModel = n4;
        return jmolMolecule;
    }

    private static boolean getCovalentlyConnectedBitSet(Node[] nodeArray, Node node, BS bS, boolean bl, boolean bl2, Lst<BS> lst, BS bS2) {
        int n = node.getIndex();
        if (!bS.get(n)) {
            return bl;
        }
        if (!bl2 && node.getBioStructureTypeName().length() > 0) {
            return bl;
        }
        bS.clear(n);
        if (lst != null && !bS2.get(n)) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                BS bS3 = (BS)lst.get(n2);
                if (!bS3.get(n)) continue;
                bS2.or(bS3);
                bS.andNot(bS3);
                int n3 = bS3.nextSetBit(0);
                while (n3 >= 0) {
                    Node node2 = nodeArray[n3];
                    bS.set(n3);
                    JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, node2, bS, bl, bl2, lst, bS2);
                    bS.clear(n3);
                    n3 = bS3.nextSetBit(n3 + 1);
                }
                break block0;
            }
        }
        bS2.set(n);
        Edge[] edgeArray = node.getEdges();
        if (edgeArray == null) {
            return true;
        }
        int n4 = edgeArray.length;
        while (--n4 >= 0) {
            Edge edge = edgeArray[n4];
            if (edge == null || !edge.isCovalent() || JmolMolecule.getCovalentlyConnectedBitSet(nodeArray, (Node)edge.getOtherNode(node), bS, bl, bl2, lst, bS2)) continue;
            return false;
        }
        return true;
    }

    private static JmolMolecule[] allocateArray(JmolMolecule[] jmolMoleculeArray, int n) {
        return n == jmolMoleculeArray.length ? jmolMoleculeArray : (JmolMolecule[])AU.arrayCopyObject(jmolMoleculeArray, n);
    }

    public static BS getBitSetForMF(Atom[] atomArray, BS bS, String string) {
        Hashtable<String, int[]> hashtable = new Hashtable<String, int[]>();
        string = PT.rep(PT.clean(String.valueOf(string) + "Z"), " ", "");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n < n4) {
            char c = string.charAt(n);
            boolean bl = Character.isDigit(c);
            if (bl || n > 0 && Character.isUpperCase(c)) {
                n3 = n;
                String string2 = string.substring(n2, n3).trim();
                if (bl) {
                    while (n < n4 && Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                }
                n2 = n;
                hashtable.put(string2, new int[]{bl ? PT.parseInt(string.substring(n3, n2)) : 1});
            }
            ++n;
        }
        BS bS2 = new BS();
        n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            String string3 = atomArray[n2].getElementSymbol();
            int[] nArray = (int[])hashtable.get(string3);
            if (nArray != null) {
                int n5 = nArray[0];
                nArray[0] = n5 - 1;
                if (n5 >= 1) {
                    bS2.set(n2);
                }
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        for (int[] nArray : hashtable.values()) {
            if (nArray[0] <= 0) continue;
            return new BS();
        }
        return bS2;
    }
}

