/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.utils.componentproviders;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import org.gephi.desktop.datalab.utils.GraphModelProvider;
import org.gephi.utils.sparklines.SparklineGraph;
import org.gephi.utils.sparklines.SparklineParameters;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.JRendererLabel;

public abstract class AbstractSparklinesGraphicsComponentProvider
extends ComponentProvider<JLabel> {
    protected static final Color SELECTED_BACKGROUND = new Color(225, 255, 255);
    protected static final Color UNSELECTED_BACKGROUND = Color.white;
    protected final GraphModelProvider graphModelProvider;
    protected final JXTable table;
    protected JRendererLabel rendererLabel;

    public AbstractSparklinesGraphicsComponentProvider(GraphModelProvider graphModelProvider, JXTable table) {
        super(null, 10);
        this.graphModelProvider = graphModelProvider;
        this.table = table;
    }

    public abstract String getTextFromValue(Object var1);

    protected void format(CellContext context) {
        int witdth = this.table.getColumnModel().getColumn(context.getColumn()).getWidth();
        int height = this.table.getRowHeight(context.getRow());
        String text = this.getTextFromValue(context.getValue());
        this.rendererLabel.setSize(witdth, height);
        this.rendererLabel.setToolTipText(text);
        this.rendererLabel.setBorder(null);
        this.setImagePainter(context.getValue(), context.isSelected());
    }

    protected void configureState(CellContext context) {
    }

    protected JLabel createRendererComponent() {
        this.rendererLabel = new JRendererLabel();
        return this.rendererLabel;
    }

    public void setImagePainter(Object value, boolean isSelected) {
        if (value == null) {
            this.rendererLabel.setPainter(null);
            return;
        }
        Number[][] values = this.getSparklinesXAndYNumbers(value);
        Number[] xValues = values[0];
        Number[] yValues = values[1];
        if (yValues.length < 1) {
            this.rendererLabel.setPainter(null);
            return;
        }
        if (yValues.length == 1) {
            xValues = null;
            yValues = new Number[]{yValues[0], yValues[0]};
        }
        Color background = isSelected ? SELECTED_BACKGROUND : UNSELECTED_BACKGROUND;
        SparklineParameters sparklineParameters = new SparklineParameters(this.rendererLabel.getWidth() - 1, this.rendererLabel.getHeight() - 1, Color.BLUE, background, Color.RED, Color.GREEN, null);
        BufferedImage image = SparklineGraph.draw((Number[])xValues, (Number[])yValues, (SparklineParameters)sparklineParameters);
        this.rendererLabel.setPainter((Painter)new ImagePainter(image));
    }

    public abstract Number[][] getSparklinesXAndYNumbers(Object var1);
}

