/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.fruchterman;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FruchtermanReingold
extends AbstractLayout
implements Layout {
    private static final float SPEED_DIVISOR = 800.0f;
    private static final float AREA_MULTIPLICATOR = 10000.0f;
    protected Graph graph;
    private float area;
    private double gravity;
    private double speed;

    public FruchtermanReingold(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    public void resetPropertiesValues() {
        this.speed = 1.0;
        this.area = 10000.0f;
        this.gravity = 10.0;
    }

    public void initAlgo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            ForceVectorNodeLayoutData layoutData;
            Node[] nodes = this.graph.getNodes().toArray();
            Edge[] edges = this.graph.getEdges().toArray();
            for (Node n : nodes) {
                if (n.getLayoutData() == null || !(n.getLayoutData() instanceof ForceVectorNodeLayoutData)) {
                    n.setLayoutData((LayoutData)new ForceVectorNodeLayoutData());
                }
                ForceVectorNodeLayoutData layoutData2 = (ForceVectorNodeLayoutData)n.getLayoutData();
                layoutData2.dx = 0.0f;
                layoutData2.dy = 0.0f;
            }
            float maxDisplace = (float)(Math.sqrt(10000.0f * this.area) / 10.0);
            float k = (float)Math.sqrt(10000.0f * this.area / (1.0f + (float)nodes.length));
            for (Node node : nodes) {
                for (Node N2 : nodes) {
                    float yDist;
                    float xDist;
                    float dist;
                    if (node == N2 || !((dist = (float)Math.sqrt((xDist = node.x() - N2.x()) * xDist + (yDist = node.y() - N2.y()) * yDist)) > 0.0f)) continue;
                    float repulsiveF = k * k / dist;
                    ForceVectorNodeLayoutData layoutData3 = (ForceVectorNodeLayoutData)node.getLayoutData();
                    layoutData3.dx += xDist / dist * repulsiveF;
                    layoutData3.dy += yDist / dist * repulsiveF;
                }
            }
            for (Node node : edges) {
                Node Nf = node.getSource();
                Node Nt = node.getTarget();
                float xDist = Nf.x() - Nt.x();
                float yDist = Nf.y() - Nt.y();
                float dist = (float)Math.sqrt(xDist * xDist + yDist * yDist);
                float attractiveF = dist * dist / k;
                if (!(dist > 0.0f)) continue;
                ForceVectorNodeLayoutData sourceLayoutData = (ForceVectorNodeLayoutData)Nf.getLayoutData();
                ForceVectorNodeLayoutData targetLayoutData = (ForceVectorNodeLayoutData)Nt.getLayoutData();
                sourceLayoutData.dx -= xDist / dist * attractiveF;
                sourceLayoutData.dy -= yDist / dist * attractiveF;
                targetLayoutData.dx += xDist / dist * attractiveF;
                targetLayoutData.dy += yDist / dist * attractiveF;
            }
            for (Node node : nodes) {
                layoutData = (ForceVectorNodeLayoutData)node.getLayoutData();
                float d = (float)Math.sqrt(node.x() * node.x() + node.y() * node.y());
                float gf = 0.01f * k * (float)this.gravity * d;
                layoutData.dx -= gf * node.x() / d;
                layoutData.dy -= gf * node.y() / d;
            }
            for (Node node : nodes) {
                layoutData = (ForceVectorNodeLayoutData)node.getLayoutData();
                layoutData.dx = (float)((double)layoutData.dx * (this.speed / 800.0));
                layoutData.dy = (float)((double)layoutData.dy * (this.speed / 800.0));
            }
            for (Node node : nodes) {
                layoutData = (ForceVectorNodeLayoutData)node.getLayoutData();
                float xDist = layoutData.dx;
                float yDist = layoutData.dy;
                float dist = (float)Math.sqrt(layoutData.dx * layoutData.dx + layoutData.dy * layoutData.dy);
                if (!(dist > 0.0f) || node.isFixed()) continue;
                float limitedDist = Math.min(maxDisplace * ((float)this.speed / 800.0f), dist);
                node.setX(node.x() + xDist / dist * limitedDist);
                node.setY(node.y() + yDist / dist * limitedDist);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public boolean canAlgo() {
        return true;
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FRUCHTERMAN_REINGOLD = "Fruchterman Reingold";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, (String)NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.area.name"), (String)"Fruchterman Reingold", (String)"fruchtermanReingold.area.name", (String)NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.area.desc"), (String)"getArea", (String)"setArea"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.gravity.name"), (String)"Fruchterman Reingold", (String)"fruchtermanReingold.gravity.name", (String)NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.gravity.desc"), (String)"getGravity", (String)"setGravity"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.speed.name"), (String)"Fruchterman Reingold", (String)"fruchtermanReingold.speed.name", (String)NbBundle.getMessage(FruchtermanReingold.class, (String)"fruchtermanReingold.speed.desc"), (String)"getSpeed", (String)"setSpeed"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getArea() {
        return Float.valueOf(this.area);
    }

    public void setArea(Float area) {
        this.area = area.floatValue();
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }
}

