define(["dom","layoutManager","browser","css!./headroom"],function(dom,layoutManager,browser){"use strict";function onHeadroomClearedExternally(){this.transform=null}function onHeadroomForceClearedExternally(){this.transform=null,this.setTransform(0)}function Headroom(elems,options){options=options||{},this.lastKnownScrollY=0,this.elems=elems,this.scroller=options.scroller||window,this.debouncer=this.update.bind(this),this.offset=options.offset,this.initialised=!1}var toleranceLevel=(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame,browser.iOS?14:4);return Headroom.prototype={constructor:Headroom,init:function(){if(this.onHeadroomClearedExternallyFn=onHeadroomClearedExternally.bind(this),this.onHeadroomForceClearedExternallyFn=onHeadroomForceClearedExternally.bind(this),browser.supportsCssAnimation()){for(var i=0,length=this.elems.length;i<length;i++){var elem=this.elems[i];this.initElem(elem)}this.attachEvent()}return this},add:function(elem){browser.supportsCssAnimation()&&(this.initElem(elem),this.elems.push(elem))},initElem:function(elem){elem.classList.add("headroom");var onHeadroomClearedExternallyFn=this.onHeadroomClearedExternallyFn,onHeadroomForceClearedExternallyFn=this.onHeadroomForceClearedExternallyFn;elem.addEventListener("clearheadroom",onHeadroomClearedExternallyFn),elem.addEventListener("forceclearheadroom",onHeadroomForceClearedExternallyFn)},remove:function(elem){elem.classList.remove("headroom");var onHeadroomClearedExternallyFn=this.onHeadroomClearedExternallyFn,onHeadroomForceClearedExternallyFn=this.onHeadroomForceClearedExternallyFn;elem.removeEventListener("clearheadroom",onHeadroomClearedExternallyFn),elem.removeEventListener("forceclearheadroom",onHeadroomForceClearedExternallyFn);var i=this.elems.indexOf(elem);-1!==i&&this.elems.splice(i,1)},pause:function(){this.paused=!0},resume:function(){this.paused=!1},destroy:function(){this.initialised=!1;for(var i=0,length=this.elems.length;i<length;i++){this.elems[i].classList.remove("headroom")}var scrollEventName=this.scroller.getScrollEventName?this.scroller.getScrollEventName():"scroll";dom.removeEventListener(this.scroller,scrollEventName,this.debouncer,{capture:!1,passive:!0})},attachEvent:function(){if(!this.initialised){this.lastKnownScrollY=this.getScrollY(),this.initialised=!0;var scrollEventName=this.scroller.getScrollEventName?this.scroller.getScrollEventName():"scroll";dom.addEventListener(this.scroller,scrollEventName,this.debouncer,{capture:!1,passive:!0}),this.update()}},setTransform:function(value,currentScrollY){if(value!==this.transform){this.transform=value,value=0===value?"none":1===value?"translateY(-100%)":"translateY(-"+value+"px)";for(var elems=this.elems,i=0,length=elems.length;i<length;i++){elems[i].style.transform=value}}},getScrollY:function(){var scroller=this.scroller;if(scroller.getScrollPosition)return scroller.getScrollPosition();var pageYOffset=scroller.pageYOffset;if(void 0!==pageYOffset)return pageYOffset;var scrollTop=scroller.scrollTop;return void 0!==scrollTop?scrollTop:(document.documentElement||document.body).scrollTop},shouldUnpin:function(currentScrollY){var scrollingDown=currentScrollY>this.lastKnownScrollY,pastOffset=currentScrollY>=this.offset;return scrollingDown&&pastOffset},update:function(){if(!this.paused){var currentScrollY=this.getScrollY();if(currentScrollY<0)return void(this.ticking=!1);var lastKnownScrollY=this.lastKnownScrollY,isTv=layoutManager.tv,max=isTv?130:90;if(currentScrollY<=(isTv?max:0))this.setTransform(0,currentScrollY);else if(!isTv&&currentScrollY<lastKnownScrollY){var toleranceExceeded=Math.abs(currentScrollY-lastKnownScrollY)>=toleranceLevel;toleranceExceeded&&this.setTransform(0,currentScrollY)}else{var transformValue=currentScrollY;transformValue<=0?transformValue=0:transformValue>=max&&(transformValue=1),this.setTransform(transformValue,currentScrollY)}this.lastKnownScrollY=currentScrollY,this.ticking=!1}}},Headroom});