/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.ui.DefaultDescriptorLabelProvider;
import org.eclipse.launchbar.ui.ILaunchBarUIManager;
import org.eclipse.launchbar.ui.NewLaunchConfigWizard;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.launchbar.ui.controls.internal.CSelector;
import org.eclipse.launchbar.ui.controls.internal.LaunchBarListViewer;
import org.eclipse.launchbar.ui.controls.internal.Messages;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ConfigSelector
extends CSelector {
    private ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);
    private ILaunchBarUIManager uiManager = Activator.getService(ILaunchBarUIManager.class);
    private DefaultDescriptorLabelProvider defaultProvider;
    private static final String[] noConfigs = new String[]{Messages.ConfigSelector_0};

    public ConfigSelector(Composite parent, int style) {
        super(parent, style);
        this.setData("org.eclipse.swtbot.widget.key", "org.eclipse.launchbar.selector.config");
        this.setToolTipText(Messages.ConfigSelector_1);
        this.defaultProvider = new DefaultDescriptorLabelProvider();
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                try {
                    Object[] descs = ConfigSelector.this.manager.getLaunchDescriptors();
                    if (descs.length == 0) {
                        return noConfigs;
                    }
                    return descs;
                }
                catch (CoreException e) {
                    return noConfigs;
                }
            }
        });
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ILaunchDescriptor) {
                    try {
                        Image img;
                        ILaunchDescriptor configDesc = (ILaunchDescriptor)element;
                        ILabelProvider labelProvider = ConfigSelector.this.uiManager.getLabelProvider(configDesc);
                        if (labelProvider != null && (img = labelProvider.getImage(element)) != null) {
                            return img;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                }
                return ConfigSelector.this.defaultProvider.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof ILaunchDescriptor) {
                    try {
                        String text;
                        ILaunchDescriptor configDesc = (ILaunchDescriptor)element;
                        ILabelProvider labelProvider = ConfigSelector.this.uiManager.getLabelProvider(configDesc);
                        if (labelProvider != null && (text = labelProvider.getText(element)) != null) {
                            return text;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                }
                return ConfigSelector.this.defaultProvider.getText(element);
            }
        });
        this.setHistorySortComparator(null);
        this.setSorter((o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    @Override
    protected void initializeListViewer(LaunchBarListViewer listViewer) {
        listViewer.setHistorySupported(true);
        listViewer.setHistoryPreferenceName("launchHistorySize");
        super.initializeListViewer(listViewer);
    }

    @Override
    protected void fireSelectionChanged() {
        Object selected = this.getSelection();
        if (selected instanceof ILaunchDescriptor) {
            ILaunchDescriptor configDesc = (ILaunchDescriptor)selected;
            try {
                this.manager.setActiveLaunchDescriptor(configDesc);
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public boolean isEditable(Object element) {
        return element instanceof ILaunchDescriptor;
    }

    @Override
    public void handleEdit(Object element) {
        this.uiManager.openConfigurationEditor((ILaunchDescriptor)element);
    }

    @Override
    public boolean hasActionArea() {
        return true;
    }

    @Override
    public void createActionArea(Composite parent) {
        final Composite createButton = new Composite(parent, 2048);
        createButton.setData("org.eclipse.swtbot.widget.key", (Object)"org.eclipse.launchbar.new");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)createButton);
        GridLayoutFactory.fillDefaults().margins(7, 7).applyTo(createButton);
        createButton.setBackground(this.getBackground());
        final Label createLabel = new Label(createButton, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)createLabel);
        createLabel.setBackground(this.getBackground());
        createLabel.setText(Messages.ConfigSelector_2);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                final NewLaunchConfigWizard wizard = new NewLaunchConfigWizard();
                WizardDialog dialog = new WizardDialog(ConfigSelector.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    new Job(Messages.ConfigSelector_3){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                wizard.getWorkingCopy().doSave();
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                        }
                    }.schedule();
                }
            }
        };
        createButton.addMouseListener((MouseListener)mouseListener);
        createLabel.addMouseListener((MouseListener)mouseListener);
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                Color highlightColor = ConfigSelector.this.getHighlightColor();
                createButton.setBackground(highlightColor);
                createLabel.setBackground(highlightColor);
            }

            public void mouseExit(MouseEvent e) {
                Color backgroundColor = ConfigSelector.this.getBackground();
                createButton.setBackground(backgroundColor);
                createLabel.setBackground(backgroundColor);
            }
        };
        createButton.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        createLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(250, hHint, changed);
    }

    @Override
    public void setSelection(Object element) {
        if (element == null) {
            element = noConfigs[0];
        }
        super.setSelection(element);
    }
}

