/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;

public class TypeInstantiationRequest {
    private final IType type;
    private final ICPPTemplateParameterMap parameterMap;
    private final int packOffset;
    private final ICPPTypeSpecialization contextTypeSpecialization;
    private int hashCode;

    public TypeInstantiationRequest(IType type, InstantiationContext context) {
        this.type = type;
        this.parameterMap = context.getParameterMap();
        this.packOffset = context.getPackOffset();
        this.contextTypeSpecialization = context.getContextTypeSpecialization();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            SignatureBuilder builder = new SignatureBuilder();
            try {
                builder.marshalType(this.type);
                char[] signature = builder.getSignature();
                this.hashCode = CharArrayUtils.hash(signature);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.hashCode = Integer.MIN_VALUE;
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TypeInstantiationRequest other = (TypeInstantiationRequest)obj;
        if (!this.type.isSameType(other.type)) {
            return false;
        }
        if (!this.equals(this.contextTypeSpecialization, other.contextTypeSpecialization)) {
            return false;
        }
        if (!this.equals(this.parameterMap, other.parameterMap)) {
            return false;
        }
        return this.packOffset == other.packOffset;
    }

    private boolean equals(IType type1, IType type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return type1.isSameType(type1);
    }

    private boolean equals(ICPPTemplateParameterMap map1, ICPPTemplateParameterMap map2) {
        Object[] p2;
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        Object[] p1 = map1.getAllParameterPositions();
        if (!Arrays.equals(p1, p2 = map2.getAllParameterPositions())) {
            return false;
        }
        Object[] objectArray = p1;
        int n = p1.length;
        int n2 = 0;
        while (n2 < n) {
            Object paramId = objectArray[n2];
            ICPPTemplateArgument[] packExpansion1 = map1.getPackExpansion((Integer)paramId);
            ICPPTemplateArgument[] packExpansion2 = map2.getPackExpansion((Integer)paramId);
            if (packExpansion1 != null && packExpansion2 != null) {
                if (packExpansion1.length != packExpansion2.length) {
                    return false;
                }
                int i = 0;
                while (i < packExpansion1.length) {
                    if (!this.equals(packExpansion1[i], packExpansion2[i])) {
                        return false;
                    }
                    ++i;
                }
            } else if (packExpansion1 == null && packExpansion2 == null) {
                ICPPTemplateArgument arg2;
                ICPPTemplateArgument arg1 = map1.getArgument((Integer)paramId);
                if (!this.equals(arg1, arg2 = map2.getArgument((Integer)paramId))) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean equals(ICPPTemplateArgument arg1, ICPPTemplateArgument arg2) {
        if (arg1 == arg2) {
            return true;
        }
        if (arg1 == null || arg2 == null) {
            return false;
        }
        return arg1.isSameValue(arg2);
    }
}

