/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorRegistry;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;

public class ConnectionPageNetwork
extends ConnectionWizardPage {
    public static final String PAGE_NAME = ConnectionPageNetwork.class.getSimpleName();
    private static final Log log = Log.getLog(ConnectionPageNetwork.class);
    private TabFolder handlersFolder;
    private DataSourceDescriptor prevDataSource;
    private final ConnectionWizard wizard;
    private Map<NetworkHandlerDescriptor, HandlerBlock> configurations = new HashMap<NetworkHandlerDescriptor, HandlerBlock>();

    ConnectionPageNetwork(ConnectionWizard wizard) {
        super(PAGE_NAME);
        this.wizard = wizard;
        this.setTitle(CoreMessages.dialog_connection_network_title);
        this.setDescription(CoreMessages.dialog_tunnel_title);
    }

    public void createControl(Composite parent) {
        this.handlersFolder = new TabFolder(parent, 0x800080);
        this.handlersFolder.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)this.handlersFolder);
    }

    private void createHandlerTab(final NetworkHandlerDescriptor descriptor) throws DBException {
        IObjectPropertyConfigurator<DBWHandlerConfiguration> configurator;
        try {
            String implName = descriptor.getHandlerType().getImplName();
            UIPropertyConfiguratorDescriptor configDescriptor = UIPropertyConfiguratorRegistry.getInstance().getDescriptor(implName);
            if (configDescriptor == null) {
                return;
            }
            configurator = configDescriptor.createConfigurator();
        }
        catch (DBException e) {
            log.error((Object)("Can't create network configurator '" + descriptor.getId() + "'"), (Throwable)e);
            return;
        }
        TabItem tabItem = new TabItem(this.handlersFolder, 0);
        tabItem.setText(descriptor.getLabel());
        tabItem.setToolTipText(descriptor.getDescription());
        Composite composite = new Composite((Composite)this.handlersFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        final Button useHandlerCheck = UIUtils.createCheckbox((Composite)composite, (String)NLS.bind((String)CoreMessages.dialog_tunnel_checkbox_use_handler, (Object)descriptor.getLabel()), (boolean)false);
        useHandlerCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandlerBlock handlerBlock = (HandlerBlock)ConnectionPageNetwork.this.configurations.get(descriptor);
                DBWHandlerConfiguration handlerConfiguration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(ConnectionPageNetwork.this.wizard.getPageSettings().getActiveDataSource().getId());
                handlerConfiguration.setEnabled(useHandlerCheck.getSelection());
                ConnectionPageNetwork.this.enableHandlerContent(descriptor);
            }
        });
        Composite handlerComposite = UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.configurations.put(descriptor, new HandlerBlock(configurator, handlerComposite, useHandlerCheck, tabItem));
        handlerComposite.setLayoutData((Object)new GridData(1808));
        configurator.createControl(handlerComposite);
    }

    public void activatePage() {
        DataSourceDescriptor dataSource = this.wizard.getPageSettings().getActiveDataSource();
        DBPDriver driver = this.wizard.getSelectedDriver();
        NetworkHandlerRegistry registry = NetworkHandlerRegistry.getInstance();
        if (this.prevDataSource == null || this.prevDataSource != dataSource) {
            TabItem[] tabItemArray = this.handlersFolder.getItems();
            int n = tabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TabItem item = tabItemArray[n2];
                item.dispose();
                ++n2;
            }
            for (NetworkHandlerDescriptor descriptor : registry.getDescriptors((DBPDataSourceContainer)dataSource)) {
                try {
                    this.createHandlerTab(descriptor);
                }
                catch (DBException e) {
                    log.warn((Object)e);
                }
            }
            this.prevDataSource = dataSource;
            this.handlersFolder.layout(true, true);
        }
        TabItem selectItem = null;
        for (NetworkHandlerDescriptor descriptor : registry.getDescriptors((DBPDataSourceContainer)dataSource)) {
            HandlerBlock handlerBlock;
            DBWHandlerConfiguration configuration = dataSource.getConnectionConfiguration().getHandler(descriptor.getId());
            if (configuration == null) {
                configuration = new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, driver);
            }
            if ((handlerBlock = this.configurations.get(descriptor)) == null) continue;
            if (selectItem == null && configuration.isEnabled()) {
                selectItem = handlerBlock.tabItem;
            }
            if (!handlerBlock.loadedConfigs.containsKey(dataSource.getId())) {
                handlerBlock.configurator.loadSettings((Object)configuration);
                handlerBlock.loadedConfigs.put(dataSource.getId(), configuration);
            }
            this.enableHandlerContent(descriptor);
        }
        if (selectItem != null) {
            this.handlersFolder.setSelection(selectItem);
        } else {
            this.handlersFolder.setSelection(0);
        }
    }

    protected void enableHandlerContent(NetworkHandlerDescriptor descriptor) {
        HandlerBlock handlerBlock = this.configurations.get(descriptor);
        DBWHandlerConfiguration handlerConfiguration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(this.wizard.getPageSettings().getActiveDataSource().getId());
        handlerBlock.useHandlerCheck.setSelection(handlerConfiguration.isEnabled());
        if (handlerConfiguration.isEnabled()) {
            if (handlerBlock.blockEnableState != null) {
                handlerBlock.blockEnableState.restore();
                handlerBlock.blockEnableState = null;
            }
        } else if (handlerBlock.blockEnableState == null) {
            handlerBlock.blockEnableState = ControlEnableState.disable((Control)handlerBlock.blockControl);
        }
    }

    @Override
    public void saveSettings(DataSourceDescriptor dataSource) {
        boolean foundHandlers = false;
        ArrayList<DBWHandlerConfiguration> handlers = new ArrayList<DBWHandlerConfiguration>();
        for (HandlerBlock handlerBlock : this.configurations.values()) {
            DBWHandlerConfiguration configuration = (DBWHandlerConfiguration)handlerBlock.loadedConfigs.get(dataSource.getId());
            if (configuration == null) continue;
            foundHandlers = true;
            handlerBlock.configurator.saveSettings((Object)configuration);
            handlers.add(configuration);
        }
        if (foundHandlers) {
            dataSource.getConnectionConfiguration().setHandlers(handlers);
        }
    }

    private static class HandlerBlock {
        private final IObjectPropertyConfigurator<DBWHandlerConfiguration> configurator;
        private final Composite blockControl;
        private final Button useHandlerCheck;
        private final TabItem tabItem;
        ControlEnableState blockEnableState;
        private final Map<String, DBWHandlerConfiguration> loadedConfigs = new HashMap<String, DBWHandlerConfiguration>();

        private HandlerBlock(IObjectPropertyConfigurator<DBWHandlerConfiguration> configurator, Composite blockControl, Button useHandlerCheck, TabItem tabItem) {
            this.configurator = configurator;
            this.blockControl = blockControl;
            this.useHandlerCheck = useHandlerCheck;
            this.tabItem = tabItem;
        }
    }
}

