/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.ref;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.equinox.internal.util.UtilActivator;
import org.eclipse.equinox.internal.util.event.Queue;
import org.eclipse.equinox.internal.util.hash.HashIntObjNS;
import org.eclipse.equinox.internal.util.ref.LogInterface;
import org.eclipse.equinox.internal.util.ref.Saver;
import org.eclipse.equinox.internal.util.security.PrivilegedRunner;
import org.eclipse.equinox.internal.util.security.SecurityUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Log
implements LogInterface,
ServiceTrackerCustomizer<LogService, LogService>,
PrivilegedRunner.PrivilegedDispatcher {
    @Deprecated
    public boolean printOnConsole = false;
    public boolean autoPrintOnConsole = false;
    @Deprecated
    public boolean debug = false;
    private boolean logErrorLevel = false;
    private ServiceTracker<LogService, LogService> logTracker;
    protected static final SecurityUtil securityUtil = new SecurityUtil();
    private boolean isClosed = false;
    private long bundleId;
    protected BundleContext bc;
    private static Vector<Log> logs = new Vector();
    private static Log listener;
    private HashIntObjNS map = null;
    private HashIntObjNS starts = null;
    private static final char[] chars;
    private static boolean security;
    String baseName;
    boolean synch;
    FileOutputStream fos = null;
    static String logsdir;
    static Queue queue;
    static boolean running;
    static Saver saver;
    long lastTime;
    private static final byte OPEN_TYPE = 0;
    private static final byte GET_SERVICE_TYPE = 1;
    private static final byte GET_SYS_SERVICES_TYPE = 2;

    static {
        chars = new char[]{']', ' ', ':', ' '};
        security = false;
        logsdir = null;
        running = false;
    }

    public Log(BundleContext bc) {
        this(bc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log(BundleContext bc, boolean initDebug) {
        if (initDebug) {
            this.debug = securityUtil.getBooleanProperty("equinox.util.ref.log.debug");
            this.logErrorLevel = securityUtil.getBooleanProperty("equinox.log.errorlevel");
            this.autoPrintOnConsole = securityUtil.getBooleanProperty("equinox.util.ref.log.autoPrintOnConsole");
            this.printOnConsole = securityUtil.getBooleanProperty("equinox.util.ref.log.printOnConsole");
        }
        if (bc != null) {
            this.bc = bc;
            this.bundleId = bc.getBundle().getBundleId();
            if (UtilActivator.startup && UtilActivator.points != null) {
                UtilActivator.points[0] = System.currentTimeMillis();
            }
            this.initSysServices();
            if (UtilActivator.startup && UtilActivator.points != null) {
                UtilActivator.points[1] = System.currentTimeMillis();
            }
            Vector<Log> vector = logs;
            synchronized (vector) {
                if (listener == null) {
                    this.initListener();
                }
                logs.addElement(this);
            }
            if (UtilActivator.startup && UtilActivator.points != null) {
                UtilActivator.points[2] = System.currentTimeMillis();
            }
        } else {
            this.printOnConsole = true;
        }
    }

    private void initListener() {
        try {
            securityUtil.doPrivileged(this, 0, null);
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initListener0() {
        Vector<Log> vector = logs;
        synchronized (vector) {
            this.initListenerNS();
        }
    }

    void initListenerNS() {
        this.logTracker = new ServiceTracker(this.bc, LogService.class, (ServiceTrackerCustomizer)this);
        this.logTracker.open();
        listener = this;
    }

    @Override
    public void error(String str, Throwable ex) {
        if (this.isClosed) {
            return;
        }
        boolean logResult = this.logMessage(1, str, ex);
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole || this.logErrorLevel) {
            this.dumpOnConsole("ERROR ", str, this.bundleId, ex);
        }
    }

    public void error(int moduleID, int msgID, String msg, Throwable t, boolean synch) {
        if (this.isClosed) {
            return;
        }
        boolean logResult = true;
        if (msg != null || t != null) {
            logResult = this.logMessage(1, msg, t);
        }
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole || this.logErrorLevel) {
            this.dumpOnConsole(this.buildDebugString(moduleID, msgID, msg, "ERROR " + this.bundleId + " "), t);
        }
    }

    @Override
    public void warning(String str, Throwable ex) {
        if (this.isClosed) {
            return;
        }
        boolean logResult = this.logMessage(2, str, ex);
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole || this.logErrorLevel) {
            this.dumpOnConsole("WARNING ", str, this.bundleId, ex);
        }
    }

    public void warning(int moduleID, int msgID, String msg, Throwable t, boolean synch) {
        if (this.isClosed) {
            return;
        }
        boolean logResult = true;
        if (msg != null || t != null) {
            logResult = this.logMessage(2, msg, t);
        }
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole || this.logErrorLevel) {
            this.dumpOnConsole(this.buildDebugString(moduleID, msgID, msg, "WARNING " + this.bundleId + " "), t);
        }
    }

    @Override
    public void info(String str) {
        if (this.isClosed) {
            return;
        }
        boolean logResult = this.logMessage(3, str, null);
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole) {
            this.dumpOnConsole("INFO ", str, this.bundleId, null);
        }
    }

    public void info(int moduleID, int msgID, String msg, boolean synch) {
        if (this.isClosed) {
            return;
        }
        boolean logResult = true;
        if (msg != null) {
            logResult = this.logMessage(3, msg, null);
        }
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole) {
            this.dumpOnConsole(this.buildDebugString(moduleID, msgID, msg, "INFO " + this.bundleId + " "), null);
        }
    }

    @Override
    public void debug(String str, Throwable ex) {
        if (!this.debug || this.isClosed) {
            return;
        }
        boolean logResult = this.logMessage(4, str, ex);
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole) {
            this.dumpOnConsole("DEBUG ", str, this.bundleId, ex);
        }
    }

    public void debug(int moduleID, int msgID, String msg, Throwable t, boolean synch) {
        this.debug(moduleID, msgID, msg, t, synch, false, false, true);
    }

    public void debug(int moduleID, int msgID, String msg, Throwable t, boolean synch, boolean measurement) {
        this.debug(moduleID, msgID, msg, t, synch, measurement, false, true);
    }

    public void debug(int moduleID, int msgID, String msg, Throwable t, boolean synch, boolean measurement, boolean display) {
        this.debug(moduleID, msgID, msg, t, synch, measurement, display, true);
    }

    public void debug(int moduleID, int msgID, String msg, Throwable t, boolean synch, boolean measurement, boolean display, boolean logInFile) {
        boolean logResult;
        if (!this.debug && !measurement || this.isClosed) {
            return;
        }
        String message = msg;
        if (measurement) {
            message = this.buildDebugString(moduleID, msgID, msg, "DEBUG " + this.bundleId + " ");
        }
        boolean bl = logInFile ? true : (logResult = message == null && t == null);
        if (logInFile && (message != null || t != null)) {
            logResult = this.logMessage(4, message, t);
        }
        if (this.printOnConsole || !logResult && this.autoPrintOnConsole) {
            message = this.buildDebugString(moduleID, msgID, msg, "DEBUG " + this.bundleId + " ");
            this.dumpOnConsole(message, t);
        }
    }

    private void initSysServices() {
        if (security) {
            try {
                securityUtil.doPrivileged(this, 2, null);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogService getService0() throws IllegalArgumentException {
        Vector<Log> vector = logs;
        synchronized (vector) {
            ServiceReference logRef = Log.listener.logTracker.getServiceReference();
            LogService ls = null;
            if (logRef != null) {
                ls = (LogService)this.bc.getService(logRef);
            }
            return ls;
        }
    }

    private LogService getService() throws IllegalArgumentException {
        if (this.bc == null) {
            return null;
        }
        try {
            return (LogService)securityUtil.doPrivileged(this, 1, null);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean logMessage(int messageType, String messageText, Throwable t) {
        LogService ls = null;
        try {
            ls = this.getService();
        }
        catch (IllegalStateException illegalStateException) {
            Vector<Log> vector = logs;
            synchronized (vector) {
                this.close0();
            }
            return false;
        }
        boolean result = true;
        if (ls == null) {
            result = false;
            this.testClose();
        } else {
            try {
                ls.log(messageType, messageText, t);
            }
            catch (IllegalStateException illegalStateException) {
                result = false;
                this.testClose();
            }
        }
        return result;
    }

    private void dumpOnConsole(String prefix, String msg, long bundleId, Throwable t) {
        System.out.println(String.valueOf(prefix) + bundleId + " " + msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private void dumpOnConsole(String msg, Throwable t) {
        System.out.println(msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testClose() {
        Vector<Log> vector = logs;
        synchronized (vector) {
            if (listener != null) {
                try {
                    Log.listener.bc.getBundle();
                    return;
                }
                catch (IllegalStateException illegalStateException) {
                    listener.close0();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.bc != null) {
            Vector<Log> vector = logs;
            synchronized (vector) {
                this.close0();
            }
        }
    }

    private boolean close0() {
        logs.removeElement(this);
        this.isClosed = true;
        if (listener == this) {
            try {
                this.logTracker.close();
                this.logTracker = null;
            }
            catch (IllegalStateException illegalStateException) {}
            Log ls = null;
            while (logs.size() > 0) {
                ls = logs.elementAt(0);
                try {
                    ls.initListener();
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    logs.removeElementAt(0);
                    ls = null;
                }
            }
            listener = ls;
        }
        return listener != null;
    }

    @Override
    public void setPrintOnConsole(boolean value) {
        this.printOnConsole = value;
    }

    @Override
    public void setDebug(boolean value) {
        this.debug = value;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public boolean getPrintOnConsole() {
        return this.printOnConsole;
    }

    public LogService addingService(ServiceReference<LogService> reference) {
        return (LogService)this.bc.getService(reference);
    }

    public void modifiedService(ServiceReference<LogService> reference, LogService service) {
    }

    public void removedService(ServiceReference<LogService> reference, LogService service) {
    }

    public void setMaps(HashIntObjNS map0, HashIntObjNS starts0) {
        this.map = map0;
        this.starts = starts0;
    }

    private String getModuleName(int moduleID) {
        return (String)this.map.get(-moduleID);
    }

    private String getMsgValue(int msgID) {
        String res = (String)this.map.get(msgID);
        if (res == null && this.starts != null) {
            try {
                int startID = (Integer)this.starts.get(msgID);
                res = "END OF " + (String)this.map.get(startID);
            }
            catch (Exception exception) {}
        }
        return res;
    }

    private String buildDebugString(int moduleID, int msgID, String message, String prefix) {
        if (this.map == null) {
            return String.valueOf(prefix) + " [" + moduleID + "] " + msgID + " : " + (message == null ? "" : message);
        }
        StringBuffer sBuf = new StringBuffer(prefix).append("[");
        String module = this.getModuleName(moduleID);
        sBuf.append(module != null ? module : "" + moduleID);
        sBuf.append(chars, 0, 2);
        if (msgID != 0) {
            String msg = this.getMsgValue(msgID);
            sBuf.append(msg != null ? msg : "" + msgID);
        }
        if (message != null) {
            sBuf.append(chars, 2, 2).append(message);
        }
        return sBuf.toString();
    }

    public static boolean security() {
        if (UtilActivator.bc != null) {
            try {
                String ssecurity = UtilActivator.bc.getProperty("equinox.security");
                security = ssecurity != null && !"none".equals(ssecurity);
            }
            catch (Throwable throwable) {}
        } else {
            try {
                String ssecurity = System.getProperty("equinox.security");
                security = ssecurity != null && !"none".equals(ssecurity);
            }
            catch (Throwable throwable) {}
        }
        return security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Log(String baseName, boolean synch, BundleContext bc) {
        this(bc);
        this.baseName = baseName;
        this.synch = synch;
        if (synch) return;
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (queue != null) return;
            queue = new Queue(20);
            saver = new Saver();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(byte[] bytes) {
        if (!this.synch) {
            Queue queue = Log.queue;
            synchronized (queue) {
                Log.queue.put(this);
                Log.queue.put(bytes);
                if (!running) {
                    running = true;
                    UtilActivator.thMan.execute(saver, "File Log Thread");
                }
            }
        } else {
            this.trace(bytes, 0, bytes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void trace(byte[] bytes, int off, int len) {
        Object object;
        if (logsdir == null) {
            object = Log.class;
            // MONITORENTER : org.eclipse.equinox.internal.util.ref.Log.class
            if (logsdir == null) {
                try {
                    logsdir = UtilActivator.bc.getProperty("equinox.logsDir");
                    if (logsdir == null) {
                        logsdir = "./logs";
                    }
                    File logs = new File(logsdir);
                    logs.mkdirs();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            // MONITOREXIT : object
        }
        if (this.fos == null) {
            object = this;
            // MONITORENTER : object
            if (this.fos == null) {
                StringBuffer fname = new StringBuffer(logsdir.length() + this.baseName.length() + 1);
                fname.append(logsdir).append(File.separatorChar).append(this.baseName);
                try {
                    this.fos = new FileOutputStream(fname.toString(), true);
                }
                catch (IOException ioExc) {
                    ioExc.printStackTrace();
                }
            }
            // MONITOREXIT : object
        }
        try {
            this.fos.write(bytes, off, len);
            this.fos.write(10);
            return;
        }
        catch (IOException ioExc) {
            ioExc.printStackTrace();
        }
    }

    public void finalize() {
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException ioExc) {
                ioExc.printStackTrace();
            }
        }
    }

    public boolean isAutoPrintOnConsole() {
        return this.autoPrintOnConsole;
    }

    public void setAutoPrintOnConsole(boolean autoPrintOnConsole) {
        this.autoPrintOnConsole = autoPrintOnConsole;
    }

    public boolean isLogErrorLevel() {
        return this.logErrorLevel;
    }

    @Override
    public Object dispatchPrivileged(int type, Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        switch (type) {
            case 0: {
                this.initListener0();
                break;
            }
            case 1: {
                return this.getService0();
            }
        }
        return null;
    }
}

