/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSInputConversionFactory;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class SkytraqLogConvert
extends GPSLogConvertInterface {
    private boolean passToFindFieldsActivatedInLog = false;
    private int activeFileFields = 131133;
    private static final int[] totalLeapSecond = new int[]{0, 1, 2, 3, 4, 4, 5, 5, 5, 6, 6, 7, 8, 9, 10, 11, 11, 12, 13, 13, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 16};
    private static final int[] leapMonth = new int[]{1, 7, 7, 7, 100, 7, 100, 100, 1, 100, 1, 1, 7, 7, 7, 100, 1, 7, 100, 1, 100, 100, 100, 100, 100, 100, 1, 100, 100, 1, 100};
    private int error;

    public final void setLoggerType(int n) {
        super.setLoggerType(n);
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                this.activeFileFields = 61;
                return;
            }
        }
        this.activeFileFields = 29;
    }

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            object = (WindowedFile)object;
            GPSRecord.getLogFormatRecord(0);
            Object object2 = new GPSInputConversionFactory.1(0);
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(this.getLogFormatRecord$7cd0a50c());
            }
            int n = 0;
            int n2 = 0;
            int n3 = ((WindowedFile)object).getSize();
            while (!this.stop && n2 + 8 + 1 < n3) {
                byte[] byArray;
                int n4 = 4096;
                if (n2 + 4096 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                try {
                    byArray = ((WindowedFile)object).fillBuffer(n2);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    Generic.debug("fillBuffer failed", null);
                    this.errorInfo = ((WindowedFile)object).getPath() + "|" + ((WindowedFile)object).getLastError();
                    return -3;
                }
                n2 += n4;
                block10: while (!this.stop && n5 < n4) {
                    int n6 = 7 & byArray[n5] >> 5;
                    switch (n6) {
                        case 7: {
                            n5 += 2;
                            continue block10;
                        }
                        case 2: 
                        case 3: {
                            Object object3;
                            if (n5 + 18 <= n4) {
                                int n7 = n5;
                                object3 = byArray;
                                GPSInputConversionFactory.1 var12_16 = new GPSInputConversionFactory.1(0);
                                new GPSInputConversionFactory.1(0).speed = ((object3[n7] & 3) << 8) + (object3[n7 + 1] & 0xFF);
                                var12_16.tow = ((object3[n7 + 4] & 0xFF) << 12) + ((object3[n7 + 5] & 0xFF) << 4) + (object3[n7 + 2] >> 4 & 0xF);
                                var12_16.wn = ((object3[n7 + 2] & 3) << 8) + (object3[n7 + 3] & 0xFF);
                                var12_16.x = ((object3[n7 + 6] & 0xFF) << 8) + (object3[n7 + 7] & 0xFF) + ((object3[n7 + 8] & 0xFF) << 24) + ((object3[n7 + 9] & 0xFF) << 16);
                                var12_16.y = ((object3[n7 + 10] & 0xFF) << 8) + (object3[n7 + 11] & 0xFF) + ((object3[n7 + 12] & 0xFF) << 24) + ((object3[n7 + 13] & 0xFF) << 16);
                                var12_16.z = ((object3[n7 + 14] & 0xFF) << 8) + (object3[n7 + 15] & 0xFF) + ((object3[n7 + 16] & 0xFF) << 24) + ((object3[n7 + 17] & 0xFF) << 16);
                                object2 = var12_16;
                                object3 = SkytraqLogConvert.toGpsRecord$46a100df((GPSInputConversionFactory.1)object2);
                                SkytraqLogConvert.toGpsRecord$46a100df((GPSInputConversionFactory.1)object2).rcr = 1;
                                object3.rcr = n6 == 2 ? 1 : 8;
                                object3.recCount = ++n;
                                gPSFileConverterInterface.addLogRecord((GPSRecord)object3);
                                break;
                            }
                            n2 += n5 - n4;
                            n4 = n5;
                            continue block10;
                        }
                        case 4: {
                            Object object3;
                            if (n5 + 8 <= n4) {
                                GPSInputConversionFactory.1 v0 = object2;
                                n6 = n5;
                                object2 = byArray;
                                object3 = v0;
                                v0.speed = ((object2[n6] & 3) << 8) + (object2[n6 + 1] & 0xFF);
                                int n8 = ((object2[n6 + 2] & 0xFF) << 8) + (object2[n6 + 3] & 0xFF);
                                int n9 = ((object2[n6 + 4] & 0xFF) << 2) + ((object2[n6 + 5] & 0xC0) >> 6);
                                int n10 = (object2[n6 + 5] & 0x3F) + ((object2[n6 + 6] & 0xF0) << 2);
                                int n11 = ((object2[n6 + 6] & 3) << 8) + (object2[n6 + 7] & 0xFF);
                                if ((n9 & 0x200) != 0) {
                                    n9 = 511 - n9;
                                }
                                if ((n10 & 0x200) != 0) {
                                    n10 = 511 - n10;
                                }
                                if ((n11 & 0x200) != 0) {
                                    n11 = 511 - n11;
                                }
                                object3.tow += n8;
                                object3.x += n9;
                                object3.y += n10;
                                object3.z += n11;
                                object2 = object3;
                                object3 = SkytraqLogConvert.toGpsRecord$46a100df((GPSInputConversionFactory.1)object3);
                                v1.rcr = 1;
                                object3.recCount = ++n;
                                gPSFileConverterInterface.addLogRecord((GPSRecord)object3);
                                n5 += 8;
                                continue block10;
                            }
                            n2 += n5 - n4;
                            n4 = n5;
                            continue block10;
                        }
                    }
                    n5 += 18;
                }
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    private static final GPSRecord toGpsRecord$46a100df(GPSInputConversionFactory.1 var0) {
        int n;
        GPSRecord gPSRecord = new GPSRecord();
        double d = var0.z;
        double d2 = var0.y;
        double d3 = var0.x;
        Object object = gPSRecord;
        double d4 = d3 * d3 + d2 * d2;
        double d5 = d * 2.182048199171718E15 * d;
        double d6 = Math.sqrt(d4);
        double d7 = d4 + d * 0.9933056200098587 * d - 1.8230912546094608E9;
        double d8 = d5 * 4.481472345240445E-5 * d4 / (d7 * d7 * d7);
        double d9 = Generic.pow(d8 + 1.0 + Math.sqrt(d8 * d8 + d8 * 2.0), 0.3333333333333333);
        double d10 = d5 / (3.0 * (d9 + 1.0 / d9 + 1.0) * (d9 + 1.0 / d9 + 1.0) * d7 * d7);
        double d11 = Math.sqrt(1.0 + d10 * 8.96294469048089E-5);
        double d12 = -(d10 * 0.0066943799901413165 * d6) / (d11 + 1.0) + Math.sqrt(2.03403157953845E13 * (1.0 + 1.0 / d11) - d10 * 0.9933056200098587 * d * d / (d11 * (d11 + 1.0)) - d10 * d4 / 2.0);
        double d13 = (d6 - d12 * 0.0066943799901413165) * (d6 - d12 * 0.0066943799901413165);
        double d14 = Math.sqrt(d13 + d * d);
        double d15 = Math.sqrt(d13 + d * 0.9933056200098587 * d);
        double d16 = d * 4.0408299984661445E13 / (d15 * 6378137.0);
        float f = (float)(d14 * (1.0 - 4.0408299984661445E13 / (d15 * 6378137.0)));
        double d17 = JavaLibBridge.atan((d + d16 * 0.006739496742276434) / d6);
        double d18 = JavaLibBridge.atan2(d2, d3);
        ((GPSRecord)object).setLongitude(d18 * 180.0 / Math.PI);
        ((GPSRecord)object).setLatitude(d17 * 180.0 / Math.PI);
        ((GPSRecord)object).setHeight(f);
        JavaLibBridge.getDateInstance(1, 1, 1970).advance(10825 + var0.wn * 7);
        object = JavaLibBridge.getTimeInstance();
        int n2 = 935280000 + var0.wn * 7 * 24 * 3600 + var0.tow;
        object.setUTCTime(n2);
        int n3 = object.getMonth();
        int n4 = object.getYear() - 1980;
        if (n4 > 0) {
            if (n4 < 31) {
                n = totalLeapSecond[n4];
                if (n3 >= leapMonth[n4]) {
                    ++n;
                }
            } else {
                n = totalLeapSecond[30];
            }
        } else {
            n = 0;
        }
        gPSRecord.setUtc(n2 -= n);
        gPSRecord.setSpeed(var0.speed);
        return gPSRecord;
    }

    protected final Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(4096);
                this.errorInfo = bT747Path.toString() + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected final void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public final int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            object = this.getFileObject((BT747Path)object);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(this.getLogFormatRecord$7cd0a50c());
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    private GPSRecord getLogFormatRecord$7cd0a50c() {
        int n = 45;
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                n = 61;
            }
        }
        return GPSRecord.getLogFormatRecord(n);
    }

    public final int getType() {
        return 10;
    }
}

