Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var WindowPanelView = (function () {
  function WindowPanelView() {
    _classCallCheck(this, WindowPanelView);

    _etch2['default'].initialize(this);

    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.tooltips.add(this.refs.shellTiming, { title: 'The time taken to launch the app' }));
    this.disposables.add(atom.tooltips.add(this.refs.windowTiming, { title: 'The time taken to load this window' }));
    this.disposables.add(atom.tooltips.add(this.refs.projectTiming, { title: 'The time taken to rebuild the previously opened buffers' }));
    this.disposables.add(atom.tooltips.add(this.refs.workspaceTiming, { title: 'The time taken to rebuild the previously opened editors' }));
  }

  _createClass(WindowPanelView, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'render',
    value: function render() {
      return _etch2['default'].dom(
        'div',
        { className: 'tool-panel padded package-panel' },
        _etch2['default'].dom(
          'div',
          { className: 'inset-panel' },
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            'Startup Time'
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-body padded' },
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'shellTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Shell load time'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'shellLoadTime' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { className: 'timing', ref: 'windowTiming' },
              _etch2['default'].dom(
                'span',
                { className: 'inline-block' },
                'Window load time'
              ),
              _etch2['default'].dom(
                'span',
                { className: 'inline-block', ref: 'windowLoadTime' },
                'Loading…'
              )
            ),
            _etch2['default'].dom(
              'div',
              { ref: 'deserializeTimings' },
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'projectTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Project load time'
                ),
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block', ref: 'projectLoadTime' },
                  'Loading…'
                )
              ),
              _etch2['default'].dom(
                'div',
                { className: 'timing', ref: 'workspaceTiming' },
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block' },
                  'Workspace load time'
                ),
                _etch2['default'].dom(
                  'span',
                  { className: 'inline-block', ref: 'workspaceLoadTime' },
                  'Loading…'
                )
              )
            )
          )
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      var time = atom.getWindowLoadTime();
      this.refs.windowLoadTime.classList.add(this.getHighlightClass(time));
      this.refs.windowLoadTime.textContent = time + 'ms';

      var _atom$getLoadSettings = atom.getLoadSettings();

      var shellLoadTime = _atom$getLoadSettings.shellLoadTime;

      if (shellLoadTime != null) {
        this.refs.shellLoadTime.classList.add(this.getHighlightClass(shellLoadTime));
        this.refs.shellLoadTime.textContent = shellLoadTime + 'ms';
      } else {
        this.refs.shellTiming.style.display = 'none';
      }

      if (atom.deserializeTimings.project != null) {
        // Project and workspace timings only exist if the current project was previously opened
        this.refs.projectLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.project));
        this.refs.projectLoadTime.textContent = atom.deserializeTimings.project + 'ms';
        this.refs.workspaceLoadTime.classList.add(this.getHighlightClass(atom.deserializeTimings.workspace));
        this.refs.workspaceLoadTime.textContent = atom.deserializeTimings.workspace + 'ms';
      } else {
        this.refs.deserializeTimings.style.display = 'none';
      }
    }
  }, {
    key: 'getHighlightClass',
    value: function getHighlightClass(time) {
      if (time > 1000) {
        return 'highlight-error';
      } else if (time > 800) {
        return 'highlight-warning';
      } else {
        return 'highlight-info';
      }
    }
  }]);

  return WindowPanelView;
})();

exports['default'] = WindowPanelView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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