"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorTile extends _react.default.Component {
  componentDidMount() {
    // eslint-disable-next-line no-console
    console.error('Error encountered in subquery', this.props.error);
  }

  render() {
    return _react.default.createElement("div", {
      className: "github-QueryErrorTile"
    }, _react.default.createElement("div", {
      className: "github-QueryErrorTile-messages"
    }, this.renderMessages()));
  }

  renderMessages() {
    if (this.props.error.errors) {
      return this.props.error.errors.map((error, index) => {
        return this.renderMessage(error.message, index);
      });
    }

    if (this.props.error.response) {
      return this.renderMessage(this.props.error.responseText, '0');
    }

    return this.renderMessage(this.props.error.toString(), '0');
  }

  renderMessage(body, key) {
    return _react.default.createElement("p", {
      key: key,
      className: "github-QueryErrorTile-message"
    }, _react.default.createElement(_octicon.default, {
      icon: "alert"
    }), body);
  }

}

exports.default = QueryErrorTile;

_defineProperty(QueryErrorTile, "propTypes", {
  error: _propTypes.default.shape({
    response: _propTypes.default.shape({
      status: _propTypes.default.number.isRequired
    }),
    responseText: _propTypes.default.string,
    errors: _propTypes.default.arrayOf(_propTypes.default.shape({
      message: _propTypes.default.string.isRequired
    }))
  }).isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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