"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _markerTools = require("./marker-tools");

class Banner {
  constructor(editor, marker, description, originalText) {
    this.editor = editor;
    this.marker = marker;
    this.description = description;
    this.originalText = originalText;
  }

  getMarker() {
    return this.marker;
  }

  getRange() {
    return this.marker.getBufferRange();
  }

  isModified() {
    const chomp = line => line.replace(/\r?\n$/, '');

    const text = this.editor.getTextInBufferRange(this.marker.getBufferRange());
    return chomp(text) !== chomp(this.originalText);
  }

  revert() {
    const range = this.getMarker().getBufferRange();
    this.editor.setTextInBufferRange(range, this.originalText);
    this.getMarker().setBufferRange(range);
  }

  delete() {
    (0, _markerTools.deleteMarkerIn)(this.getMarker(), this.editor);
  }

}

exports.default = Banner;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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