"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _commitPreviewContainer = _interopRequireDefault(require("../containers/commit-preview-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommitPreviewItem extends _react.default.Component {
  static buildURI(workingDirectory) {
    return `atom-github://commit-preview?workdir=${encodeURIComponent(workingDirectory)}`;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.refInitialFocus = new _refHolder.default();
    this.refEditor = new _refHolder.default();
    this.refEditor.observe(editor => {
      this.emitter.emit('did-change-embedded-text-editor', editor);
    });
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react.default.createElement(_commitPreviewContainer.default, _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refEditor: this.refEditor,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return 'Staged Changes';
  }

  getIconName() {
    return 'tasklist';
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  serialize() {
    return {
      deserializer: 'CommitPreviewStub',
      uri: CommitPreviewItem.buildURI(this.props.workingDirectory)
    };
  }

  focus() {
    this.refInitialFocus.map(focusable => focusable.focus());
  }

}

exports.default = CommitPreviewItem;

_defineProperty(CommitPreviewItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes.default.string.isRequired,
  discardLines: _propTypes.default.func.isRequired,
  undoLastDiscard: _propTypes.default.func.isRequired,
  surfaceToCommitPreviewButton: _propTypes.default.func.isRequired
});

_defineProperty(CommitPreviewItem, "uriPattern", 'atom-github://commit-preview?workdir={workingDirectory}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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