/*
 * Decompiled with CFR 0.152.
 */
package jportmidi;

import jportmidi.JPortMidiApi;
import jportmidi.JPortMidiException;

public class JPortMidi {
    public final int NOW = 0;
    public final int MIDI_NOTE_OFF = 128;
    public final int MIDI_NOTE_ON = 144;
    public final int CTRL_ALL_OFF = 123;
    public final int MIDI_PITCH_BEND = 224;
    public final int MIDI_CLOCK = 248;
    public final int MIDI_CONTROL = 176;
    public final int MIDI_PROGRAM = 192;
    public final int MIDI_START = 250;
    public final int MIDI_STOP = 252;
    public final int MIDI_POLY_TOUCH = 160;
    public final int MIDI_TOUCH = 208;
    public final int pmStreamOpen = -5000;
    public final int pmOutputNotOpen = -4999;
    private static JPortMidiApi pm;
    private static int pmRefCount;
    private static int openCount;
    public int error;
    private JPortMidiApi.PortMidiStream input;
    private JPortMidiApi.PortMidiStream output;
    private JPortMidiApi.PmEvent buffer;
    protected int timestamp;
    protected boolean trace = false;
    private byte[] sysexBuffer = null;
    private int sysexBufferIndex = 0;

    public JPortMidi() throws JPortMidiException {
        if (pmRefCount == 0) {
            pm = new JPortMidiApi();
            ++pmRefCount;
            System.out.println("Calling Pm_Initialize");
            this.checkError(pm.Pm_Initialize());
            System.out.println("Called Pm_Initialize");
        }
        this.buffer = new JPortMidiApi.PmEvent();
    }

    public boolean getTrace() {
        return this.trace;
    }

    public boolean setTrace(boolean bl) {
        boolean bl2 = this.trace;
        this.trace = bl;
        return bl2;
    }

    public void refreshDeviceLists() throws JPortMidiException {
        if (openCount > 0) {
            throw new JPortMidiException(-5000, "RefreshDeviceLists called while stream is open");
        }
        this.checkError(pm.Pm_Terminate());
        this.checkError(pm.Pm_Initialize());
    }

    public void finalize() {
        if (this.input != null) {
            this.error = JPortMidiApi.Pm_Close(this.input);
        }
        if (this.input != null) {
            int n = JPortMidiApi.Pm_Close(this.output);
            pm.getClass();
            if (this.error == 0) {
                this.error = n;
            }
        }
        if (--pmRefCount == 0) {
            this.error = pm.Pm_Terminate();
        }
    }

    int checkError(int n) throws JPortMidiException {
        pm.getClass();
        if (n >= 0) {
            return n;
        }
        pm.getClass();
        if (n == -10000) {
            throw new JPortMidiException(n, pm.Pm_GetHostErrorText());
        }
        throw new JPortMidiException(n, JPortMidiApi.Pm_GetErrorText(n));
    }

    public void timeStart(int n) throws JPortMidiException {
        this.checkError(JPortMidiApi.Pt_TimeStart(n));
    }

    public void timeStop() throws JPortMidiException {
        this.checkError(pm.Pt_TimeStop());
    }

    public int timeGet() {
        return pm.Pt_Time();
    }

    public boolean timeStarted() {
        return pm.Pt_TimeStarted();
    }

    public int countDevices() throws JPortMidiException {
        return this.checkError(pm.Pm_CountDevices());
    }

    public int getDefaultInputDeviceID() throws JPortMidiException {
        return this.checkError(pm.Pm_GetDefaultInputDeviceID());
    }

    public int getDefaultOutputDeviceID() throws JPortMidiException {
        return this.checkError(pm.Pm_GetDefaultOutputDeviceID());
    }

    public String getDeviceInterf(int n) {
        return JPortMidiApi.Pm_GetDeviceInterf(n);
    }

    public String getDeviceName(int n) {
        return JPortMidiApi.Pm_GetDeviceName(n);
    }

    public boolean getDeviceInput(int n) {
        return JPortMidiApi.Pm_GetDeviceInput(n);
    }

    public boolean getDeviceOutput(int n) {
        return JPortMidiApi.Pm_GetDeviceOutput(n);
    }

    public boolean isOpenInput() {
        return this.input != null;
    }

    public void openInput(int n, int n2) throws JPortMidiException {
        this.openInput(n, "", n2);
    }

    public void openInput(int n, String string, int n2) throws JPortMidiException {
        if (this.isOpenInput()) {
            JPortMidiApi.Pm_Close(this.input);
        } else {
            this.input = new JPortMidiApi.PortMidiStream();
        }
        if (this.trace) {
            System.out.println("openInput " + this.getDeviceName(n));
        }
        this.checkError(JPortMidiApi.Pm_OpenInput(this.input, n, string, n2));
        ++openCount;
    }

    public boolean isOpenOutput() {
        return this.output != null;
    }

    public void openOutput(int n, int n2, int n3) throws JPortMidiException {
        this.openOutput(n, "", n2, n3);
    }

    public void openOutput(int n, String string, int n2, int n3) throws JPortMidiException {
        if (this.isOpenOutput()) {
            JPortMidiApi.Pm_Close(this.output);
        } else {
            this.output = new JPortMidiApi.PortMidiStream();
        }
        if (this.trace) {
            System.out.println("openOutput " + this.getDeviceName(n));
        }
        this.checkError(JPortMidiApi.Pm_OpenOutput(this.output, n, string, n2, n3));
        ++openCount;
    }

    public void setFilter(int n) throws JPortMidiException {
        if (this.input == null) {
            return;
        }
        this.checkError(JPortMidiApi.Pm_SetFilter(this.input, n));
    }

    public void setChannelMask(int n) throws JPortMidiException {
        if (this.input == null) {
            return;
        }
        this.checkError(JPortMidiApi.Pm_SetChannelMask(this.input, n));
    }

    public void abort() throws JPortMidiException {
        if (this.output == null) {
            return;
        }
        this.checkError(JPortMidiApi.Pm_Abort(this.output));
    }

    public void closeInput() throws JPortMidiException {
        if (this.input == null) {
            return;
        }
        this.checkError(JPortMidiApi.Pm_Close(this.input));
        this.input = null;
        --openCount;
    }

    public void closeOutput() throws JPortMidiException {
        if (this.output == null) {
            return;
        }
        this.checkError(JPortMidiApi.Pm_Close(this.output));
        this.output = null;
        --openCount;
    }

    public void poll() throws JPortMidiException {
        if (this.input == null) {
            return;
        }
        while (true) {
            int n = JPortMidiApi.Pm_Read(this.input, this.buffer);
            this.checkError(n);
            if (n == 0) {
                return;
            }
            this.handleMidiIn(this.buffer);
        }
    }

    public void writeShort(int n, int n2) throws JPortMidiException {
        if (this.output == null) {
            throw new JPortMidiException(-4999, "Output stream not open");
        }
        if (this.trace) {
            System.out.println("writeShort: " + Integer.toHexString(n2));
        }
        this.checkError(JPortMidiApi.Pm_WriteShort(this.output, n, n2));
    }

    public void writeSysEx(int n, byte[] byArray) throws JPortMidiException {
        if (this.output == null) {
            throw new JPortMidiException(-4999, "Output stream not open");
        }
        if (this.trace) {
            System.out.print("writeSysEx: ");
            for (int i = 0; i < byArray.length; ++i) {
                System.out.print(Integer.toHexString(byArray[i]));
            }
            System.out.print("\n");
        }
        this.checkError(JPortMidiApi.Pm_WriteSysEx(this.output, n, byArray));
    }

    public int midiChanMessage(int n, int n2, int n3, int n4) {
        return n4 << 16 & 0xFF0000 | n3 << 8 & 0xFF00 | n2 & 0xF0 | n & 0xF;
    }

    public int midiMessage(int n, int n2, int n3) {
        return n3 << 16 & 0xFF0000 | n2 << 8 & 0xFF00 | n & 0xFF;
    }

    public void midiAllOff(int n) throws JPortMidiException {
        this.midiAllOff(n, 0);
    }

    public void midiAllOff(int n, int n2) throws JPortMidiException {
        this.writeShort(n2, this.midiChanMessage(n, 176, 123, 0));
    }

    public void midiPitchBend(int n, int n2) throws JPortMidiException {
        this.midiPitchBend(n, n2, 0);
    }

    public void midiPitchBend(int n, int n2, int n3) throws JPortMidiException {
        this.writeShort(n3, this.midiChanMessage(n, 224, n2, n2 >> 7));
    }

    public void midiClock() throws JPortMidiException {
        this.midiClock(0);
    }

    public void midiClock(int n) throws JPortMidiException {
        this.writeShort(n, this.midiMessage(248, 0, 0));
    }

    public void midiControl(int n, int n2, int n3) throws JPortMidiException {
        this.midiControl(n, n2, n3, 0);
    }

    public void midiControl(int n, int n2, int n3, int n4) throws JPortMidiException {
        this.writeShort(n4, this.midiChanMessage(n, 176, n2, n3));
    }

    public void midiNote(int n, int n2, int n3) throws JPortMidiException {
        this.midiNote(n, n2, n3, 0);
    }

    public void midiNote(int n, int n2, int n3, int n4) throws JPortMidiException {
        this.writeShort(n4, this.midiChanMessage(n, 144, n2, n3));
    }

    public void midiProgram(int n, int n2) throws JPortMidiException {
        this.midiProgram(n, n2, 0);
    }

    public void midiProgram(int n, int n2, int n3) throws JPortMidiException {
        this.writeShort(n3, this.midiChanMessage(n, 192, n2, 0));
    }

    public void midiStart() throws JPortMidiException {
        this.midiStart(0);
    }

    public void midiStart(int n) throws JPortMidiException {
        this.writeShort(n, this.midiMessage(250, 0, 0));
    }

    public void midiStop() throws JPortMidiException {
        this.midiStop(0);
    }

    public void midiStop(int n) throws JPortMidiException {
        this.writeShort(n, this.midiMessage(252, 0, 0));
    }

    public void midiPolyTouch(int n, int n2, int n3) throws JPortMidiException {
        this.midiPolyTouch(n, n2, n3, 0);
    }

    public void midiPolyTouch(int n, int n2, int n3, int n4) throws JPortMidiException {
        this.writeShort(n4, this.midiChanMessage(n, 160, n2, n3));
    }

    public void midiTouch(int n, int n2) throws JPortMidiException {
        this.midiTouch(n, n2, 0);
    }

    public void midiTouch(int n, int n2, int n3) throws JPortMidiException {
        this.writeShort(n3, this.midiChanMessage(n, 208, n2, 0));
    }

    void sysexBufferReset() {
        this.sysexBufferIndex = 0;
        if (this.sysexBuffer == null) {
            this.sysexBuffer = new byte[256];
        }
    }

    void sysexBufferCheck() {
        if (this.sysexBuffer.length < this.sysexBufferIndex + 4) {
            byte[] byArray = new byte[this.sysexBuffer.length * 2];
            for (int i = 0; i < this.sysexBufferIndex; ++i) {
                byArray[i] = this.sysexBuffer[i];
            }
            this.sysexBuffer = byArray;
        }
    }

    void sysexBufferAppendStatus(byte by) {
        this.sysexBuffer[this.sysexBufferIndex++] = by;
    }

    void sysexBufferAppendBytes(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byte by = (byte)n;
            if ((n & 0x80) != 0) {
                if (by == 247) {
                    this.sysexBufferAppendStatus(by);
                    this.sysex(this.sysexBuffer, this.sysexBufferIndex);
                    return;
                }
                JPortMidiApi.PmEvent pmEvent = new JPortMidiApi.PmEvent();
                pmEvent.timestamp = this.timestamp;
                pmEvent.message = by;
                this.handleMidiIn(pmEvent);
            } else {
                this.sysexBuffer[this.sysexBufferIndex++] = by;
            }
            n >>= 8;
        }
    }

    void sysexBegin(int n) {
        this.sysexBufferReset();
        this.sysexBufferAppendStatus((byte)(n & 0xFF));
        this.sysexBufferAppendBytes(n >> 8, 3);
    }

    public void handleMidiIn(JPortMidiApi.PmEvent pmEvent) {
        if (this.trace) {
            System.out.println("handleMidiIn: " + Integer.toHexString(pmEvent.message));
        }
        this.timestamp = pmEvent.timestamp;
        int n = pmEvent.message & 0xFF;
        if (n < 128) {
            this.sysexBufferCheck();
            this.sysexBufferAppendBytes(pmEvent.message, 4);
            return;
        }
        int n2 = n & 0xF0;
        int n3 = n & 0xF;
        int n4 = pmEvent.message >> 8 & 0xFF;
        int n5 = pmEvent.message >> 16 & 0xFF;
        block0 : switch (n2) {
            case 128: {
                this.noteOff(n3, n4, n5);
                break;
            }
            case 144: {
                if (n5 > 0) {
                    this.noteOn(n3, n4, n5);
                    break;
                }
                this.noteOff(n3, n4);
                break;
            }
            case 176: {
                this.control(n3, n4, n5);
                break;
            }
            case 160: {
                this.polyTouch(n3, n4, n5);
                break;
            }
            case 208: {
                this.touch(n3, n4);
                break;
            }
            case 224: {
                this.pitchBend(n3, n4 + (n5 << 7) - 8192);
                break;
            }
            case 192: {
                this.program(n3, n4);
                break;
            }
            case 240: {
                switch (n3) {
                    case 0: {
                        this.sysexBegin(pmEvent.message);
                        break block0;
                    }
                    case 1: {
                        this.mtcQuarterFrame(n4);
                    }
                    case 2: {
                        this.songPosition(n4 + (n5 << 7));
                        break block0;
                    }
                    case 3: {
                        this.songSelect(n4);
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        break block0;
                    }
                    case 6: {
                        this.tuneRequest();
                        break block0;
                    }
                    case 7: {
                        this.sysexBufferAppendBytes(pmEvent.message, pmEvent.message);
                        break block0;
                    }
                    case 8: {
                        this.clock();
                        break block0;
                    }
                    case 9: {
                        this.tick();
                        break block0;
                    }
                    case 10: {
                        this.clockStart();
                        break block0;
                    }
                    case 11: {
                        this.clockContinue();
                        break block0;
                    }
                    case 12: {
                        this.clockStop();
                        break block0;
                    }
                    case 13: {
                        break block0;
                    }
                    case 14: {
                        this.activeSense();
                        break block0;
                    }
                    case 15: {
                        this.reset();
                    }
                }
            }
        }
    }

    void pitchBend(int n, int n2) {
    }

    void control(int n, int n2, int n3) {
    }

    void noteOn(int n, int n2, int n3) {
    }

    void noteOff(int n, int n2, int n3) {
        this.noteOff(n, n2);
    }

    void noteOff(int n, int n2) {
    }

    void program(int n, int n2) {
    }

    void sysex(byte[] byArray, int n) {
    }

    void polyTouch(int n, int n2, int n3) {
    }

    void touch(int n, int n2) {
    }

    void mtcQuarterFrame(int n) {
    }

    void songPosition(int n) {
    }

    void songSelect(int n) {
    }

    void tuneRequest() {
    }

    void clock() {
    }

    void tick() {
    }

    void clockStart() {
    }

    void clockStop() {
    }

    void clockContinue() {
    }

    void activeSense() {
    }

    void reset() {
    }

    static {
        pmRefCount = 0;
        openCount = 0;
    }
}

