/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class AdaptiveCoding
implements CodingMethod {
    CodingMethod headCoding;
    int headLength;
    CodingMethod tailCoding;
    public static final int KX_MIN = 0;
    public static final int KX_MAX = 3;
    public static final int KX_LG2BASE = 4;
    public static final int KX_BASE = 16;
    public static final int KB_MIN = 0;
    public static final int KB_MAX = 255;
    public static final int KB_OFFSET = 1;
    public static final int KB_DEFAULT = 3;

    public AdaptiveCoding(int headLength, CodingMethod headCoding, CodingMethod tailCoding) {
        assert (AdaptiveCoding.isCodableLength(headLength));
        this.headLength = headLength;
        this.headCoding = headCoding;
        this.tailCoding = tailCoding;
    }

    public void setHeadCoding(CodingMethod headCoding) {
        this.headCoding = headCoding;
    }

    public void setHeadLength(int headLength) {
        assert (AdaptiveCoding.isCodableLength(headLength));
        this.headLength = headLength;
    }

    public void setTailCoding(CodingMethod tailCoding) {
        this.tailCoding = tailCoding;
    }

    public boolean isTrivial() {
        return this.headCoding == this.tailCoding;
    }

    @Override
    public void writeArrayTo(OutputStream out, int[] a, int start, int end) throws IOException {
        AdaptiveCoding.writeArray(this, out, a, start, end);
    }

    private static void writeArray(AdaptiveCoding run, OutputStream out, int[] a, int start, int end) throws IOException {
        while (true) {
            int mid = start + run.headLength;
            assert (mid <= end);
            run.headCoding.writeArrayTo(out, a, start, mid);
            start = mid;
            if (!(run.tailCoding instanceof AdaptiveCoding)) break;
            run = (AdaptiveCoding)run.tailCoding;
        }
        run.tailCoding.writeArrayTo(out, a, start, end);
    }

    @Override
    public void readArrayFrom(InputStream in, int[] a, int start, int end) throws IOException {
        AdaptiveCoding.readArray(this, in, a, start, end);
    }

    private static void readArray(AdaptiveCoding run, InputStream in, int[] a, int start, int end) throws IOException {
        while (true) {
            int mid = start + run.headLength;
            assert (mid <= end);
            run.headCoding.readArrayFrom(in, a, start, mid);
            start = mid;
            if (!(run.tailCoding instanceof AdaptiveCoding)) break;
            run = (AdaptiveCoding)run.tailCoding;
        }
        run.tailCoding.readArrayFrom(in, a, start, end);
    }

    static int getKXOf(int K) {
        for (int KX = 0; KX <= 3; ++KX) {
            if ((K - 1 & 0xFFFFFF00) == 0) {
                return KX;
            }
            K >>>= 4;
        }
        return -1;
    }

    static int getKBOf(int K) {
        int KX = AdaptiveCoding.getKXOf(K);
        if (KX < 0) {
            return -1;
        }
        return (K >>>= KX * 4) - 1;
    }

    static int decodeK(int KX, int KB) {
        assert (0 <= KX && KX <= 3);
        assert (0 <= KB && KB <= 255);
        return KB + 1 << KX * 4;
    }

    static int getNextK(int K) {
        if (K <= 0) {
            return 1;
        }
        int KX = AdaptiveCoding.getKXOf(K);
        if (KX < 0) {
            return Integer.MAX_VALUE;
        }
        int unit = 1 << KX * 4;
        int mask = 255 << KX * 4;
        int K1 = K + unit;
        if (((K1 &= ~(unit - 1)) - unit & ~mask) == 0) {
            assert (AdaptiveCoding.getKXOf(K1) == KX);
            return K1;
        }
        if (KX == 3) {
            return Integer.MAX_VALUE;
        }
        int mask2 = 255 << ++KX * 4;
        K1 |= mask & ~mask2;
        assert (AdaptiveCoding.getKXOf(K1 += unit) == KX);
        return K1;
    }

    public static boolean isCodableLength(int K) {
        int KX = AdaptiveCoding.getKXOf(K);
        if (KX < 0) {
            return false;
        }
        int unit = 1 << KX * 4;
        int mask = 255 << KX * 4;
        return (K - unit & ~mask) == 0;
    }

    @Override
    public byte[] getMetaCoding(Coding dflt) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(10);
        try {
            AdaptiveCoding.makeMetaCoding(this, dflt, bytes);
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        return bytes.toByteArray();
    }

    private static void makeMetaCoding(AdaptiveCoding run, Coding dflt, ByteArrayOutputStream bytes) throws IOException {
        block7: {
            int BDef;
            CodingMethod tailCoding;
            while (true) {
                CodingMethod headCoding = run.headCoding;
                int headLength = run.headLength;
                tailCoding = run.tailCoding;
                int K = headLength;
                assert (AdaptiveCoding.isCodableLength(K));
                int ADef = headCoding == dflt ? 1 : 0;
                int n = BDef = tailCoding == dflt ? 1 : 0;
                if (ADef + BDef > 1) {
                    BDef = 0;
                }
                int ABDef = 1 * ADef + 2 * BDef;
                assert (ABDef < 3);
                int KX = AdaptiveCoding.getKXOf(K);
                int KB = AdaptiveCoding.getKBOf(K);
                assert (AdaptiveCoding.decodeK(KX, KB) == K);
                int KBFlag = KB != 3 ? 1 : 0;
                bytes.write(117 + KX + 4 * KBFlag + 8 * ABDef);
                if (KBFlag != 0) {
                    bytes.write(KB);
                }
                if (ADef == 0) {
                    bytes.write(headCoding.getMetaCoding(dflt));
                }
                if (!(tailCoding instanceof AdaptiveCoding)) break;
                run = (AdaptiveCoding)tailCoding;
            }
            if (BDef != 0) break block7;
            bytes.write(tailCoding.getMetaCoding(dflt));
        }
    }

    public static int parseMetaCoding(byte[] bytes, int pos, Coding dflt, CodingMethod[] res) {
        int op;
        if ((op = bytes[pos++] & 0xFF) < 117 || op >= 141) {
            return pos - 1;
        }
        AdaptiveCoding prevc = null;
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            assert (op >= 117);
            int KX = (op -= 117) % 4;
            int KBFlag = op / 4 % 2;
            int ABDef = op / 8;
            assert (ABDef < 3);
            int ADef = ABDef & 1;
            int BDef = ABDef & 2;
            CodingMethod[] ACode = new CodingMethod[]{dflt};
            CodingMethod[] BCode = new CodingMethod[]{dflt};
            int KB = 3;
            if (KBFlag != 0) {
                KB = bytes[pos++] & 0xFF;
            }
            if (ADef == 0) {
                pos = BandStructure.parseMetaCoding(bytes, pos, dflt, ACode);
            }
            if (BDef == 0 && (op = bytes[pos] & 0xFF) >= 117 && op < 141) {
                ++pos;
                keepGoing = true;
            } else if (BDef == 0) {
                pos = BandStructure.parseMetaCoding(bytes, pos, dflt, BCode);
            }
            AdaptiveCoding newc = new AdaptiveCoding(AdaptiveCoding.decodeK(KX, KB), ACode[0], BCode[0]);
            if (prevc == null) {
                res[0] = newc;
            } else {
                prevc.tailCoding = newc;
            }
            prevc = newc;
        }
        return pos;
    }

    private String keyString(CodingMethod m) {
        if (m instanceof Coding) {
            return ((Coding)m).keyString();
        }
        return m.toString();
    }

    public String toString() {
        StringBuilder res = new StringBuilder(20);
        AdaptiveCoding run = this;
        res.append("run(");
        while (true) {
            res.append(run.headLength).append("*");
            res.append(this.keyString(run.headCoding));
            if (!(run.tailCoding instanceof AdaptiveCoding)) break;
            run = (AdaptiveCoding)run.tailCoding;
            res.append(" ");
        }
        res.append(" **").append(this.keyString(run.tailCoding));
        res.append(")");
        return res.toString();
    }
}

